/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.physics;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_3532;
import net.oxcodsnet.beltborne_lanterns.common.physics.LanternSwingState;

public final class LanternSwingManager {
    private static final float DEFAULT_OMEGA = 7.0f;
    private static final float DEFAULT_ZETA = 0.42f;
    private static final float K_YAW = 3.2f;
    private static final float K_HSPEED = 0.15f;
    private static final float K_HACCEL = 1.25f;
    private static final float K_YACCEL = 0.22f;
    private static final float K_STRAFE_A = 1.4f;
    private static final float K_STRAFE_V = 0.25f;
    private static final float IMPULSE_JUMP_X = -1.3f;
    private static final float IMPULSE_LAND_X = 1.8f;
    private static final float IMPULSE_CROUCH_X = 0.6f;
    private static final float IMPULSE_UNCROUCH_X = -0.4f;
    private static final float IMPULSE_START_MOVE_X = -0.55f;
    private static final float IMPULSE_STOP_MOVE_X = 0.4f;
    private static final double MOVE_THRESHOLD_BPS = 1.6;
    private static final double JUMP_THRESHOLD_B_TICK = 0.08;
    private static final double LAND_THRESHOLD_B_TICK = -0.08;
    private static final float SNEAK_BASE_ROT_X_DEG = 215.0f;
    private static final float SNEAK_BLEND_TAU_SEC = 0.15f;
    private static final Map<UUID, LanternSwingState> STATES = new ConcurrentHashMap<UUID, LanternSwingState>();
    private static final Map<UUID, Kinematics> KIN = new ConcurrentHashMap<UUID, Kinematics>();

    private LanternSwingManager() {
    }

    private static LanternSwingState getOrCreate(UUID id) {
        return STATES.computeIfAbsent(id, u -> new LanternSwingState(7.0f, 0.42f));
    }

    public static void tickPlayer(class_1657 p, float dtSec, float baseRotXDeg) {
        float targetBaseX;
        UUID id = p.method_5667();
        LanternSwingState state = LanternSwingManager.getOrCreate(id);
        Kinematics kin = KIN.computeIfAbsent(id, u -> new Kinematics());
        float yaw = LanternSwingManager.wrapDegrees(p.method_36454());
        float yawRateDegPerSec = LanternSwingManager.wrapDegrees(yaw - kin.prevYaw) / Math.max(dtSec, 1.0E-4f);
        float yawRateRadPerSec = (float)Math.toRadians(yawRateDegPerSec);
        double px = p.method_23317();
        double py = p.method_23318();
        double pz = p.method_23321();
        double vxTick = px - kin.prevX;
        double vyTick = py - kin.prevY;
        double vzTick = pz - kin.prevZ;
        if (!kin.posInit) {
            vzTick = 0.0;
            vyTick = 0.0;
            vxTick = 0.0;
            kin.posInit = true;
        }
        double vx = vxTick;
        double vz = vzTick;
        double vy = vyTick;
        double hSpeedPerSec = Math.hypot(vx, vz) * 20.0;
        double prevHSpeedPerSec = kin.prevHSpeedPerSec;
        double hAccel = (hSpeedPerSec - prevHSpeedPerSec) / Math.max((double)dtSec, 1.0E-4);
        double yAcc = (vy - kin.prevYVel) * 20.0 / Math.max((double)dtSec, 1.0E-4);
        float yawRad = (float)Math.toRadians(yaw);
        double fwdX = -Math.sin(yawRad);
        double fwdZ = Math.cos(yawRad);
        double rightX = Math.cos(yawRad);
        double rightZ = Math.sin(yawRad);
        double vFwd = vx * fwdX + vz * fwdZ;
        double vRight = vx * rightX + vz * rightZ;
        double vFwdPerSec = vFwd * 20.0;
        double vRightPerSec = vRight * 20.0;
        double aFwd = (vFwdPerSec - kin.prevVFwdPerSec) / Math.max((double)dtSec, 1.0E-4);
        double aRight = (vRightPerSec - kin.prevVRightPerSec) / Math.max((double)dtSec, 1.0E-4);
        float uZ = (float)((double)(3.2f * yawRateRadPerSec) + (double)1.4f * aRight + 0.25 * vRightPerSec);
        float uX = (float)((double)0.15f * vFwdPerSec + 1.25 * aFwd + (double)0.22f * yAcc);
        boolean onGround = p.method_24828();
        boolean wasOnGround = kin.prevOnGround;
        boolean sneaking = p.method_5715();
        boolean wasSneaking = kin.prevSneaking;
        boolean moving = hSpeedPerSec > 1.6;
        boolean wasMoving = kin.prevMoving;
        if (wasOnGround && !onGround && vy > 0.08) {
            state.impulseX(-1.3f);
        }
        if (!wasOnGround && onGround && kin.prevYVel < -0.08) {
            state.impulseX(1.8f);
        }
        if (!wasSneaking && sneaking) {
            state.impulseX(0.6f);
        } else if (wasSneaking && !sneaking) {
            state.impulseX(-0.4f);
        }
        if (!wasMoving && moving) {
            state.impulseX(-0.55f);
        } else if (wasMoving && !moving) {
            state.impulseX(0.4f);
        }
        float f = targetBaseX = sneaking ? 215.0f : baseRotXDeg;
        if (!kin.baseInit) {
            kin.baseXDegSmoothed = targetBaseX;
            kin.baseInit = true;
        }
        kin.baseXDegSmoothed = LanternSwingManager.approachExp(kin.baseXDegSmoothed, targetBaseX, dtSec, 0.15f);
        state.step(dtSec, uX, uZ);
        kin.prevYaw = yaw;
        kin.prevHSpeedPerSec = hSpeedPerSec;
        kin.prevYVel = vy;
        kin.prevOnGround = onGround;
        kin.prevSneaking = sneaking;
        kin.prevVFwdPerSec = vFwdPerSec;
        kin.prevVRightPerSec = vRightPerSec;
        kin.prevMoving = moving;
        kin.prevX = px;
        kin.prevY = py;
        kin.prevZ = pz;
        KIN.put(id, kin);
        STATES.put(id, state);
    }

    public static float getXDeg(UUID id) {
        return STATES.getOrDefault(id, new LanternSwingState(7.0f, 0.42f)).getXDeg();
    }

    public static float getZDeg(UUID id) {
        return STATES.getOrDefault(id, new LanternSwingState(7.0f, 0.42f)).getZDeg();
    }

    public static float getBaseXDeg(UUID id) {
        Kinematics k = KIN.get(id);
        if (k == null) {
            return 0.0f;
        }
        return k.baseXDegSmoothed;
    }

    public static void removePlayer(UUID id) {
        STATES.remove(id);
        KIN.remove(id);
    }

    public static void clearAll() {
        STATES.clear();
        KIN.clear();
    }

    private static float wrapDegrees(float deg) {
        return class_3532.method_15393((float)deg);
    }

    private static float approachExp(float current, float target, float dtSec, float tauSec) {
        if (tauSec <= 0.0f) {
            return target;
        }
        float a = 1.0f - (float)Math.exp(-dtSec / tauSec);
        if (a < 0.0f) {
            a = 0.0f;
        } else if (a > 1.0f) {
            a = 1.0f;
        }
        return current + (target - current) * a;
    }

    private static final class Kinematics {
        float prevYaw = 0.0f;
        double prevHSpeedPerSec = 0.0;
        double prevYVel = 0.0;
        boolean prevOnGround = false;
        boolean prevSneaking = false;
        double prevVFwdPerSec = 0.0;
        double prevVRightPerSec = 0.0;
        boolean prevMoving = false;
        float baseXDegSmoothed = 0.0f;
        boolean baseInit = false;
        double prevX;
        double prevY;
        double prevZ;
        boolean posInit = false;

        private Kinematics() {
        }
    }
}

