/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common;

import dev.lambdaurora.lambdynlights.api.DynamicLightsContext;
import dev.lambdaurora.lambdynlights.api.DynamicLightsInitializer;
import dev.lambdaurora.lambdynlights.api.entity.EntityLightSourceManager;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.LambDynLightsCompat;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.client.BLClientAbstractions;
import org.jetbrains.annotations.NotNull;

public final class LambDynLightsInitializer
implements DynamicLightsInitializer {
    static final EntityLuminance.Type PLAYER_LANTERN = EntityLuminance.Type.registerSimple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"beltborne_lanterns", (String)"player_lantern"), (EntityLuminance)PlayerLanternLuminance.INSTANCE);

    public void onInitializeDynamicLights(DynamicLightsContext context) {
        EntityLightSourceManager mgr = context.entityLightSourceManager();
        mgr.onRegisterEvent().register(ctx -> ctx.register(EntityType.PLAYER, new EntityLuminance[]{PlayerLanternLuminance.INSTANCE}));
        BLMod.LOGGER.info("Dynamic lights: integrated via LambDynamicLights 4.x (API entrypoint)");
        LambDynLightsCompat.markInitialized();
    }

    private static final class PlayerLanternLuminance
    implements EntityLuminance {
        static final PlayerLanternLuminance INSTANCE = new PlayerLanternLuminance();

        private PlayerLanternLuminance() {
        }

        public EntityLuminance.Type type() {
            return PLAYER_LANTERN;
        }

        public int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, Entity entity) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Item lamp = BLClientAbstractions.clientLamp(player);
                return lamp != null ? LampRegistry.getLuminance(lamp) : 0;
            }
            return 0;
        }
    }
}

