/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.config.BLLampConfig;
import net.oxcodsnet.beltborne_lanterns.common.config.BLLampConfigAccess;

public final class LampRegistry {
    private static final Map<Item, LampData> LAMPS = new LinkedHashMap<Item, LampData>();
    public static final TagKey<Item> EXTRA_LAMPS_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"beltborne_lanterns", (String)"lamps"));

    private LampRegistry() {
    }

    public static void init() {
        LAMPS.clear();
        LampRegistry.register(Items.LANTERN, (BlockState)Blocks.LANTERN.defaultBlockState().setValue((Property)BlockStateProperties.HANGING, (Comparable)Boolean.valueOf(false)));
        LampRegistry.register(Items.SOUL_LANTERN, (BlockState)Blocks.SOUL_LANTERN.defaultBlockState().setValue((Property)BlockStateProperties.HANGING, (Comparable)Boolean.valueOf(false)));
        LampRegistry.registerCopperLanterns();
        try {
            int discovered = 0;
            for (Holder entry2 : BuiltInRegistries.ITEM.getTagOrEmpty(EXTRA_LAMPS_TAG)) {
                ++discovered;
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)((Item)entry2.value()));
                BLMod.LOGGER.debug(" - {}", (Object)id);
                Item item = (Item)entry2.value();
                if (LAMPS.containsKey(item) || !(item instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                BlockState state = blockItem.getBlock().defaultBlockState();
                if (state.hasProperty((Property)BlockStateProperties.HANGING)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.HANGING, (Comparable)Boolean.valueOf(false));
                }
                LampRegistry.register(item, state);
            }
            if (discovered > 0) {
                BLMod.LOGGER.debug("Found {} entries in #{}:lamps", (Object)discovered, (Object)"beltborne_lanterns");
            }
        }
        catch (IllegalStateException notBound) {
            BLMod.LOGGER.debug("Tags not bound yet; skipping tag-based lamps for now");
        }
        BLLampConfig cfg = BLLampConfigAccess.get();
        cfg.extraLampLight.forEach(entry -> {
            ResourceLocation id = ResourceLocation.tryParse((String)entry.id);
            if (id == null) {
                return;
            }
            Item item = (Item)BuiltInRegistries.ITEM.getValue(id);
            if (item == Items.AIR) {
                return;
            }
            if (!(item instanceof BlockItem)) {
                return;
            }
            BlockItem blockItem = (BlockItem)item;
            BlockState state = blockItem.getBlock().defaultBlockState();
            if (state.hasProperty((Property)BlockStateProperties.HANGING)) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.HANGING, (Comparable)Boolean.valueOf(false));
            }
            LampRegistry.register(item, state, entry.luminance);
        });
        int total = LAMPS.size();
        int builtin = 0;
        if (LAMPS.containsKey(Items.LANTERN)) {
            ++builtin;
        }
        if (LAMPS.containsKey(Items.SOUL_LANTERN)) {
            ++builtin;
        }
        int extras = Math.max(0, total - builtin);
        BLMod.LOGGER.info("Lamp registry ready: {} items ({} builtin, {} extra)", new Object[]{total, builtin, extras});
    }

    private static void registerCopperLanterns() {
        LampRegistry.registerCopperVariant("copper_lantern");
        LampRegistry.registerCopperVariant("exposed_copper_lantern");
        LampRegistry.registerCopperVariant("weathered_copper_lantern");
        LampRegistry.registerCopperVariant("oxidized_copper_lantern");
        LampRegistry.registerCopperVariant("waxed_copper_lantern");
        LampRegistry.registerCopperVariant("waxed_exposed_copper_lantern");
        LampRegistry.registerCopperVariant("waxed_weathered_copper_lantern");
        LampRegistry.registerCopperVariant("waxed_oxidized_copper_lantern");
    }

    private static void registerCopperVariant(String path) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)path);
        Item item = (Item)BuiltInRegistries.ITEM.getValue(id);
        if (!(item instanceof BlockItem)) {
            BLMod.LOGGER.warn("Expected copper lantern item {}, but it was not found or not a block item", (Object)id);
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState state = blockItem.getBlock().defaultBlockState();
        if (state.hasProperty((Property)BlockStateProperties.HANGING)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.HANGING, (Comparable)Boolean.valueOf(false));
        }
        LampRegistry.register(item, state);
    }

    private static int clampLuminance(int lum) {
        return Math.max(0, Math.min(15, lum));
    }

    public static void register(Item item, BlockState state) {
        LAMPS.put(item, new LampData(state, state.getLightEmission()));
    }

    public static void register(Item item, BlockState state, int luminance) {
        LAMPS.put(item, new LampData(state, LampRegistry.clampLuminance(luminance)));
    }

    public static boolean isLamp(ItemStack stack) {
        return stack != null && LAMPS.containsKey(stack.getItem());
    }

    public static boolean isLamp(Item item) {
        return item != null && LAMPS.containsKey(item);
    }

    public static BlockState getState(Item item) {
        LampData data = LAMPS.get(item);
        return data != null ? data.state() : (BlockState)Blocks.LANTERN.defaultBlockState().setValue((Property)BlockStateProperties.HANGING, (Comparable)Boolean.valueOf(false));
    }

    public static int getLuminance(Item item) {
        LampData data = LAMPS.get(item);
        return data != null ? data.luminance() : 0;
    }

    public static ResourceLocation getId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static Item getById(ResourceLocation id) {
        return (Item)BuiltInRegistries.ITEM.getValue(id);
    }

    public static Set<Item> items() {
        return Collections.unmodifiableSet(LAMPS.keySet());
    }

    private record LampData(BlockState state, int luminance) {
    }
}

