/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.client.BLClientAbstractions;
import net.oxcodsnet.beltborne_lanterns.common.client.BLDebugRender;
import net.oxcodsnet.beltborne_lanterns.common.client.ClientBeltPlayers;
import net.oxcodsnet.beltborne_lanterns.common.client.ReflectUtilBL;
import net.oxcodsnet.beltborne_lanterns.common.config.BLConfig;
import net.oxcodsnet.beltborne_lanterns.common.config.BLConfigs;
import net.oxcodsnet.beltborne_lanterns.common.physics.LanternSwingManager;
import org.joml.Quaternionfc;

public class LanternBeltFeatureRenderer
extends RenderLayer<AvatarRenderState, PlayerModel> {
    private static final float MODEL_Y_ROTATION_DEGREES = 180.0f;
    private static boolean UUID_LOOKUP_WARNED = false;

    public LanternBeltFeatureRenderer(RenderLayerParent<?, ?> context) {
        super(context);
    }

    public void submit(PoseStack matrices, SubmitNodeCollector collector, int light, AvatarRenderState state, float limbAngle, float limbDistance) {
        UUID subject;
        Minecraft mc;
        block16: {
            Entity entity;
            mc = Minecraft.getInstance();
            subject = null;
            if (mc.level != null && (entity = mc.level.getEntity(state.id)) instanceof Player) {
                Player player = (Player)entity;
                subject = player.getUUID();
            }
            try {
                String[] profileFieldCandidates;
                String[] uuidFieldCandidates;
                Class<?> cls = state.getClass();
                for (String name : uuidFieldCandidates = new String[]{"uuid", "profileId", "gameProfileId", "playerUuid"}) {
                    try {
                        UUID u;
                        Field f = ReflectUtilBL.findFieldRecursive(cls, name);
                        f.setAccessible(true);
                        Object v = f.get(state);
                        if (!(v instanceof UUID)) continue;
                        subject = u = (UUID)v;
                        break;
                    }
                    catch (NoSuchFieldException f) {
                        // empty catch block
                    }
                }
                if (subject != null) break block16;
                for (String name : profileFieldCandidates = new String[]{"gameProfile", "profile"}) {
                    try {
                        Field f = ReflectUtilBL.findFieldRecursive(cls, name);
                        f.setAccessible(true);
                        Object v = f.get(state);
                        if (v == null) continue;
                        try {
                            UUID u;
                            Method m = v.getClass().getMethod("getId", new Class[0]);
                            Object id = m.invoke(v, new Object[0]);
                            if (!(id instanceof UUID)) continue;
                            subject = u = (UUID)id;
                            break;
                        }
                        catch (ReflectiveOperationException m) {
                        }
                    }
                    catch (NoSuchFieldException f) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable cls) {
                // empty catch block
            }
        }
        if (subject == null && mc.player != null) {
            subject = mc.player.getUUID();
            if (!UUID_LOOKUP_WARNED) {
                BLMod.LOGGER.warn("Beltborne Lanterns: falling back to local player UUID in feature renderer; mixin may be needed for this mapping.");
                UUID_LOOKUP_WARNED = true;
            }
        }
        if (subject == null) {
            return;
        }
        Item lampItem = ClientBeltPlayers.getLamp(subject);
        if (lampItem == null) {
            return;
        }
        BLConfig c = BLConfigs.get();
        matrices.pushPose();
        LanternBeltFeatureRenderer.applyModelPart(matrices, ((PlayerModel)this.getParentModel()).body);
        float offX = c.fOffsetX();
        float offY = c.fOffsetY();
        float offZ = c.fOffsetZ();
        float pivX = c.fPivotX();
        float pivY = c.fPivotY();
        float pivZ = c.fPivotZ();
        float s = c.fScale();
        matrices.translate(offX, offY, offZ);
        if (BLClientAbstractions.isDebugDrawEnabled()) {
            matrices.pushPose();
            matrices.translate(pivX, pivY, pivZ);
            BLDebugRender.drawAxesAndAnchor(matrices, null, 0.25f);
            matrices.popPose();
        }
        matrices.translate(pivX, pivY, pivZ);
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        matrices.scale(s, s, s);
        float dynX = LanternSwingManager.getXDeg(subject);
        float dynZ = LanternSwingManager.getZDeg(subject);
        float baseX = LanternSwingManager.getBaseXDeg(subject);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(baseX + dynX));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)c.rotYDeg));
        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)c.rotZDeg + dynZ));
        matrices.translate(-pivX, -pivY, -pivZ);
        BlockState blockState = LampRegistry.getState(lampItem);
        collector.submitBlock(matrices, blockState, light, OverlayTexture.NO_OVERLAY, state.outlineColor);
        matrices.popPose();
    }

    private static void applyModelPart(PoseStack matrices, ModelPart part) {
        part.translateAndRotate(matrices);
    }
}

