/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.network;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record LampConfigSyncPayload(Map<ResourceLocation, Integer> lamps) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LampConfigSyncPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"beltborne_lanterns", (String)"lamp_config_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LampConfigSyncPayload> CODEC = new StreamCodec<RegistryFriendlyByteBuf, LampConfigSyncPayload>(){

        public LampConfigSyncPayload decode(RegistryFriendlyByteBuf buf) {
            int size = buf.readVarInt();
            LinkedHashMap<ResourceLocation, Integer> map = new LinkedHashMap<ResourceLocation, Integer>();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buf.readResourceLocation();
                int lum = buf.readVarInt();
                map.put(id, lum);
            }
            return new LampConfigSyncPayload(map);
        }

        public void encode(RegistryFriendlyByteBuf buf, LampConfigSyncPayload value) {
            buf.writeVarInt(value.lamps().size());
            for (Map.Entry<ResourceLocation, Integer> entry : value.lamps().entrySet()) {
                buf.writeResourceLocation(entry.getKey());
                buf.writeVarInt(entry.getValue().intValue());
            }
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

