/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.server;

import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.oxcodsnet.beltborne_lanterns.common.BeltState;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.persistence.BeltLanternSave;

public final class BeltLanternServer {
    private BeltLanternServer() {
    }

    private static MinecraftServer server(ServerPlayer player) {
        return Objects.requireNonNull(player.level().getServer(), "Missing server instance");
    }

    public static Item toggleLantern(ServerPlayer player, ItemStack stackInHand) {
        Item current = BeltState.getLamp((Player)player);
        boolean creative = player.isCreative();
        if (current == null) {
            Item item = stackInHand.getItem();
            if (!LampRegistry.isLamp(item)) {
                return null;
            }
            ItemStack equipped = stackInHand.copyWithCount(1);
            if (!creative) {
                stackInHand.shrink(1);
                player.getInventory().setChanged();
            }
            BeltState.setLamp((Player)player, equipped);
            BeltLanternSave.get(BeltLanternServer.server(player)).set(player.getUUID(), equipped);
            return item;
        }
        if (!creative) {
            ItemStack stored = BeltState.getLampStack((Player)player);
            ItemStack toReturn = stored != null && !stored.isEmpty() ? stored : new ItemStack((ItemLike)current);
            Inventory inventory = player.getInventory();
            int selectedSlot = inventory.getSelectedSlot();
            boolean placedInSelected = false;
            if (selectedSlot >= 0 && selectedSlot < Inventory.getSelectionSize()) {
                ItemStack currentlySelected = inventory.getItem(selectedSlot);
                if (currentlySelected.isEmpty()) {
                    inventory.setItem(selectedSlot, toReturn);
                    placedInSelected = true;
                } else {
                    ItemStack displaced = currentlySelected.copy();
                    inventory.setItem(selectedSlot, toReturn);
                    boolean inserted = inventory.add(displaced);
                    if (!inserted && !displaced.isEmpty()) {
                        player.drop(displaced, true);
                    }
                    placedInSelected = true;
                }
            }
            if (!placedInSelected && !inventory.add(toReturn)) {
                player.drop(toReturn, false);
            }
            inventory.setChanged();
        }
        BeltState.setLamp((Player)player, (ItemStack)null);
        BeltLanternSave.get(BeltLanternServer.server(player)).set(player.getUUID(), (ItemStack)null);
        return null;
    }

    public static Item handleDeath(ServerPlayer player, boolean keepInventory) {
        Item lamp = BeltState.getLamp((Player)player);
        if (lamp == null) {
            return null;
        }
        if (keepInventory) {
            return lamp;
        }
        ItemStack stored = BeltState.getLampStack((Player)player);
        if (stored != null && !stored.isEmpty()) {
            player.drop(stored, false);
        } else {
            ItemStack stack = new ItemStack((ItemLike)lamp);
            player.drop(stack, false);
        }
        BeltState.setLamp((Player)player, (ItemStack)null);
        BeltLanternSave.get(BeltLanternServer.server(player)).set(player.getUUID(), (ItemStack)null);
        return null;
    }

    public static void handleDeath(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean keepInventory) {
        Item lamp = BeltState.getLamp((Player)oldPlayer);
        if (lamp == null) {
            BeltState.setLamp((Player)newPlayer, (ItemStack)null);
            return;
        }
        if (keepInventory) {
            ItemStack stored = BeltState.getLampStack((Player)oldPlayer);
            BeltState.setLamp((Player)newPlayer, stored);
            BeltLanternSave.get(BeltLanternServer.server(newPlayer)).set(newPlayer.getUUID(), stored);
            return;
        }
        ItemStack stored = BeltState.getLampStack((Player)oldPlayer);
        if (stored != null && !stored.isEmpty()) {
            oldPlayer.drop(stored, false);
        } else {
            oldPlayer.drop(new ItemStack((ItemLike)lamp), false);
        }
        BeltState.setLamp((Player)oldPlayer, (ItemStack)null);
        BeltLanternSave.get(BeltLanternServer.server(oldPlayer)).set(oldPlayer.getUUID(), (ItemStack)null);
        BeltState.setLamp((Player)newPlayer, (ItemStack)null);
    }
}

