/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.neoforge;

import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.BeltState;
import net.oxcodsnet.beltborne_lanterns.common.DynamicLightsCompat;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.compat.CompatibilityLayer;
import net.oxcodsnet.beltborne_lanterns.common.compat.CompatibilityLayerRegistry;
import net.oxcodsnet.beltborne_lanterns.common.config.BLLampConfigAccess;
import net.oxcodsnet.beltborne_lanterns.common.datapack.BLRuntimeDataPack;
import net.oxcodsnet.beltborne_lanterns.common.network.LampConfigSyncPayload;
import net.oxcodsnet.beltborne_lanterns.common.persistence.BeltLanternSave;
import net.oxcodsnet.beltborne_lanterns.common.server.BeltLanternServer;
import net.oxcodsnet.beltborne_lanterns.neoforge.BeltNetworking;

@EventBusSubscriber(modid="beltborne_lanterns")
public final class BLNeoForgeServerEvents {
    private BLNeoForgeServerEvents() {
    }

    private static MinecraftServer server(ServerPlayer player) {
        return Objects.requireNonNull(player.level().getServer(), "Missing server instance");
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent e) {
        LampRegistry.init();
        MinecraftServer server = e.getServer();
        boolean dpChanged = BLRuntimeDataPack.writeOrUpdate(server);
        if (dpChanged) {
            try {
                server.getCommands().performPrefixedCommand(server.createCommandSourceStack(), "reload");
            }
            catch (Throwable t) {
                BLMod.LOGGER.info("Runtime datapack updated \u2014 please run /reload to apply");
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer joining = (ServerPlayer)player;
        MinecraftServer server = BLNeoForgeServerEvents.server(joining);
        ItemStack persistedStack = BeltLanternSave.get(server).getStack(joining.getUUID());
        for (CompatibilityLayer layer : CompatibilityLayerRegistry.getLayers()) {
            Optional<ItemStack> slotStack = layer.getBeltStack(joining);
            if (!slotStack.isPresent() || !LampRegistry.isLamp(slotStack.get())) continue;
            persistedStack = slotStack.get();
            break;
        }
        Item persisted = persistedStack != null ? persistedStack.getItem() : null;
        BeltState.setLamp((Player)joining, persistedStack);
        BeltNetworking.broadcastBeltState(joining, persisted);
        if (persisted != null) {
            DynamicLightsCompat.addFor(joining);
        }
        if (server.isDedicatedServer()) {
            LinkedHashMap<ResourceLocation, Integer> lampMap = new LinkedHashMap<ResourceLocation, Integer>();
            BLLampConfigAccess.get().extraLampLight.forEach(entry -> {
                ResourceLocation id = ResourceLocation.tryParse((String)entry.id);
                if (id != null) {
                    lampMap.put(id, entry.luminance);
                }
            });
            PacketDistributor.sendToPlayer((ServerPlayer)joining, (CustomPacketPayload)new LampConfigSyncPayload(lampMap), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        for (ServerPlayer other : server.getPlayerList().getPlayers()) {
            Item lamp = BeltState.getLamp((Player)other);
            BeltNetworking.sendTo(joining, other.getUUID(), lamp);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer leaving = (ServerPlayer)player;
        BeltLanternSave.get(BLNeoForgeServerEvents.server(leaving)).set(leaving.getUUID(), BeltState.getLampStack((Player)leaving));
        DynamicLightsCompat.removeFor(leaving);
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getOriginal();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer oldPlayer = (ServerPlayer)player;
        if (!event.isWasDeath()) {
            return;
        }
        ServerPlayer newPlayer = (ServerPlayer)event.getEntity();
        boolean keep = oldPlayer.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
        BeltLanternServer.handleDeath(oldPlayer, newPlayer, keep);
        DynamicLightsCompat.removeFor(oldPlayer);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Item lamp = BeltState.getLamp((Player)player2);
        BeltNetworking.broadcastBeltState(player2, lamp);
        if (lamp != null) {
            DynamicLightsCompat.addFor(player2);
        }
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            BLRuntimeDataPack.writeOrUpdate(server);
        }
        LampRegistry.init();
    }
}

