/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.neoforge.client;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.LambDynLightsCompat;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.client.BLClientAbstractions;
import net.oxcodsnet.beltborne_lanterns.common.client.ClientBeltPlayers;
import net.oxcodsnet.beltborne_lanterns.common.client.LanternClientLogic;
import net.oxcodsnet.beltborne_lanterns.common.client.LanternClientScreens;
import net.oxcodsnet.beltborne_lanterns.common.client.ui.LanternDebugScreen;
import net.oxcodsnet.beltborne_lanterns.common.config.BLClientConfigAccess;
import net.oxcodsnet.beltborne_lanterns.common.network.ToggleLanternPayload;
import net.oxcodsnet.beltborne_lanterns.common.physics.LanternSwingManager;
import net.oxcodsnet.beltborne_lanterns.neoforge.compat.LDL4NeoForge;

@EventBusSubscriber(modid="beltborne_lanterns", value={Dist.CLIENT})
public final class BLNeoForgeClient {
    private static final KeyMapping.Category BELTBORNE_CATEGORY = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"beltborne_lanterns", (String)"beltborne_lanterns"));
    private static KeyMapping openConfigKey;
    private static KeyMapping toggleDebugKey;
    private static KeyMapping openDebugEditorKey;
    private static KeyMapping toggleLanternKey;

    private BLNeoForgeClient() {
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        LampRegistry.init();
        BLMod.LOGGER.info("Client initialization started [NeoForge]");
        BLClientAbstractions.init(ClientBeltPlayers::getLamp);
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (mc, parent) -> LanternClientScreens.openConfig(parent));
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        openConfigKey = new KeyMapping("key.beltborne_lanterns.open_config", InputConstants.Type.KEYSYM, 76, BELTBORNE_CATEGORY);
        toggleDebugKey = new KeyMapping("key.beltborne_lanterns.toggle_debug", InputConstants.Type.KEYSYM, 75, BELTBORNE_CATEGORY);
        openDebugEditorKey = new KeyMapping("key.beltborne_lanterns.open_debug", InputConstants.Type.KEYSYM, 80, BELTBORNE_CATEGORY);
        toggleLanternKey = new KeyMapping("key.beltborne_lanterns.toggle_lantern", InputConstants.Type.KEYSYM, 66, BELTBORNE_CATEGORY);
        event.register(openConfigKey);
        event.register(toggleDebugKey);
        event.register(openDebugEditorKey);
        event.register(toggleLanternKey);
        try {
            if (!LDL4NeoForge.tryInit()) {
                LambDynLightsCompat.init();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BLMod.LOGGER.info("Client ready [NeoForge].");
    }

    @EventBusSubscriber(modid="beltborne_lanterns", value={Dist.CLIENT})
    public static final class ClientBus {
        private ClientBus() {
        }

        @SubscribeEvent
        public static void onEntityLeave(EntityLeaveLevelEvent event) {
            if (event.getEntity() instanceof Player) {
                LanternSwingManager.removePlayer(event.getEntity().getUUID());
            }
        }

        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post e) {
            Minecraft mc = Minecraft.getInstance();
            if (openConfigKey != null && openConfigKey.consumeClick() && mc.screen == null) {
                mc.setScreen(LanternClientScreens.openConfig(mc.screen));
            }
            if (toggleDebugKey != null && toggleDebugKey.consumeClick() && BLClientConfigAccess.get().debug) {
                BLClientAbstractions.setDebugDrawEnabled(!BLClientAbstractions.isDebugDrawEnabled());
            }
            if (openDebugEditorKey != null && openDebugEditorKey.consumeClick() && BLClientConfigAccess.get().debug && mc.screen == null) {
                mc.setScreen((Screen)new LanternDebugScreen());
            }
            if (toggleLanternKey != null && toggleLanternKey.consumeClick() && mc.getConnection() != null) {
                mc.getConnection().send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new ToggleLanternPayload()));
            }
            LanternClientLogic.tickLanternPhysics(mc);
            if (!LambDynLightsCompat.isInitialized() && !LDL4NeoForge.tryInit()) {
                LambDynLightsCompat.init();
            }
        }
    }
}

