/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.client.ui;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.oxcodsnet.beltborne_lanterns.common.client.BLClientAbstractions;
import net.oxcodsnet.beltborne_lanterns.common.config.BLClientConfig;
import net.oxcodsnet.beltborne_lanterns.common.config.BLClientConfigAccess;

public class LanternDebugScreen
extends Screen {
    private static final float[] STEP_PRESETS = new float[]{0.005f, 0.01f, 0.025f, 0.05f, 0.1f};
    private int stepIndex = 1;
    private boolean prevDebugEnabled;
    private EditBox copyPreviewField;
    private Button stepButton;

    public LanternDebugScreen() {
        super((Component)Component.literal((String)"Lantern Debug"));
    }

    protected void init() {
        this.prevDebugEnabled = BLClientAbstractions.isDebugDrawEnabled();
        BLClientAbstractions.setDebugDrawEnabled(true);
        int left = 20;
        int top = 80;
        int row = 0;
        int colGap = 78;
        int rightColWidth = 240;
        int rightX = this.width - 20 - rightColWidth;
        int rightRow = 0;
        Runnable save = BLClientConfigAccess::save;
        BLClientConfig cfg = BLClientConfigAccess.get();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Offset X-"), b -> {
            cfg.offsetX100 -= this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left, top + row * 22, 74, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"X+"), b -> {
            cfg.offsetX100 += this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left + colGap, top + row * 22, 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Offset Y-"), b -> {
            cfg.offsetY100 -= this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left, top + ++row * 22, 74, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Y+"), b -> {
            cfg.offsetY100 += this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left + colGap, top + row * 22, 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Offset Z-"), b -> {
            cfg.offsetZ100 -= this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left, top + ++row * 22, 74, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Z+"), b -> {
            cfg.offsetZ100 += this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left + colGap, top + row * 22, 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Pivot X-"), b -> {
            cfg.pivotX100 -= this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left, top + ++row * 22, 74, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"X+"), b -> {
            cfg.pivotX100 += this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left + colGap, top + row * 22, 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Pivot Y-"), b -> {
            cfg.pivotY100 -= this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left, top + ++row * 22, 74, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Y+"), b -> {
            cfg.pivotY100 += this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left + colGap, top + row * 22, 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Pivot Z-"), b -> {
            cfg.pivotZ100 -= this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left, top + ++row * 22, 74, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Z+"), b -> {
            cfg.pivotZ100 += this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left + colGap, top + row * 22, 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Rot X-"), b -> {
            cfg.rotXDeg -= this.scaledRotStepDeg();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left, top + ++row * 22, 74, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"X+"), b -> {
            cfg.rotXDeg += this.scaledRotStepDeg();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left + colGap, top + row * 22, 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Rot Y-"), b -> {
            cfg.rotYDeg -= this.scaledRotStepDeg();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left, top + ++row * 22, 74, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Y+"), b -> {
            cfg.rotYDeg += this.scaledRotStepDeg();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left + colGap, top + row * 22, 50, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Rot Z-"), b -> {
            cfg.rotZDeg -= this.scaledRotStepDeg();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left, top + ++row * 22, 74, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Z+"), b -> {
            cfg.rotZDeg += this.scaledRotStepDeg();
            save.run();
            this.refreshCopyPreview();
        }).bounds(left + colGap, top + row * 22, 50, 20).build());
        ++row;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Scale -"), b -> {
            cfg.scale100 = Math.max(1, cfg.scale100 - this.scaledStep100());
            save.run();
            this.refreshCopyPreview();
        }).bounds(rightX, top + rightRow * 22, 70, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Scale +"), b -> {
            cfg.scale100 += this.scaledStep100();
            save.run();
            this.refreshCopyPreview();
        }).bounds(rightX + 74, top + rightRow * 22, 70, 20).build());
        this.stepButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Step: " + this.stepText())), b -> {
            this.cycleStep();
            this.stepButton.setMessage((Component)Component.literal((String)("Step: " + this.stepText())));
        }).bounds(rightX + 148, top + rightRow * 22, 90, 20).build());
        int previewWidth = 180;
        this.copyPreviewField = new EditBox(this.font, rightX, top + ++rightRow * 22, previewWidth, 20, (Component)Component.literal((String)"CopyPreview"));
        this.copyPreviewField.setEditable(false);
        this.addRenderableWidget((GuiEventListener)this.copyPreviewField);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Copy"), b -> this.copyValuesToClipboard()).bounds(rightX + previewWidth + 4, top + rightRow * 22, rightColWidth - previewWidth - 4, 20).build());
        this.refreshCopyPreview();
    }

    private int scaledStep100() {
        float base = STEP_PRESETS[this.stepIndex] * 1000.0f;
        float mul = 1.0f;
        if (LanternDebugScreen.hasShiftDown()) {
            mul *= 10.0f;
        }
        if (LanternDebugScreen.hasControlDown()) {
            mul *= 0.1f;
        }
        return Math.max(1, Math.round(base * mul));
    }

    private int scaledRotStepDeg() {
        float base = 5.0f;
        float mul = 1.0f;
        if (LanternDebugScreen.hasShiftDown()) {
            mul *= 3.0f;
        }
        if (LanternDebugScreen.hasControlDown()) {
            mul *= 0.2f;
        }
        return Math.max(1, Math.round(base * mul));
    }

    private void cycleStep() {
        this.stepIndex = (this.stepIndex + 1) % STEP_PRESETS.length;
    }

    private String stepText() {
        return String.format("%.3f", Float.valueOf(STEP_PRESETS[this.stepIndex]));
    }

    private void refreshCopyPreview() {
        BLClientConfig c = BLClientConfigAccess.get();
        String s = String.format("off(%.3f,%.3f,%.3f) piv(%.3f,%.3f,%.3f) rot(%d,%d,%d) sc(%.3f)", Float.valueOf(c.fOffsetX()), Float.valueOf(c.fOffsetY()), Float.valueOf(c.fOffsetZ()), Float.valueOf(c.fPivotX()), Float.valueOf(c.fPivotY()), Float.valueOf(c.fPivotZ()), c.rotXDeg, c.rotYDeg, c.rotZDeg, Float.valueOf(c.fScale()));
        if (this.copyPreviewField != null) {
            this.copyPreviewField.setValue(s);
        }
    }

    private void copyValuesToClipboard() {
        BLClientConfig c = BLClientConfigAccess.get();
        String jsonish = String.format("{offset:[%.3f,%.3f,%.3f], pivot:[%.3f,%.3f,%.3f], rot:[%d,%d,%d], scale:%.3f}", Float.valueOf(c.fOffsetX()), Float.valueOf(c.fOffsetY()), Float.valueOf(c.fOffsetZ()), Float.valueOf(c.fPivotX()), Float.valueOf(c.fPivotY()), Float.valueOf(c.fPivotZ()), c.rotXDeg, c.rotYDeg, c.rotZDeg, Float.valueOf(c.fScale()));
        Minecraft.getInstance().keyboardHandler.setClipboard(jsonish);
    }

    public void onClose() {
        BLClientAbstractions.setDebugDrawEnabled(this.prevDebugEnabled);
        super.onClose();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        BLClientConfig cfg = BLClientConfigAccess.get();
        boolean used = false;
        switch (keyCode) {
            case 262: {
                cfg.offsetX100 += this.scaledStep100();
                used = true;
                break;
            }
            case 263: {
                cfg.offsetX100 -= this.scaledStep100();
                used = true;
                break;
            }
            case 265: {
                cfg.offsetZ100 -= this.scaledStep100();
                used = true;
                break;
            }
            case 264: {
                cfg.offsetZ100 += this.scaledStep100();
                used = true;
                break;
            }
            case 266: {
                cfg.offsetY100 += this.scaledStep100();
                used = true;
                break;
            }
            case 267: {
                cfg.offsetY100 -= this.scaledStep100();
                used = true;
                break;
            }
            case 82: {
                cfg.rotXDeg += this.scaledRotStepDeg();
                used = true;
                break;
            }
            case 70: {
                cfg.rotXDeg -= this.scaledRotStepDeg();
                used = true;
                break;
            }
            case 84: {
                cfg.rotYDeg += this.scaledRotStepDeg();
                used = true;
                break;
            }
            case 71: {
                cfg.rotYDeg -= this.scaledRotStepDeg();
                used = true;
                break;
            }
            case 89: {
                cfg.rotZDeg += this.scaledRotStepDeg();
                used = true;
                break;
            }
            case 72: {
                cfg.rotZDeg -= this.scaledRotStepDeg();
                used = true;
                break;
            }
            case 73: {
                cfg.pivotX100 += this.scaledStep100();
                used = true;
                break;
            }
            case 75: {
                cfg.pivotX100 -= this.scaledStep100();
                used = true;
                break;
            }
            case 79: {
                cfg.pivotY100 += this.scaledStep100();
                used = true;
                break;
            }
            case 76: {
                cfg.pivotY100 -= this.scaledStep100();
                used = true;
                break;
            }
            case 80: {
                cfg.pivotZ100 += this.scaledStep100();
                used = true;
                break;
            }
            case 59: {
                cfg.pivotZ100 -= this.scaledStep100();
                used = true;
                break;
            }
            case 85: {
                cfg.scale100 += this.scaledStep100();
                used = true;
                break;
            }
            case 74: {
                cfg.scale100 = Math.max(1, cfg.scale100 - this.scaledStep100());
                used = true;
                break;
            }
        }
        if (used) {
            BLClientConfigAccess.save();
            this.refreshCopyPreview();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        super.render(ctx, mouseX, mouseY, delta);
        BLClientConfig c = BLClientConfigAccess.get();
        int x = 20;
        int y = 10;
        ctx.drawString(this.font, (Component)Component.literal((String)"Lantern Debug (hold Shift=\u00d710, Ctrl=\u00d70.1)").withStyle(ChatFormatting.YELLOW), x, y, 0xFFFFFF, false);
        ctx.drawString(this.font, (Component)Component.literal((String)String.format("Offset: X=%.3f Y=%.3f Z=%.3f", Float.valueOf(c.fOffsetX()), Float.valueOf(c.fOffsetY()), Float.valueOf(c.fOffsetZ()))), x, y += 14, 0xFFFFFF, false);
        ctx.drawString(this.font, (Component)Component.literal((String)String.format("Pivot:  X=%.3f Y=%.3f Z=%.3f", Float.valueOf(c.fPivotX()), Float.valueOf(c.fPivotY()), Float.valueOf(c.fPivotZ()))), x, y += 12, 0xFFFFFF, false);
        ctx.drawString(this.font, (Component)Component.literal((String)String.format("Rot:    X=%d Y=%d Z=%d", c.rotXDeg, c.rotYDeg, c.rotZDeg)), x, y += 12, 0xFFFFFF, false);
        ctx.drawString(this.font, (Component)Component.literal((String)String.format("Scale:  %.3f", Float.valueOf(c.fScale()))), x, y += 12, 0xFFFFFF, false);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

