/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.network;

import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record BeltSyncPayload(UUID playerUuid, ResourceLocation lampId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BeltSyncPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"beltborne_lanterns", (String)"belt_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BeltSyncPayload> CODEC = new StreamCodec<RegistryFriendlyByteBuf, BeltSyncPayload>(){

        public BeltSyncPayload decode(RegistryFriendlyByteBuf buf) {
            UUID uuid = (UUID)UUIDUtil.STREAM_CODEC.decode((Object)buf);
            boolean has = buf.readBoolean();
            ResourceLocation id = has ? buf.readResourceLocation() : null;
            return new BeltSyncPayload(uuid, id);
        }

        public void encode(RegistryFriendlyByteBuf buf, BeltSyncPayload value) {
            UUIDUtil.STREAM_CODEC.encode((Object)buf, (Object)value.playerUuid());
            if (value.lampId() != null) {
                buf.writeBoolean(true);
                buf.writeResourceLocation(value.lampId());
            } else {
                buf.writeBoolean(false);
            }
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

