/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.persistence;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public final class BeltLanternSave
extends SavedData {
    private static final String SAVE_NAME = "beltborne_lanterns_belts";
    private static final String PLAYERS_KEY = "players";
    private final Map<UUID, ItemStack> playersWithLamps = new HashMap<UUID, ItemStack>();
    private static final SavedData.Factory<BeltLanternSave> TYPE = new SavedData.Factory(BeltLanternSave::new, (nbt, lookup) -> BeltLanternSave.fromNbt(nbt, lookup), null);

    public static BeltLanternSave get(MinecraftServer server) {
        DimensionDataStorage psManager = server.overworld().getDataStorage();
        return (BeltLanternSave)psManager.computeIfAbsent(TYPE, SAVE_NAME);
    }

    public boolean has(UUID uuid) {
        return this.playersWithLamps.containsKey(uuid);
    }

    public Item get(UUID uuid) {
        ItemStack stack = this.playersWithLamps.get(uuid);
        return stack != null ? stack.getItem() : null;
    }

    public ItemStack getStack(UUID uuid) {
        ItemStack stack = this.playersWithLamps.get(uuid);
        return stack != null ? stack.copy() : null;
    }

    public void set(UUID uuid, ItemStack lamp) {
        if (lamp != null && !lamp.isEmpty()) {
            this.playersWithLamps.put(uuid, lamp.copyWithCount(1));
        } else {
            this.playersWithLamps.remove(uuid);
        }
        this.setDirty();
    }

    public void set(UUID uuid, Item lamp) {
        if (lamp != null) {
            this.playersWithLamps.put(uuid, new ItemStack((ItemLike)lamp));
        } else {
            this.playersWithLamps.remove(uuid);
        }
        this.setDirty();
    }

    public static BeltLanternSave fromNbt(CompoundTag nbt) {
        BeltLanternSave save = new BeltLanternSave();
        CompoundTag map = nbt.getCompound(PLAYERS_KEY);
        for (String key : map.getAllKeys()) {
            try {
                ResourceLocation id;
                UUID uuid = UUID.fromString(key);
                if (!map.contains(key, 8) || (id = ResourceLocation.tryParse((String)map.getString(key))) == null) continue;
                save.playersWithLamps.put(uuid, new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(id)));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return save;
    }

    public static BeltLanternSave fromNbt(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        BeltLanternSave save = new BeltLanternSave();
        CompoundTag map = nbt.getCompound(PLAYERS_KEY);
        for (String key : map.getAllKeys()) {
            try {
                ResourceLocation id;
                UUID uuid = UUID.fromString(key);
                Tag el = map.get(key);
                if (el != null && !(el instanceof StringTag)) {
                    ItemStack stack = ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)el).orElse(ItemStack.EMPTY);
                    if (stack.isEmpty()) continue;
                    save.playersWithLamps.put(uuid, stack);
                    continue;
                }
                if (!(el instanceof StringTag) || (id = ResourceLocation.tryParse((String)map.getString(key))) == null) continue;
                save.playersWithLamps.put(uuid, new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(id)));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return save;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        CompoundTag map = new CompoundTag();
        for (Map.Entry<UUID, ItemStack> e : this.playersWithLamps.entrySet()) {
            Tag encoded = e.getValue().save(registryLookup);
            map.put(e.getKey().toString(), encoded);
        }
        nbt.put(PLAYERS_KEY, (Tag)map);
        return nbt;
    }
}

