/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.persistence;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_10741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.minecraft.class_7877;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public final class BeltLanternSave
extends class_18 {
    private static final String SAVE_NAME = "beltborne_lanterns_belts";
    private static final String PLAYERS_KEY = "players";
    private final Map<UUID, class_1799> playersWithLamps = new HashMap<UUID, class_1799>();
    private static final class_10741<BeltLanternSave> TYPE = new class_10741("beltborne_lanterns_belts", ctx -> new BeltLanternSave(), BeltLanternSave::codec, (class_4284)null);

    private static Codec<BeltLanternSave> codec(final class_18.class_10740 ctx) {
        return Codec.of((Encoder)new Encoder<BeltLanternSave>(){

            public <T> DataResult<T> encode(BeltLanternSave value, DynamicOps<T> ops, T prefix) {
                class_2487 nbt = new class_2487();
                class_3218 world = ctx.method_67417();
                class_7225.class_7874 registries = new class_7877().method_46780(world.method_30349());
                value.writeNbt(nbt, registries);
                return class_2487.field_25128.encodeStart(ops, (Object)nbt);
            }
        }, (Decoder)new Decoder<BeltLanternSave>(){

            public <T> DataResult<Pair<BeltLanternSave, T>> decode(DynamicOps<T> ops, T input) {
                return class_2487.field_25128.parse(ops, input).map(nbt -> {
                    class_3218 world = ctx.method_67417();
                    class_7225.class_7874 registries = new class_7877().method_46780(world.method_30349());
                    return Pair.of((Object)((Object)BeltLanternSave.fromNbt(nbt, registries)), (Object)input);
                });
            }
        });
    }

    public static BeltLanternSave get(MinecraftServer server) {
        class_26 psManager = server.method_30002().method_17983();
        return (BeltLanternSave)psManager.method_17924(TYPE);
    }

    public BeltLanternSave() {
    }

    public BeltLanternSave(class_18.class_10740 ctx) {
    }

    public boolean has(UUID uuid) {
        return this.playersWithLamps.containsKey(uuid);
    }

    public class_1792 get(UUID uuid) {
        class_1799 stack = this.playersWithLamps.get(uuid);
        return stack != null ? stack.method_7909() : null;
    }

    public class_1799 getStack(UUID uuid) {
        class_1799 stack = this.playersWithLamps.get(uuid);
        return stack != null ? stack.method_7972() : null;
    }

    public void set(UUID uuid, class_1799 lamp) {
        if (lamp != null && !lamp.method_7960()) {
            this.playersWithLamps.put(uuid, lamp.method_46651(1));
        } else {
            this.playersWithLamps.remove(uuid);
        }
        this.method_80();
    }

    public void set(UUID uuid, class_1792 lamp) {
        if (lamp != null) {
            this.playersWithLamps.put(uuid, new class_1799((class_1935)lamp));
        } else {
            this.playersWithLamps.remove(uuid);
        }
        this.method_80();
    }

    public static BeltLanternSave fromNbt(class_2487 nbt) {
        BeltLanternSave save = new BeltLanternSave();
        class_2487 map = nbt.method_68568(PLAYERS_KEY);
        for (String key : map.method_10541()) {
            try {
                UUID uuid = UUID.fromString(key);
                map.method_10558(key).ifPresent(str -> {
                    class_2960 id = class_2960.method_12829((String)str);
                    if (id != null) {
                        save.playersWithLamps.put(uuid, new class_1799((class_1935)class_7923.field_41178.method_63535(id)));
                    }
                });
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return save;
    }

    public static BeltLanternSave fromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        BeltLanternSave save = new BeltLanternSave();
        class_2487 map = nbt.method_68568(PLAYERS_KEY);
        for (String key : map.method_10541()) {
            try {
                UUID uuid = UUID.fromString(key);
                class_2520 el = map.method_10580(key);
                if (el != null && !(el instanceof class_2519)) {
                    class_1799 stack = class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)el).orElse(class_1799.field_8037);
                    if (stack.method_7960()) continue;
                    save.playersWithLamps.put(uuid, stack);
                    continue;
                }
                map.method_10558(key).ifPresent(str -> {
                    class_2960 id = class_2960.method_12829((String)str);
                    if (id != null) {
                        save.playersWithLamps.put(uuid, new class_1799((class_1935)class_7923.field_41178.method_63535(id)));
                    }
                });
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return save;
    }

    public class_2487 writeNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2487 map = new class_2487();
        for (Map.Entry<UUID, class_1799> e : this.playersWithLamps.entrySet()) {
            class_2520 encoded = e.getValue().method_57358(registryLookup);
            map.method_10566(e.getKey().toString(), encoded);
        }
        nbt.method_10566(PLAYERS_KEY, (class_2520)map);
        return nbt;
    }
}

