/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.config;

import java.util.LinkedHashMap;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.config.BLClientConfig;
import net.oxcodsnet.beltborne_lanterns.common.config.BLLampConfig;

public final class BLLampConfigAccess {
    private static volatile ConfigHolder<BLLampConfig> HOLDER;

    private BLLampConfigAccess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureInit() {
        if (HOLDER != null) {
            return;
        }
        Class<BLLampConfigAccess> clazz = BLLampConfigAccess.class;
        synchronized (BLLampConfigAccess.class) {
            if (HOLDER != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            AutoConfig.register(BLLampConfig.class, GsonConfigSerializer::new);
            HOLDER = AutoConfig.getConfigHolder(BLLampConfig.class);
            BLLampConfig lampConfig = (BLLampConfig)HOLDER.getConfig();
            LinkedHashMap combinedLamps = new LinkedHashMap();
            LampRegistry.items().forEach(item -> {
                String id = LampRegistry.getId(item).toString();
                int luminance = LampRegistry.getLuminance(item);
                combinedLamps.put(id, new BLClientConfig.ExtraLampEntry(id, luminance));
            });
            lampConfig.extraLampLight.forEach(entry -> combinedLamps.put(entry.id, new BLClientConfig.ExtraLampEntry(entry.id, entry.luminance)));
            lampConfig.extraLampLight.clear();
            lampConfig.extraLampLight.addAll(combinedLamps.values());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static BLLampConfig get() {
        BLLampConfigAccess.ensureInit();
        return (BLLampConfig)HOLDER.getConfig();
    }

    public static void save() {
        BLLampConfigAccess.ensureInit();
        HOLDER.save();
    }
}

