/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.fabric;

import java.util.LinkedHashMap;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.oxcodsnet.beltborne_lanterns.common.BeltState;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.config.BLLampConfigAccess;
import net.oxcodsnet.beltborne_lanterns.common.network.LampConfigSyncPayload;
import net.oxcodsnet.beltborne_lanterns.common.network.ToggleLanternPayload;
import net.oxcodsnet.beltborne_lanterns.common.persistence.BeltLanternSave;
import net.oxcodsnet.beltborne_lanterns.common.server.BeltLanternServer;
import net.oxcodsnet.beltborne_lanterns.fabric.BeltNetworking;

public final class BLFabricServerEvents {
    private BLFabricServerEvents() {
    }

    public static void initialize() {
        ServerPlayNetworking.registerGlobalReceiver(ToggleLanternPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> {
                class_1799 stack = player.method_6047();
                boolean hasLamp = BeltState.hasLamp((class_1657)player);
                if (!(hasLamp || LampRegistry.isLamp(stack) || LampRegistry.isLamp(stack = player.method_6079()))) {
                    return;
                }
                class_1792 nowHas = BeltLanternServer.toggleLantern(player, stack);
                BeltNetworking.broadcastBeltState(player, nowHas);
            });
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 joining = handler.method_32311();
            class_1799 persistedStack = BeltLanternSave.get(server).getStack(joining.method_5667());
            class_1792 persisted = persistedStack != null ? persistedStack.method_7909() : null;
            BeltState.setLamp((class_1657)joining, persistedStack);
            BeltNetworking.broadcastBeltState(joining, persisted);
            if (server.method_3816()) {
                LinkedHashMap<class_2960, Integer> lampMap = new LinkedHashMap<class_2960, Integer>();
                BLLampConfigAccess.get().extraLampLight.forEach(entry -> {
                    class_2960 id = class_2960.method_12829((String)entry.id);
                    if (id != null) {
                        lampMap.put(id, entry.luminance);
                    }
                });
                ServerPlayNetworking.send((class_3222)joining, (class_8710)new LampConfigSyncPayload(lampMap));
            }
            for (class_3222 other : server.method_3760().method_14571()) {
                class_1792 lamp = BeltState.getLamp((class_1657)other);
                BeltNetworking.sendTo(joining, other.method_5667(), lamp);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 leaving = handler.method_32311();
            BeltLanternSave.get(server).set(leaving.method_5667(), BeltState.getLampStack((class_1657)leaving));
        });
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            if (alive) {
                return;
            }
            boolean keep = oldPlayer.method_51469().method_64395().method_8355(class_1928.field_19389);
            BeltLanternServer.handleDeath(oldPlayer, newPlayer, keep);
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (alive) {
                return;
            }
            class_1792 lamp = BeltState.getLamp((class_1657)newPlayer);
            BeltNetworking.broadcastBeltState(newPlayer, lamp);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> LampRegistry.init());
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> LampRegistry.init());
    }
}

