/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.compat;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.compat.CompatibilityLayer;

public final class CompatibilityLayerRegistry {
    private static final List<CompatibilityLayer> LOADED_LAYERS = new ArrayList<CompatibilityLayer>();
    private static boolean isInitialized = false;

    private CompatibilityLayerRegistry() {
    }

    public static void loadLayers(Function<String, Boolean> isModLoaded) {
        if (isInitialized) {
            return;
        }
        ServiceLoader.load(CompatibilityLayer.class).forEach(layer -> {
            if (((Boolean)isModLoaded.apply(layer.getModId())).booleanValue()) {
                LOADED_LAYERS.add((CompatibilityLayer)layer);
                BLMod.LOGGER.info("Loaded compatibility layer for mod: {}", (Object)layer.getModId());
            }
        });
        isInitialized = true;
    }

    public static void initializeLayers() {
        if (!isInitialized) {
            BLMod.LOGGER.warn("Compatibility layers have not been loaded yet!");
            return;
        }
        LOADED_LAYERS.forEach(CompatibilityLayer::onInitialize);
    }

    public static List<CompatibilityLayer> getLayers() {
        return LOADED_LAYERS;
    }

    public static <T extends CompatibilityLayer> List<T> getLayers(Class<T> type) {
        return LOADED_LAYERS.stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }
}

