/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.neoforge;

import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.oxcodsnet.beltborne_lanterns.common.BeltState;
import net.oxcodsnet.beltborne_lanterns.common.DynamicLightsCompat;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.client.ClientBeltPlayers;
import net.oxcodsnet.beltborne_lanterns.common.compat.CompatibilityLayer;
import net.oxcodsnet.beltborne_lanterns.common.compat.CompatibilityLayerRegistry;
import net.oxcodsnet.beltborne_lanterns.common.config.BLClientConfig;
import net.oxcodsnet.beltborne_lanterns.common.config.BLClientConfigAccess;
import net.oxcodsnet.beltborne_lanterns.common.network.BeltSyncPayload;
import net.oxcodsnet.beltborne_lanterns.common.network.LampConfigSyncPayload;
import net.oxcodsnet.beltborne_lanterns.common.network.ToggleLanternPayload;
import net.oxcodsnet.beltborne_lanterns.common.server.BeltLanternServer;
import net.oxcodsnet.beltborne_lanterns.neoforge.BeltNetworking;

@EventBusSubscriber(modid="beltborne_lanterns", bus=EventBusSubscriber.Bus.MOD)
public final class BLNeoForgeNetwork {
    private BLNeoForgeNetwork() {
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(ToggleLanternPayload.ID, ToggleLanternPayload.CODEC, (payload, ctx) -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            ctx.enqueueWork(() -> {
                for (CompatibilityLayer layer : CompatibilityLayerRegistry.getLayers()) {
                    if (!layer.tryToggleLantern(player)) continue;
                    return;
                }
                ItemStack stack = player.getMainHandItem();
                boolean hasLamp = BeltState.hasLamp((Player)player);
                if (!(hasLamp || LampRegistry.isLamp(stack) || LampRegistry.isLamp(stack = player.getOffhandItem()))) {
                    return;
                }
                Item nowHas = BeltLanternServer.toggleLantern(player, stack);
                BeltNetworking.broadcastBeltState(player, nowHas);
                if (nowHas != null) {
                    for (CompatibilityLayer layer : CompatibilityLayerRegistry.getLayers()) {
                        layer.syncToggleOn(player);
                    }
                    DynamicLightsCompat.addFor(player);
                } else {
                    DynamicLightsCompat.removeFor(player);
                }
            });
        });
        registrar.playToClient(BeltSyncPayload.ID, BeltSyncPayload.CODEC, (payload, ctx) -> {
            UUID uuid = payload.playerUuid();
            Item lamp = payload.lampId() != null ? (Item)BuiltInRegistries.ITEM.getValue(payload.lampId()) : null;
            ClientBeltPlayers.setLamp(uuid, lamp);
        });
        registrar.playToClient(LampConfigSyncPayload.ID, LampConfigSyncPayload.CODEC, (payload, ctx) -> ctx.enqueueWork(() -> {
            BLClientConfig cliCfg = BLClientConfigAccess.get();
            cliCfg.extraLampLight.clear();
            payload.lamps().forEach((id, lum) -> cliCfg.extraLampLight.add(new BLClientConfig.ExtraLampEntry(id.toString(), (int)lum)));
            BLClientConfigAccess.save();
            LampRegistry.init();
        }));
    }
}

