/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common;

import java.lang.reflect.Method;
import java.util.function.Function;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.oxcodsnet.beltborne_lanterns.BLMod;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.client.BLClientAbstractions;

public final class LambDynLightsCompat {
    private static boolean INITIALIZED = false;

    public static boolean isInitialized() {
        return INITIALIZED;
    }

    public static void markInitialized() {
        INITIALIZED = true;
    }

    public static void init() {
        if (INITIALIZED) {
            return;
        }
        try {
            Class<?> handlerClass = Class.forName("dev.lambdaurora.lambdynlights.api.DynamicLightHandler");
            Class<?> handlersClass = Class.forName("dev.lambdaurora.lambdynlights.api.DynamicLightHandlers");
            Function<Player, Integer> luminance = player -> {
                Item lamp = BLClientAbstractions.clientLamp(player);
                return lamp != null ? LampRegistry.getLuminance(lamp) : 0;
            };
            Function<Player, Boolean> waterSensitive = player -> false;
            Method makeHandler = handlerClass.getMethod("makeHandler", Function.class, Function.class);
            Object handler = makeHandler.invoke(null, luminance, waterSensitive);
            Method makeLiving = handlerClass.getMethod("makeLivingEntityHandler", handlerClass);
            Object livingHandler = makeLiving.invoke(null, handler);
            Method register = handlersClass.getMethod("registerDynamicLightHandler", EntityType.class, handlerClass);
            register.invoke(null, EntityType.PLAYER, livingHandler);
            BLMod.LOGGER.info("Dynamic lights: integrated via LambDynamicLights API (handler)");
            INITIALIZED = true;
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }
}

