/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.client.BLClientAbstractions;
import net.oxcodsnet.beltborne_lanterns.common.client.BLDebugRender;
import net.oxcodsnet.beltborne_lanterns.common.config.BLConfig;
import net.oxcodsnet.beltborne_lanterns.common.config.BLConfigs;
import net.oxcodsnet.beltborne_lanterns.common.physics.LanternSwingManager;
import org.joml.Quaternionfc;

public class LanternBeltFeatureRenderer
extends RenderLayer<PlayerRenderState, PlayerModel> {
    private static final float MODEL_Y_ROTATION_DEGREES = 180.0f;

    public LanternBeltFeatureRenderer(RenderLayerParent<?, ?> context) {
        super(context);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, PlayerRenderState state, float limbAngle, float limbDistance) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (!BLClientAbstractions.clientHasLantern((Player)player)) {
            return;
        }
        BLConfig c = BLConfigs.get();
        matrices.pushPose();
        LanternBeltFeatureRenderer.applyModelPart(matrices, ((PlayerModel)this.getParentModel()).body);
        float offX = c.fOffsetX();
        float offY = c.fOffsetY();
        float offZ = c.fOffsetZ();
        float pivX = c.fPivotX();
        float pivY = c.fPivotY();
        float pivZ = c.fPivotZ();
        float s = c.fScale();
        matrices.translate(offX, offY, offZ);
        if (BLClientAbstractions.isDebugDrawEnabled()) {
            matrices.pushPose();
            matrices.translate(pivX, pivY, pivZ);
            BLDebugRender.drawAxesAndAnchor(matrices, vertexConsumers, 0.25f);
            matrices.popPose();
        }
        matrices.translate(pivX, pivY, pivZ);
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        matrices.scale(s, s, s);
        float dynX = LanternSwingManager.getXDeg(player.getUUID());
        float dynZ = LanternSwingManager.getZDeg(player.getUUID());
        float baseX = LanternSwingManager.getBaseXDeg(player.getUUID());
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(baseX + dynX));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)c.rotYDeg));
        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)c.rotZDeg + dynZ));
        matrices.translate(-pivX, -pivY, -pivZ);
        BlockRenderDispatcher brm = Minecraft.getInstance().getBlockRenderer();
        BlockState blockState = LampRegistry.getState(BLClientAbstractions.clientLamp((Player)player));
        brm.renderSingleBlock(blockState, matrices, vertexConsumers, light, OverlayTexture.NO_OVERLAY);
        matrices.popPose();
    }

    private static void applyModelPart(PoseStack matrices, ModelPart part) {
        part.translateAndRotate(matrices);
    }
}

