/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.neoforge;

import java.util.LinkedHashMap;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.oxcodsnet.beltborne_lanterns.common.BeltState;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.config.BLLampConfigAccess;
import net.oxcodsnet.beltborne_lanterns.common.network.LampConfigSyncPayload;
import net.oxcodsnet.beltborne_lanterns.common.persistence.BeltLanternSave;
import net.oxcodsnet.beltborne_lanterns.common.server.BeltLanternServer;
import net.oxcodsnet.beltborne_lanterns.neoforge.BeltNetworking;

@EventBusSubscriber(modid="beltborne_lanterns")
public final class BLNeoForgeServerEvents {
    private BLNeoForgeServerEvents() {
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent e) {
        LampRegistry.init();
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer joining = (ServerPlayer)player;
        MinecraftServer server = joining.server;
        ItemStack persistedStack = BeltLanternSave.get(server).getStack(joining.getUUID());
        Item persisted = persistedStack != null ? persistedStack.getItem() : null;
        BeltState.setLamp((Player)joining, persistedStack);
        BeltNetworking.broadcastBeltState(joining, persisted);
        if (server.isDedicatedServer()) {
            LinkedHashMap<ResourceLocation, Integer> lampMap = new LinkedHashMap<ResourceLocation, Integer>();
            BLLampConfigAccess.get().extraLampLight.forEach(entry -> {
                ResourceLocation id = ResourceLocation.tryParse((String)entry.id);
                if (id != null) {
                    lampMap.put(id, entry.luminance);
                }
            });
            PacketDistributor.sendToPlayer((ServerPlayer)joining, (CustomPacketPayload)new LampConfigSyncPayload(lampMap), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        for (ServerPlayer other : server.getPlayerList().getPlayers()) {
            Item lamp = BeltState.getLamp((Player)other);
            BeltNetworking.sendTo(joining, other.getUUID(), lamp);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer leaving = (ServerPlayer)player;
        BeltLanternSave.get(leaving.server).set(leaving.getUUID(), BeltState.getLampStack((Player)leaving));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getOriginal();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer oldPlayer = (ServerPlayer)player;
        if (!event.isWasDeath()) {
            return;
        }
        ServerPlayer newPlayer = (ServerPlayer)event.getEntity();
        boolean keep = oldPlayer.serverLevel().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
        BeltLanternServer.handleDeath(oldPlayer, newPlayer, keep);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Item lamp = BeltState.getLamp((Player)player2);
        BeltNetworking.broadcastBeltState(player2, lamp);
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        LampRegistry.init();
    }
}

