/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.client.BLClientAbstractions;
import net.oxcodsnet.beltborne_lanterns.common.client.BLDebugRender;
import net.oxcodsnet.beltborne_lanterns.common.config.BLConfig;
import net.oxcodsnet.beltborne_lanterns.common.config.BLConfigs;
import net.oxcodsnet.beltborne_lanterns.common.physics.LanternSwingManager;

public class LanternBeltFeatureRenderer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final float MODEL_Y_ROTATION_DEGREES = 180.0f;

    public LanternBeltFeatureRenderer(RenderLayerParent<T, M> context) {
        super(context);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!BLClientAbstractions.clientHasLantern(player)) {
            return;
        }
        BLConfig c = BLConfigs.get();
        matrices.pushPose();
        ((HumanoidModel)this.getParentModel()).body.translateAndRotate(matrices);
        float offX = c.fOffsetX();
        float offY = c.fOffsetY();
        float offZ = c.fOffsetZ();
        float pivX = c.fPivotX();
        float pivY = c.fPivotY();
        float pivZ = c.fPivotZ();
        float s = c.fScale();
        matrices.translate(offX, offY, offZ);
        if (BLClientAbstractions.isDebugDrawEnabled()) {
            matrices.pushPose();
            matrices.translate(pivX, pivY, pivZ);
            BLDebugRender.drawAxesAndAnchor(matrices, vertexConsumers, 0.25f);
            matrices.popPose();
        }
        matrices.translate(pivX, pivY, pivZ);
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrices.scale(s, s, s);
        float dynX = LanternSwingManager.getXDeg(player.getUUID());
        float dynZ = LanternSwingManager.getZDeg(player.getUUID());
        float baseX = LanternSwingManager.getBaseXDeg(player.getUUID());
        matrices.mulPose(Axis.XP.rotationDegrees(baseX + dynX));
        matrices.mulPose(Axis.YP.rotationDegrees((float)c.rotYDeg));
        matrices.mulPose(Axis.ZP.rotationDegrees((float)c.rotZDeg + dynZ));
        matrices.translate(-pivX, -pivY, -pivZ);
        BlockRenderDispatcher brm = Minecraft.getInstance().getBlockRenderer();
        BlockState state = LampRegistry.getState(BLClientAbstractions.clientLamp(player));
        brm.renderSingleBlock(state, matrices, vertexConsumers, light, OverlayTexture.NO_OVERLAY);
        matrices.popPose();
    }
}

