/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.beltborne_lanterns.common.server;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.oxcodsnet.beltborne_lanterns.common.BeltState;
import net.oxcodsnet.beltborne_lanterns.common.LampRegistry;
import net.oxcodsnet.beltborne_lanterns.common.persistence.BeltLanternSave;

public final class BeltLanternServer {
    private BeltLanternServer() {
    }

    public static Item toggleLantern(ServerPlayer player, ItemStack stackInHand) {
        Item current = BeltState.getLamp((Player)player);
        boolean creative = player.isCreative();
        if (current == null) {
            Item item = stackInHand.getItem();
            if (!LampRegistry.isLamp(item)) {
                return null;
            }
            ItemStack equipped = stackInHand.copyWithCount(1);
            if (!creative) {
                stackInHand.shrink(1);
            }
            BeltState.setLamp((Player)player, equipped);
            BeltLanternSave.get(player.server).set(player.getUUID(), equipped);
            return item;
        }
        if (!creative) {
            ItemStack stored = BeltState.getLampStack((Player)player);
            if (stored != null && !stored.isEmpty()) {
                player.addItem(stored);
            } else {
                player.addItem(new ItemStack((ItemLike)current));
            }
        }
        BeltState.setLamp((Player)player, (ItemStack)null);
        BeltLanternSave.get(player.server).set(player.getUUID(), (ItemStack)null);
        return null;
    }

    public static Item handleDeath(ServerPlayer player, boolean keepInventory) {
        Item lamp = BeltState.getLamp((Player)player);
        if (lamp == null) {
            return null;
        }
        if (keepInventory) {
            return lamp;
        }
        ItemStack stored = BeltState.getLampStack((Player)player);
        if (stored != null && !stored.isEmpty()) {
            player.spawnAtLocation(stored);
        } else {
            player.spawnAtLocation(new ItemStack((ItemLike)lamp));
        }
        BeltState.setLamp((Player)player, (ItemStack)null);
        BeltLanternSave.get(player.server).set(player.getUUID(), (ItemStack)null);
        return null;
    }
}

