package sh.sit.endanchor;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1774;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4208;
import net.minecraft.class_4970;
import net.minecraft.class_5275;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class EndAnchorBlock extends class_2248 implements class_2343 {
    public static final class_2746 CHARGED = class_2746.method_11825("charged");

    public EndAnchorBlock() {
        super(class_4970.class_2251.method_9637()
                .method_63500(class_5321.method_29179(class_7924.field_41254, class_2960.method_60655("endanchor", "end_anchor")))
                .method_9632(4f)
                .method_9631(blockState -> blockState.method_11654(CHARGED) ? 10 : 0));

        method_9590(method_9564().method_11657(CHARGED, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(CHARGED);
    }

    @Override
    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        // charge the anchor if holding end crystal
        if (stack.method_7909() instanceof class_1774 && !state.method_11654(CHARGED)) {
            // don't charge if the player is not allowed to modify world
            if (!player.method_31549().field_7476) {
                return class_1269.field_52423;
            }

            world.method_8501(pos, state.method_11657(CHARGED, true));
            player.method_5783(class_3417.field_23116, 1, 1);
            if (!player.method_31549().field_7477) {
                stack.method_57008(1, player);
            }
            return class_1269.field_5812;
        }

        // if not the end, explode
        if (!world.method_40134().method_40225(class_7134.field_37668)) {
            if (!world.field_9236) {
                explode(state, world, pos);
            }

            return class_1269.field_5812;
        }

        // if charged and not holding end crystal
        if (state.method_11654(CHARGED)) {
            if (world.field_9236) {
                return class_1269.field_5812;
            }

            final EndAnchorBlockEntity blockEntity = (EndAnchorBlockEntity) world.method_8321(pos);
            final class_2338 lodestonePos = Objects.requireNonNull(blockEntity).getLodestonePos();

            if (world.method_8320(lodestonePos).method_26204() != class_2246.field_23261) {
                playErrorSound(world, pos);
                return class_1269.field_5812;
            }

            final class_2338 spawnPos = lodestonePos.method_10069(0, 1, 0);
            final class_243 teleportTarget = class_5275.method_30769(class_1299.field_6097, world, spawnPos, false);

            if (teleportTarget == null) {
                playErrorSound(world, pos);
            } else {
                world.method_8501(pos, state.method_11657(CHARGED, false));

                player.method_6082(teleportTarget.field_1352, teleportTarget.field_1351, teleportTarget.field_1350, true);

                final MinecraftServer server = world.method_8503();
                if (server != null) {
                    final class_243 centerBlockPos = pos.method_46558();

                    // fixme: this doesn't look right
                    server.method_3760().method_14605(
                            null,
                            centerBlockPos.field_1352,
                            centerBlockPos.field_1351,
                            centerBlockPos.field_1350,
                            30f,
                            world.method_27983(),
                            new class_2767(
                                    class_7923.field_41172.method_47983(class_3417.field_46945),
                                    class_3419.field_15248,
                                    centerBlockPos.field_1352,
                                    centerBlockPos.field_1351,
                                    centerBlockPos.field_1350,
                                    1,
                                    1,
                                    world.field_9229.method_43055()
                            )
                    );
                    server.method_3760().method_14605(
                            null,
                            teleportTarget.field_1352,
                            teleportTarget.field_1351,
                            teleportTarget.field_1350,
                            30f,
                            world.method_27983(),
                            new class_2767(
                                    class_7923.field_41172.method_47983(class_3417.field_46945),
                                    class_3419.field_15248,
                                    teleportTarget.field_1352,
                                    teleportTarget.field_1351,
                                    teleportTarget.field_1350,
                                    1,
                                    1,
                                    world.field_9229.method_43055()
                            )
                    );
                }
            }

            return class_1269.field_5812;
        }

        return class_1269.field_52423;
    }

    private static void explode(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8650(pos, false);
        world.method_46407(
                null,
                world.method_48963().method_48808(pos.method_46558()),
                null,
                pos.method_46558(),
                // make the explosion two times as big if charged with crystal
                5.0F * (state.method_11654(CHARGED) ? 2 : 1),
                true,
                class_1937.class_7867.field_40889
        );
    }

    private static void playErrorSound(class_1937 world, class_2338 pos) {
        world.method_8396(
                null,
                pos,
                class_3417.field_46945,
                class_3419.field_15248,
                1,
                -2f
        );
    }

    @Override
    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        final EndAnchorBlockEntity blockEntity = (EndAnchorBlockEntity) builder.method_51876(class_181.field_1228);
        if (blockEntity == null) return super.method_9560(state, builder);

        final class_1799 tool = builder.method_51876(class_181.field_1229);
        if (tool == null) return super.method_9560(state, builder);

        final class_4208 lodestonePos = new class_4208(class_1937.field_25181, blockEntity.getLodestonePos());
        final class_9291 lodestoneTrackerComponent =
                new class_9291(Optional.of(lodestonePos), true);

        final class_6880<class_1887> silkTouchEnchantment = builder.method_51870()
                .method_30349()
                .method_30530(class_7924.field_41265)
                .method_46747(class_1893.field_9099);

        if (class_1890.method_8225(silkTouchEnchantment, tool) >= 1) {
            final class_1799 droppedStack = new class_1799(SitsEndAnchor.END_ANCHOR_BLOCK_ITEM);
            droppedStack.method_57379(class_9334.field_49614, lodestoneTrackerComponent);

            return Collections.singletonList(droppedStack);
        } else {
            final class_1799 droppedStack = new class_1799(class_1802.field_8251);
            droppedStack.method_57379(class_9334.field_49614, lodestoneTrackerComponent);

            return Collections.singletonList(droppedStack);
        }
    }

    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return state.method_11654(CHARGED) ? 15 : 0;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new EndAnchorBlockEntity(pos, state);
    }

    public static void registerDispenserBehaviour() {
        class_2315.method_10009(class_1802.field_8301, (pointer, stack) -> {
            final class_2338 targetBlock = pointer.comp_1968().method_10093(pointer.comp_1969().method_11654(class_2315.field_10918));
            final class_2680 targetState = pointer.comp_1967().method_8320(targetBlock);

            if (targetState.method_27852(SitsEndAnchor.END_ANCHOR_BLOCK) && !targetState.method_11654(CHARGED)) {
                pointer.comp_1967().method_8501(targetBlock, targetState.method_11657(CHARGED, true));
                stack.method_7934(1);
            }
            return stack;
        });
    }
}
