package sh.sit.endanchor;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10295;
import net.minecraft.class_10300;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3955;
import net.minecraft.class_4208;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import net.minecraft.class_9887;
import net.minecraft.recipe.*;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public class EndAnchorBlockCraftingRecipe implements class_3955 {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndAnchorBlockCraftingRecipe.class);

    final String group;
    final class_7710 category;
    final class_8957 raw;
    final boolean showNotification;

    public EndAnchorBlockCraftingRecipe(String group,
                                        class_7710 category,
                                        class_8957 raw,
                                        boolean showNotification) {
        this.group = group;
        this.category = category;
        this.raw = raw;
        this.showNotification = showNotification;
    }

    @Override
    public boolean matches(class_9694 input, class_1937 world) {
        if (!raw.method_55078(input)) return false;

        // find the lodestone compass in the recipe
        class_1799 lodestoneCompassStack = findLodestoneCompass(input);
        if (lodestoneCompassStack == null) return false;

        // check the position the compass is pointing to
        class_9291 lodestoneTrackerComponent = lodestoneCompassStack.method_57824(class_9334.field_49614);
        assert lodestoneTrackerComponent != null;

        final class_4208 lodestonePos = lodestoneTrackerComponent.comp_2402().orElse(null);
        if (lodestonePos == null) {
            return false;
        }

        // ensure compass points to the end
        return lodestonePos.comp_2207() == class_1937.field_25181;
    }

    private static @Nullable class_1799 findLodestoneCompass(class_9694 input) {
        class_1799 lodestoneCompassStack = null;
        for (int i = 0; i < input.method_59983(); i++) {
            final class_1799 stack = input.method_59984(i);
            if (stack.method_31574(class_1802.field_8251) && stack.method_57824(class_9334.field_49614) != null) {
                if (lodestoneCompassStack != null) {
                    LOGGER.info("Invalid end anchor recipe: multiple lodestone compasses");
                    return null;
                }
                lodestoneCompassStack = stack;
            }
        }

        if (lodestoneCompassStack == null) {
            LOGGER.info("Invalid end anchor recipe: no lodestone compass");
            return null;
        }

        return lodestoneCompassStack;
    }

    @Override
    public class_1799 craft(class_9694 input, class_7225.class_7874 lookup) {
        // just in case?
        if (!matches(input, null)) {
            return class_1799.field_8037;
        }

        final class_1799 lodestoneCompassStack = findLodestoneCompass(input);
        assert lodestoneCompassStack != null; // checked in matches()
        final class_9291 lodestoneTrackerComponent = lodestoneCompassStack.method_57824(class_9334.field_49614);
        assert lodestoneTrackerComponent != null; // checked in matches()

        final class_4208 lodestonePos = lodestoneTrackerComponent.comp_2402().orElse(null);
        assert lodestonePos != null; // checked in matches()

        final class_1799 result = new class_1799(SitsEndAnchor.END_ANCHOR_BLOCK_ITEM);
        result.method_57379(class_9334.field_49614, lodestoneTrackerComponent);

        return result;
    }

    @Override
    public class_1865<EndAnchorBlockCraftingRecipe> method_8119() {
        return SitsEndAnchor.END_ANCHOR_BLOCK_CRAFTING_RECIPE;
    }

    @Override
    public class_9887 method_61671() {
        return class_9887.method_61683(raw.method_59997());
    }

    @Override
    public class_7710 method_45441() {
        return category;
    }

    @Override
    public String method_8112() {
        return group;
    }

    @Override
    public boolean method_49188() {
        return showNotification;
    }

    @Override
    public List<class_10295> method_64664() {
        return List.of(new class_10300(this.raw.method_59995(),
                this.raw.method_59996(),
                this.raw.method_59997()
                        .stream()
                        .map((ingredient) -> ingredient
                                .map(class_1856::method_64673)
                                .orElse(class_10302.class_10305.field_54681))
                        .toList(),
                new class_10302.class_10307(new class_1799(SitsEndAnchor.END_ANCHOR_BLOCK_ITEM)),
                new class_10302.class_10306(class_1802.field_8465)
        ));
    }

    public static class Serializer implements class_1865<EndAnchorBlockCraftingRecipe> {
        public static final MapCodec<EndAnchorBlockCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(
                instance -> instance.group(
                                Codec.STRING.optionalFieldOf("group", "").forGetter(recipe -> recipe.group),
                                class_7710.field_40252.fieldOf("category").orElse(class_7710.field_40251).forGetter(recipe -> recipe.category),
                                class_8957.field_47321.forGetter(recipe -> recipe.raw),
                                Codec.BOOL.optionalFieldOf("show_notification", Boolean.TRUE).forGetter(recipe -> recipe.showNotification)
                        )
                        .apply(instance, EndAnchorBlockCraftingRecipe::new)
        );
        public static final class_9139<class_9129, EndAnchorBlockCraftingRecipe> PACKET_CODEC = class_9139.method_56437(
                Serializer::write, Serializer::read
        );

        @Override
        public MapCodec<EndAnchorBlockCraftingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, EndAnchorBlockCraftingRecipe> method_56104() {
            return PACKET_CODEC;
        }

        private static EndAnchorBlockCraftingRecipe read(class_9129 buf) {
            String string = buf.method_19772();
            class_7710 craftingRecipeCategory = buf.method_10818(class_7710.class);
            class_8957 rawShapedRecipe = class_8957.field_48359.decode(buf);
            boolean bl = buf.readBoolean();
            return new EndAnchorBlockCraftingRecipe(string, craftingRecipeCategory, rawShapedRecipe, bl);
        }

        private static void write(class_9129 buf, EndAnchorBlockCraftingRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_10817(recipe.category);
            class_8957.field_48359.encode(buf, recipe.raw);
            buf.method_52964(recipe.showNotification);
        }
    }
}
