package sh.sit.endanchor;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import net.minecraft.class_1208;
import net.minecraft.class_7505;
import net.minecraft.class_9228;

public class EndAnchorBlockPosFormatFix extends DataFix {
    public EndAnchorBlockPosFormatFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    @Override
    public TypeRewriteRule makeRule() {
        Type<?> type = this.getInputSchema().getType(class_1208.field_5712);
        return this.fixTypeEverywhereTyped(
                "BlockPos format for end anchor target",
                type,
                class_7505.method_56971(type,
                        "endanchor:end_anchor"::equals,
                        tagDynamic -> tagDynamic
                                .update("LodestonePos", class_9228::method_56943)
                                // dimension is ignored, so it's probably ok to just hardcode it?
                                // this is such a hack
                                .set("LodestoneDimension", tagDynamic.createString("minecraft:the_end"))
                )
        );
    }
}
