/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.areas_common_fabric.util;

import com.natamus.areas_common_fabric.config.ConfigHandler;
import com.natamus.areas_common_fabric.data.AreaVariables;
import com.natamus.areas_common_fabric.data.ClientConstants;
import com.natamus.areas_common_fabric.data.GUIVariables;
import com.natamus.areas_common_fabric.functions.ZoneFunctions;
import com.natamus.areas_common_fabric.objects.AreaObject;
import com.natamus.collective_common_fabric.data.GlobalVariables;
import com.natamus.collective_common_fabric.functions.HashMapFunctions;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.collective_common_fabric.functions.SignFunctions;
import com.natamus.collective_common_fabric.functions.TileEntityFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2478;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_437;
import net.minecraft.class_498;
import net.minecraft.class_7744;
import net.minecraft.class_8242;

public class Util {
    public static AreaObject getAreaSign(class_1937 level, class_2338 signPos) {
        class_2586 blockEntity = level.method_8321(signPos);
        if (!(blockEntity instanceof class_2625)) {
            return null;
        }
        class_2625 signBlockEntity = (class_2625)blockEntity;
        StringBuilder areaNameBuilder = new StringBuilder();
        String rgb = "";
        String zonePrefix = "Area";
        int radius = ConfigHandler.defaultAreaRadius;
        boolean customrgb = false;
        List signLines = SignFunctions.getSignText((class_2586)blockEntity);
        HashMap areaObjectHashMap = (HashMap)HashMapFunctions.computeIfAbsent(AreaVariables.areaObjects, (Object)level, k -> new HashMap());
        if (areaObjectHashMap != null && areaObjectHashMap.containsKey(signPos)) {
            AreaObject cachedAreaObject = (AreaObject)areaObjectHashMap.get(signPos);
            if (cachedAreaObject.signLines.equals(signLines)) {
                return cachedAreaObject;
            }
            AreaVariables.areaObjects.get(level).remove(signPos);
        }
        int i = -1;
        for (String line : signLines) {
            if (++i == 0 && !ZoneFunctions.hasZonePrefix(line)) {
                return null;
            }
            if (i > 3) break;
            if (line.length() < 1) continue;
            Integer possibleradius = ZoneFunctions.getRadius(line.toLowerCase());
            if (possibleradius >= 0) {
                radius = possibleradius;
                continue;
            }
            String possiblergb = ZoneFunctions.getZoneRGB(line.toLowerCase());
            if (!possiblergb.equals("")) {
                rgb = possiblergb;
                continue;
            }
            if (ZoneFunctions.hasZonePrefix(line)) continue;
            if (!areaNameBuilder.toString().equals("")) {
                areaNameBuilder.append(" ");
            }
            areaNameBuilder.append(line);
        }
        String areaName = areaNameBuilder.toString();
        return new AreaObject(level, signPos, areaName, radius, rgb, signLines);
    }

    /*
     * WARNING - void declaration
     */
    public static void updateAreaSign(class_1937 level, class_2338 signPos, class_2625 signBlockEntity, List<String> signLines, String areaName, String zonePrefix, String rgb, int radius, boolean customrgb) {
        int i;
        boolean setradius = false;
        int maxradius = ConfigHandler.radiusAroundPlayerToCheckForSigns;
        if (radius > maxradius) {
            radius = maxradius;
            setradius = true;
        }
        StringBuilder areaNameBuilder = new StringBuilder();
        boolean shouldUpdateSign = false;
        if (areaName.trim().equals("")) {
            void var15_16;
            ArrayList<Object> newSignContentList = new ArrayList<Object>();
            newSignContentList.add("[" + zonePrefix + "] " + radius);
            if (customrgb) {
                newSignContentList.add("[RGB] " + rgb);
            } else {
                newSignContentList.add("");
            }
            if (ConfigHandler.giveUnnamedAreasRandomName) {
                String string = Util.getRandomAreaName();
                for (String word : string.split(" ")) {
                    if (newSignContentList.size() != 8) {
                        newSignContentList.add(word);
                        continue;
                    }
                    break;
                }
            } else {
                newSignContentList.add("Unnamed area");
            }
            i = 0;
            class_8242 class_82422 = signBlockEntity.method_49853();
            for (String string : newSignContentList) {
                if (i > 3) break;
                class_8242 class_82423 = var15_16.method_49857(i, (class_2561)class_2561.method_43470((String)string));
                ++i;
            }
            signBlockEntity.method_49840((class_8242)var15_16, true);
            shouldUpdateSign = true;
        }
        if (!shouldUpdateSign && (radius == 0 || setradius)) {
            i = 0;
            for (String string : signLines) {
                void var15_21;
                if (i == 0) {
                    String string2 = "[" + zonePrefix + "] " + radius;
                } else if (i > 3) break;
                signBlockEntity.method_49853().method_49857(i, (class_2561)class_2561.method_43470((String)var15_21));
                ++i;
            }
            shouldUpdateSign = true;
        }
        if (shouldUpdateSign) {
            TileEntityFunctions.updateTileEntity((class_1937)level, (class_2338)signPos, (class_2586)signBlockEntity);
        }
    }

    public static void enterArea(AreaObject areaObject, class_1657 player) {
        if (Util.playerIsEditingASign()) {
            return;
        }
        AreaObject currentAreaObject = Util.getAreaSign(areaObject.level, areaObject.location);
        if (currentAreaObject.signLines != areaObject.signLines) {
            AreaVariables.enteredAreas.remove(areaObject);
            AreaVariables.areaObjects.get(areaObject.level).put(areaObject.location, currentAreaObject);
            areaObject = currentAreaObject;
        }
        boolean shouldMessage = Util.shouldMessagePlayer(areaObject, true);
        if (!AreaVariables.enteredAreas.contains(areaObject)) {
            AreaVariables.enteredAreas.add(areaObject);
        }
        if (shouldMessage) {
            String message = ConfigHandler.enterPrefix + areaObject.areaName + ConfigHandler.enterSuffix;
            Util.areaChangeMessage(player, message, areaObject.customRGB);
        }
    }

    public static void exitArea(AreaObject areaObject, class_1657 player) {
        AreaVariables.enteredAreas.remove(areaObject);
        boolean shouldMessage = Util.shouldMessagePlayer(areaObject, false);
        if (shouldMessage) {
            String message = ConfigHandler.leavePrefix + areaObject.areaName + ConfigHandler.leaveSuffix;
            Util.areaChangeMessage(player, message, areaObject.customRGB);
        }
    }

    public static void removedArea(AreaObject areaObject, class_1657 player) {
        AreaVariables.areaObjects.get(areaObject.level).remove(areaObject.location);
        AreaVariables.enteredAreas.remove(areaObject);
        boolean shouldMessage = Util.shouldMessagePlayer(areaObject, false);
        if (shouldMessage) {
            String message = "The area " + areaObject.areaName + " no longer exists.";
            class_2338 pPos = player.method_24515();
            class_2382 class_23822 = new class_2382(pPos.method_10263(), pPos.method_10264(), pPos.method_10260());
            if (areaObject.location.method_10262(class_23822) > (double)(areaObject.radius * 2)) {
                message = ConfigHandler.leavePrefix + areaObject.areaName + ConfigHandler.leaveSuffix;
            }
            Util.areaChangeMessage(player, message, areaObject.customRGB);
        }
    }

    public static boolean playerIsEditingASign() {
        class_437 screen = ClientConstants.mc.field_1755;
        return screen instanceof class_498 || screen instanceof class_7744;
    }

    public static boolean shouldMessagePlayer(AreaObject areaObject, boolean isEntering) {
        if (areaObject.areaName.equals("")) {
            return false;
        }
        for (AreaObject enteredAreaObject : AreaVariables.enteredAreas) {
            if (enteredAreaObject.equals(areaObject) || !areaObject.signLines.equals(enteredAreaObject.signLines)) continue;
            return false;
        }
        if (isEntering) {
            return ConfigHandler.showEnterMessage;
        }
        return ConfigHandler.showLeaveMessage;
    }

    public static void areaChangeMessage(class_1657 player, String message, String rgb) {
        if (ConfigHandler.sendChatMessages) {
            MessageFunctions.sendMessage((class_1657)player, (String)message, (class_124)class_124.field_1077);
        }
        if (ConfigHandler.showHUDMessages) {
            GUIVariables.ticksLeftBeforeFade = ConfigHandler.HUDMessageFadeDelayMs / 50;
            GUIVariables.hudMessage = message;
            GUIVariables.rgb = rgb;
            GUIVariables.guiOpacity = 255;
        }
    }

    public static Boolean isSignBlock(class_2248 block) {
        return block instanceof class_2478;
    }

    public static Boolean isSignItem(class_1792 item) {
        return Util.isSignBlock(class_2248.method_9503((class_1792)item));
    }

    private static String getRandomAreaName() {
        return (String)GlobalVariables.areaNames.get(GlobalVariables.random.nextInt(GlobalVariables.areaNames.size()));
    }
}

