/*
 * Decompiled with CFR 0.152.
 */
package com.tradespire;

import com.tradespire.TradeSpire;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class DatabaseManager {
    private final TradeSpire plugin;
    private Connection connection;
    private final Map<UUID, Boolean> tradeToggleCache = new ConcurrentHashMap<UUID, Boolean>();

    public DatabaseManager(TradeSpire plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        try {
            File dataFolder = this.plugin.getDataFolder();
            if (!dataFolder.exists()) {
                dataFolder.mkdirs();
            }
            File databaseFile = new File(dataFolder, "tradespire.db");
            String url = "jdbc:sqlite:" + databaseFile.getAbsolutePath();
            this.connection = DriverManager.getConnection(url);
            this.createTables();
            this.loadTradeToggles();
            this.plugin.getLogger().info("Database initialized successfully!");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to initialize database: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createTables() throws SQLException {
        String createTradeToggleTable = "CREATE TABLE IF NOT EXISTS trade_toggles (\n    uuid TEXT PRIMARY KEY,\n    enabled BOOLEAN NOT NULL DEFAULT 1\n)\n";
        try (PreparedStatement stmt = this.connection.prepareStatement(createTradeToggleTable);){
            stmt.execute();
        }
    }

    private void loadTradeToggles() {
        try {
            String query = "SELECT uuid, enabled FROM trade_toggles";
            try (PreparedStatement stmt = this.connection.prepareStatement(query);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    UUID uuid = UUID.fromString(rs.getString("uuid"));
                    boolean enabled = rs.getBoolean("enabled");
                    this.tradeToggleCache.put(uuid, enabled);
                }
            }
            this.plugin.getLogger().info("Loaded " + this.tradeToggleCache.size() + " trade toggle settings from database.");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to load trade toggles: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTradeToggleEnabled(UUID playerUuid) {
        if (this.tradeToggleCache.containsKey(playerUuid)) {
            return this.tradeToggleCache.get(playerUuid);
        }
        boolean defaultEnabled = this.plugin.getConfig().getBoolean("toggle.default-enabled", true);
        try {
            String query = "SELECT enabled FROM trade_toggles WHERE uuid = ?";
            try (PreparedStatement stmt = this.connection.prepareStatement(query);){
                stmt.setString(1, playerUuid.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        boolean enabled = rs.getBoolean("enabled");
                        this.tradeToggleCache.put(playerUuid, enabled);
                        boolean bl = enabled;
                        return bl;
                    }
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load trade toggle for " + String.valueOf(playerUuid) + ": " + e.getMessage());
        }
        this.tradeToggleCache.put(playerUuid, defaultEnabled);
        return defaultEnabled;
    }

    public CompletableFuture<Void> setTradeToggle(UUID playerUuid, boolean enabled) {
        return CompletableFuture.runAsync(() -> {
            try {
                String query = "INSERT INTO trade_toggles (uuid, enabled)\nVALUES (?, ?)\nON CONFLICT(uuid) DO UPDATE SET enabled = ?\n";
                try (PreparedStatement stmt = this.connection.prepareStatement(query);){
                    stmt.setString(1, playerUuid.toString());
                    stmt.setBoolean(2, enabled);
                    stmt.setBoolean(3, enabled);
                    stmt.executeUpdate();
                }
                this.tradeToggleCache.put(playerUuid, enabled);
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Failed to update trade toggle for " + String.valueOf(playerUuid) + ": " + e.getMessage());
            }
        });
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                this.plugin.getLogger().info("Database connection closed.");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error closing database connection: " + e.getMessage());
        }
    }

    public Map<UUID, Boolean> getCachedToggles() {
        return new HashMap<UUID, Boolean>(this.tradeToggleCache);
    }

    public void preloadPlayerToggle(UUID playerUuid) {
        if (!this.tradeToggleCache.containsKey(playerUuid)) {
            this.isTradeToggleEnabled(playerUuid);
        }
    }

    public void clearPlayerCache(UUID playerUuid) {
        this.tradeToggleCache.remove(playerUuid);
    }
}

