/*
 * Decompiled with CFR 0.152.
 */
package com.tradespire;

import com.tradespire.DatabaseManager;
import com.tradespire.MessageManager;
import com.tradespire.TradeCommand;
import com.tradespire.TradeSpirePlaceholders;
import com.tradespire.libs.kyori.adventure.text.Component;
import com.tradespire.libs.kyori.adventure.text.minimessage.MiniMessage;
import com.tradespire.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import com.tradespire.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.tradespire.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TradeSpire
extends JavaPlugin
implements Listener {
    private Object econ = null;
    private boolean vaultAvailable = false;
    private FileConfiguration config;
    private String guiTitle;
    private int inventorySize;
    private List<Integer> leftSlots;
    private List<Integer> rightSlots;
    private List<Integer> selfWaitingSlots;
    private List<Integer> selfConfirmSlots;
    private List<Integer> otherWaitingSlots;
    private List<Integer> otherConfirmSlots;
    private List<Integer> addMoneySlots;
    private List<Integer> infoSlots;
    private List<Integer> dividerSlots;
    private Material acceptMaterial;
    private Material declineMaterial;
    private Material dividerMaterial;
    private Material addMoneyMaterial;
    private String acceptName;
    private String declineName;
    private String dividerName;
    private String addMoneyName;
    private DatabaseManager databaseManager;
    private MessageManager messageManager;
    private List<String> addMoneyLore;
    private boolean playerGetsLeftSide;
    private double tradeMinDistance;
    private HashMap<UUID, TradeRequest> tradeRequests = new HashMap();
    private HashMap<UUID, ActiveTrade> activeTrades = new HashMap();
    private HashMap<UUID, Boolean> awaitingCustomAmount = new HashMap();

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.messageManager = new MessageManager(this);
        this.databaseManager = new DatabaseManager(this);
        this.databaseManager.initialize();
        boolean economyEnabled = this.config.getBoolean("economy.enabled", true);
        if (economyEnabled) {
            if (!this.setupEconomy()) {
                this.getLogger().info("Vault not found or economy not available. Money features will be disabled.");
                this.econ = null;
                this.vaultAvailable = false;
            } else {
                this.getLogger().info("Vault economy integration enabled!");
                this.vaultAvailable = true;
            }
        } else {
            this.getLogger().info("Economy integration disabled in configuration.");
            this.econ = null;
            this.vaultAvailable = false;
        }
        this.loadConfig();
        this.getCommand("trade").setExecutor((CommandExecutor)new TradeCommand(this));
        this.getCommand("trade").setTabCompleter((TabCompleter)new TradeCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new TradeSpirePlaceholders(this).register();
            this.getLogger().info("PlaceholderAPI expansion registered!");
        }
        this.getLogger().info("TradeSpire has been enabled!");
    }

    public void onDisable() {
        for (ActiveTrade trade : this.activeTrades.values()) {
            trade.cancelTrade("Plugin is shutting down");
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("TradeSpire has been disabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        try {
            Class<?> economyClass = Class.forName("net.milkbowl.vault.economy.Economy");
            RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(economyClass);
            if (rsp == null) {
                return false;
            }
            Method getProvider = rsp.getClass().getMethod("getProvider", new Class[0]);
            this.econ = getProvider.invoke((Object)rsp, new Object[0]);
            return this.econ != null;
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to setup Vault economy: " + e.getMessage());
            return false;
        }
    }

    private void loadConfig() {
        this.guiTitle = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("gui.title", "&8TradeSpire"));
        this.inventorySize = this.config.getInt("gui.size", 54);
        this.leftSlots = this.config.getIntegerList("gui.left-slots");
        this.rightSlots = this.config.getIntegerList("gui.right-slots");
        this.selfWaitingSlots = this.getSlotList("gui.items.self-waiting-trade.slot");
        this.selfConfirmSlots = this.getSlotList("gui.items.self-confirm-trade.slot");
        this.otherWaitingSlots = this.getSlotList("gui.items.other-waiting-trade.slot");
        this.otherConfirmSlots = this.getSlotList("gui.items.other-confirm-trade.slot");
        this.addMoneySlots = this.getSlotList("gui.items.add-money.slot");
        this.infoSlots = this.getSlotList("gui.items.info.slot");
        this.dividerSlots = this.getSlotList("gui.items.divider.slot");
        this.playerGetsLeftSide = this.config.getBoolean("gui.player-gets-left-side", true);
        this.tradeMinDistance = this.config.getDouble("trade-min-distance", 0.0);
        this.acceptMaterial = Material.valueOf((String)this.config.getString("gui.items.self-waiting-trade.material", "EMERALD_BLOCK"));
        this.declineMaterial = Material.valueOf((String)this.config.getString("gui.items.other-waiting-trade.material", "REDSTONE_BLOCK"));
        this.dividerMaterial = Material.valueOf((String)this.config.getString("gui.items.divider.material", "BLACK_STAINED_GLASS_PANE"));
        this.addMoneyMaterial = Material.valueOf((String)this.config.getString("gui.items.add-money.material", "GOLD_INGOT"));
        this.acceptName = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("gui.items.self-waiting-trade.name", "&aAccept Trade"));
        this.declineName = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("gui.items.other-waiting-trade.name", "&cWaiting for player"));
        this.dividerName = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("gui.items.divider.name", " "));
        this.addMoneyName = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("gui.items.add-money.name", "&6Add Money"));
        this.addMoneyLore = new ArrayList<String>();
        for (String line : this.config.getStringList("gui.items.add-money.lore")) {
            this.addMoneyLore.add(org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
    }

    private List<Integer> getSlotList(String path) {
        if (this.config.isList(path)) {
            return this.config.getIntegerList(path);
        }
        if (this.config.isInt(path)) {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            slots.add(this.config.getInt(path));
            return slots;
        }
        return new ArrayList<Integer>();
    }

    public String formatMoney(double amount) {
        if (!this.isEconomyEnabled()) {
            return "0";
        }
        try {
            Method format = this.econ.getClass().getMethod("format", Double.TYPE);
            return (String)format.invoke(this.econ, amount);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to format money: " + e.getMessage());
            return String.valueOf(amount);
        }
    }

    public boolean isEconomyEnabled() {
        return this.config.getBoolean("economy.enabled", true) && this.econ != null;
    }

    public void reloadPluginConfig() {
        if (!this.activeTrades.isEmpty()) {
            this.getLogger().info("Cancelling " + this.activeTrades.size() + " active trades due to configuration reload...");
            for (ActiveTrade trade : new ArrayList<ActiveTrade>(this.activeTrades.values())) {
                trade.cancelTrade("Configuration is being reloaded");
            }
        }
        this.tradeRequests.clear();
        this.awaitingCustomAmount.clear();
        this.reloadConfig();
        this.config = this.getConfig();
        this.messageManager.reloadMessages();
        this.loadConfig();
        this.getLogger().info("Configuration reloaded successfully!");
    }

    public double getPlayerBalance(Player player) {
        if (!this.isEconomyEnabled()) {
            return 0.0;
        }
        try {
            Method getBalance = this.econ.getClass().getMethod("getBalance", OfflinePlayer.class);
            return (Double)getBalance.invoke(this.econ, player);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to get balance: " + e.getMessage());
            return 0.0;
        }
    }

    private void endTrade(ActiveTrade trade, String reason) {
        Player p1 = Bukkit.getPlayer((UUID)trade.getPlayerOne());
        Player p2 = Bukkit.getPlayer((UUID)trade.getPlayerTwo());
        if (p1 != null) {
            this.returnItemsToPlayer(p1, trade.getPlayerOneInventory());
            if (this.isEconomyEnabled() && trade.getPlayerOneMoney() > 0.0 && !this.messageManager.getRawMessage("money-not-withdrawn").isEmpty()) {
                this.messageManager.sendMessage(p1, "money-not-withdrawn", Placeholder.unparsed("amount", this.format(trade.getPlayerOneMoney())));
            }
            if (p1.isOnline()) {
                p1.closeInventory();
            }
        }
        if (p2 != null) {
            this.returnItemsToPlayer(p2, trade.getPlayerTwoInventory());
            if (this.isEconomyEnabled() && trade.getPlayerTwoMoney() > 0.0 && !this.messageManager.getRawMessage("money-not-withdrawn").isEmpty()) {
                this.messageManager.sendMessage(p2, "money-not-withdrawn", Placeholder.unparsed("amount", this.format(trade.getPlayerTwoMoney())));
            }
            if (p2.isOnline()) {
                p2.closeInventory();
            }
        }
        if (p1 != null && p1.isOnline()) {
            if (!this.messageManager.getRawMessage("trade-ended").isEmpty()) {
                this.messageManager.sendMessage(p1, "trade-ended", Placeholder.unparsed("reason", reason));
            }
            this.awaitingCustomAmount.remove(p1.getUniqueId());
        }
        if (p2 != null && p2.isOnline()) {
            if (!this.messageManager.getRawMessage("trade-ended").isEmpty()) {
                this.messageManager.sendMessage(p2, "trade-ended", Placeholder.unparsed("reason", reason));
            }
            this.awaitingCustomAmount.remove(p2.getUniqueId());
        }
        this.activeTrades.remove(trade.getPlayerOne());
        this.activeTrades.remove(trade.getPlayerTwo());
    }

    public void sendTradeRequest(final Player sender, final Player target) {
        double distance;
        if (!this.databaseManager.isTradeToggleEnabled(target.getUniqueId())) {
            this.messageManager.sendMessage(sender, "trade-requests-disabled", Placeholder.unparsed("player", target.getName()));
            return;
        }
        if (this.activeTrades.containsKey(sender.getUniqueId())) {
            this.messageManager.sendMessage(sender, "already-in-trade", new TagResolver[0]);
            return;
        }
        if (this.activeTrades.containsKey(target.getUniqueId())) {
            this.messageManager.sendMessage(sender, "target-in-trade", Placeholder.unparsed("player", target.getName()));
            return;
        }
        if (this.tradeMinDistance > 0.0 && (distance = sender.getLocation().distance(target.getLocation())) > this.tradeMinDistance) {
            this.messageManager.sendMessage(sender, "trade-distance-too-far", Placeholder.unparsed("player", target.getName()), Placeholder.unparsed("distance", String.format("%.1f", distance)), Placeholder.unparsed("required", String.format("%.1f", this.tradeMinDistance)));
            return;
        }
        if (this.tradeRequests.containsKey(target.getUniqueId()) && this.tradeRequests.get(target.getUniqueId()).getSender().equals(sender.getUniqueId())) {
            this.messageManager.sendMessage(sender, "trade-request-already-sent", Placeholder.unparsed("player", target.getName()));
            return;
        }
        final TradeRequest request = new TradeRequest(this, sender.getUniqueId(), target.getUniqueId());
        this.tradeRequests.put(target.getUniqueId(), request);
        this.messageManager.sendMessage(sender, "trade-request-sent", Placeholder.unparsed("player", target.getName()));
        this.sendClickableTradeRequest(target, sender);
        new BukkitRunnable(this){
            final /* synthetic */ TradeSpire this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.this$0.tradeRequests.containsKey(target.getUniqueId()) && this.this$0.tradeRequests.get(target.getUniqueId()).equals(request)) {
                    this.this$0.tradeRequests.remove(target.getUniqueId());
                    Player senderPlayer = Bukkit.getPlayer((UUID)sender.getUniqueId());
                    Player targetPlayer = Bukkit.getPlayer((UUID)target.getUniqueId());
                    if (senderPlayer != null) {
                        this.this$0.messageManager.sendMessage(senderPlayer, "trade-request-expired-sender", Placeholder.unparsed("player", target.getName()));
                    }
                    if (targetPlayer != null) {
                        this.this$0.messageManager.sendMessage(targetPlayer, "trade-request-expired-target", Placeholder.unparsed("player", sender.getName()));
                    }
                }
            }
        }.runTaskLater((Plugin)this, 1200L);
    }

    private boolean sendTellrawMessage(Player target, String message) {
        try {
            String tellrawCommand = String.format("tellraw %s {\"text\":\"\",\"extra\":[{\"text\":\"Click \",\"color\":\"green\"},{\"text\":\"[ACCEPT]\",\"color\":\"green\",\"bold\":true,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trade accept\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"Click to accept the trade request\"}},{\"text\":\" or \",\"color\":\"green\"},{\"text\":\"[DENY]\",\"color\":\"red\",\"bold\":true,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trade deny\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"Click to deny the trade request\"}},{\"text\":\" to respond.\",\"color\":\"green\"}]}", target.getName());
            return this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), tellrawCommand);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean tryPaperAPI(Player target, String message) {
        try {
            Class.forName("io.papermc.paper.event.player.PlayerItemFrameChangeEvent");
            Object component = MiniMessage.miniMessage().deserialize(message);
            Method sendMessage = target.getClass().getMethod("sendMessage", Component.class);
            sendMessage.invoke((Object)target, component);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean trySpigotComponents(Player target) {
        try {
            Class<?> textComponentClass = Class.forName("net.md_5.bungee.api.chat.TextComponent");
            Class<?> clickEventClass = Class.forName("net.md_5.bungee.api.chat.ClickEvent");
            Class<?> hoverEventClass = Class.forName("net.md_5.bungee.api.chat.HoverEvent");
            Class<?> chatColorClass = Class.forName("net.md_5.bungee.api.ChatColor");
            Object mainMessage = textComponentClass.getConstructor(String.class).newInstance("Click ");
            mainMessage.getClass().getMethod("setColor", chatColorClass).invoke(mainMessage, chatColorClass.getField("GREEN").get(null));
            Object acceptButton = textComponentClass.getConstructor(String.class).newInstance("[ACCEPT]");
            acceptButton.getClass().getMethod("setColor", chatColorClass).invoke(acceptButton, chatColorClass.getField("GREEN").get(null));
            acceptButton.getClass().getMethod("setBold", Boolean.TYPE).invoke(acceptButton, true);
            Object acceptClickEvent = clickEventClass.getConstructor(clickEventClass.getDeclaredClasses()[0], String.class).newInstance(clickEventClass.getDeclaredClasses()[0].getEnumConstants()[0], "/trade accept");
            acceptButton.getClass().getMethod("setClickEvent", clickEventClass).invoke(acceptButton, acceptClickEvent);
            Object orText = textComponentClass.getConstructor(String.class).newInstance(" or ");
            orText.getClass().getMethod("setColor", chatColorClass).invoke(orText, chatColorClass.getField("GREEN").get(null));
            Object denyButton = textComponentClass.getConstructor(String.class).newInstance("[DENY]");
            denyButton.getClass().getMethod("setColor", chatColorClass).invoke(denyButton, chatColorClass.getField("RED").get(null));
            denyButton.getClass().getMethod("setBold", Boolean.TYPE).invoke(denyButton, true);
            Object denyClickEvent = clickEventClass.getConstructor(clickEventClass.getDeclaredClasses()[0], String.class).newInstance(clickEventClass.getDeclaredClasses()[0].getEnumConstants()[0], "/trade deny");
            denyButton.getClass().getMethod("setClickEvent", clickEventClass).invoke(denyButton, denyClickEvent);
            Object endText = textComponentClass.getConstructor(String.class).newInstance(" to respond.");
            endText.getClass().getMethod("setColor", chatColorClass).invoke(endText, chatColorClass.getField("GREEN").get(null));
            Class<?> baseComponentClass = Class.forName("net.md_5.bungee.api.chat.BaseComponent");
            mainMessage.getClass().getMethod("addExtra", baseComponentClass).invoke(mainMessage, acceptButton);
            mainMessage.getClass().getMethod("addExtra", baseComponentClass).invoke(mainMessage, orText);
            mainMessage.getClass().getMethod("addExtra", baseComponentClass).invoke(mainMessage, denyButton);
            mainMessage.getClass().getMethod("addExtra", baseComponentClass).invoke(mainMessage, endText);
            Object spigotPlayer = target.getClass().getMethod("spigot", new Class[0]).invoke((Object)target, new Object[0]);
            spigotPlayer.getClass().getMethod("sendMessage", baseComponentClass).invoke(spigotPlayer, mainMessage);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void sendClickableTradeRequest(Player target, Player sender) {
        this.messageManager.sendMessage(target, "trade-request-received", sender, new TagResolver[0]);
        try {
            TextComponent message = new TextComponent("Click ");
            message.setColor(ChatColor.GREEN);
            TextComponent acceptButton = new TextComponent("[ACCEPT]");
            acceptButton.setColor(ChatColor.GREEN);
            acceptButton.setBold(Boolean.valueOf(true));
            acceptButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/trade accept"));
            TextComponent orText = new TextComponent(" or ");
            orText.setColor(ChatColor.GREEN);
            TextComponent denyButton = new TextComponent("[DENY]");
            denyButton.setColor(ChatColor.RED);
            denyButton.setBold(Boolean.valueOf(true));
            denyButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/trade deny"));
            TextComponent endText = new TextComponent(" to respond.");
            endText.setColor(ChatColor.GREEN);
            message.addExtra((BaseComponent)acceptButton);
            message.addExtra((BaseComponent)orText);
            message.addExtra((BaseComponent)denyButton);
            message.addExtra((BaseComponent)endText);
            target.spigot().sendMessage((BaseComponent)message);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to send clickable message: " + e.getMessage());
            target.sendMessage(String.valueOf(org.bukkit.ChatColor.GREEN) + "Type " + String.valueOf(org.bukkit.ChatColor.YELLOW) + "/trade accept" + String.valueOf(org.bukkit.ChatColor.GREEN) + " or " + String.valueOf(org.bukkit.ChatColor.YELLOW) + "/trade deny" + String.valueOf(org.bukkit.ChatColor.GREEN) + " to respond.");
        }
    }

    private void sendLegacyClickableMessage(Player target, Player sender) {
        try {
            String tellrawCommand = String.format("/tellraw %s {\"text\":\"\",\"extra\":[{\"text\":\"Click \",\"color\":\"green\"},{\"text\":\"[ACCEPT]\",\"color\":\"green\",\"bold\":true,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trade accept\"},\"hoverEvent\":{\"action\":\"show_text\",\"contents\":\"Click to accept\"}},{\"text\":\" or \",\"color\":\"green\"},{\"text\":\"[DENY]\",\"color\":\"red\",\"bold\":true,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/trade deny\"},\"hoverEvent\":{\"action\":\"show_text\",\"contents\":\"Click to deny\"}},{\"text\":\" to respond.\",\"color\":\"green\"}]}", target.getName());
            this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), tellrawCommand);
        }
        catch (Exception e) {
            this.messageManager.sendMessage(target, "trade-request-accept-info", new TagResolver[0]);
        }
    }

    public void acceptTradeRequest(Player acceptor) {
        double distance;
        if (!this.tradeRequests.containsKey(acceptor.getUniqueId())) {
            this.messageManager.sendMessage(acceptor, "no-pending-requests", new TagResolver[0]);
            return;
        }
        TradeRequest request = this.tradeRequests.get(acceptor.getUniqueId());
        Player sender = Bukkit.getPlayer((UUID)request.getSender());
        if (sender == null || !sender.isOnline()) {
            this.messageManager.sendMessage(acceptor, "request-sender-offline", new TagResolver[0]);
            this.tradeRequests.remove(acceptor.getUniqueId());
            return;
        }
        if (this.activeTrades.containsKey(sender.getUniqueId()) || this.activeTrades.containsKey(acceptor.getUniqueId())) {
            this.messageManager.sendMessage(acceptor, "cannot-start-trade", new TagResolver[0]);
            this.tradeRequests.remove(acceptor.getUniqueId());
            return;
        }
        if (this.tradeMinDistance > 0.0 && (distance = sender.getLocation().distance(acceptor.getLocation())) > this.tradeMinDistance) {
            this.messageManager.sendMessage(acceptor, "trade-distance-too-far", Placeholder.unparsed("player", sender.getName()), Placeholder.unparsed("distance", String.format("%.1f", distance)), Placeholder.unparsed("required", String.format("%.1f", this.tradeMinDistance)));
            this.tradeRequests.remove(acceptor.getUniqueId());
            return;
        }
        this.tradeRequests.remove(acceptor.getUniqueId());
        this.messageManager.sendMessage(acceptor, "trade-request-accepted", Placeholder.unparsed("player", sender.getName()));
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.startTrade(sender, acceptor), 1L);
    }

    public void denyTradeRequest(Player denier) {
        if (!this.tradeRequests.containsKey(denier.getUniqueId())) {
            this.messageManager.sendMessage(denier, "no-pending-requests", new TagResolver[0]);
            return;
        }
        TradeRequest request = this.tradeRequests.get(denier.getUniqueId());
        Player sender = Bukkit.getPlayer((UUID)request.getSender());
        if (sender != null && sender.isOnline()) {
            this.messageManager.sendMessage(sender, "trade-request-denied-to-sender", Placeholder.unparsed("player", denier.getName()));
        }
        this.messageManager.sendMessage(denier, "trade-request-denied", Placeholder.unparsed("player", sender != null ? sender.getName() : "Unknown"));
        this.tradeRequests.remove(denier.getUniqueId());
    }

    private void startTrade(Player playerOne, Player playerTwo) {
        ActiveTrade trade = new ActiveTrade(playerOne.getUniqueId(), playerTwo.getUniqueId());
        this.activeTrades.put(playerOne.getUniqueId(), trade);
        this.activeTrades.put(playerTwo.getUniqueId(), trade);
        Inventory playerOneInventory = this.createTradeInventory(playerOne, playerTwo, true);
        Inventory playerTwoInventory = this.createTradeInventory(playerTwo, playerOne, false);
        trade.setPlayerOneInventory(playerOneInventory);
        trade.setPlayerTwoInventory(playerTwoInventory);
        playerOne.openInventory(playerOneInventory);
        playerTwo.openInventory(playerTwoInventory);
        this.messageManager.sendMessage(playerOne, "trade-started", Placeholder.unparsed("player", playerTwo.getName()));
        this.messageManager.sendMessage(playerTwo, "trade-started", Placeholder.unparsed("player", playerOne.getName()));
    }

    private ItemStack createGuiItem(String configPath, Player viewer, Player otherPlayer) {
        String itemModel;
        int customModelData;
        boolean enchanted;
        List lore;
        ItemStack item;
        String materialStr = this.config.getString(configPath + ".material", "STONE");
        if (materialStr.startsWith("PLAYER_HEAD-")) {
            String headType = materialStr.substring(12);
            item = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta skullMeta = (SkullMeta)item.getItemMeta();
            if (headType.equals("%player%")) {
                skullMeta.setOwningPlayer((OfflinePlayer)viewer);
            } else if (headType.equals("%other-player%")) {
                skullMeta.setOwningPlayer((OfflinePlayer)otherPlayer);
            }
            item.setItemMeta((ItemMeta)skullMeta);
        } else {
            Material material = Material.valueOf((String)materialStr);
            item = new ItemStack(material);
        }
        ItemMeta meta = item.getItemMeta();
        String name = this.config.getString(configPath + ".name", "");
        if (!name.isEmpty()) {
            name = this.replacePlaceholders(name, viewer, otherPlayer);
            meta.setDisplayName(org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        if (!(lore = this.config.getStringList(configPath + ".lore")).isEmpty()) {
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : lore) {
                line = this.replacePlaceholders(line, viewer, otherPlayer);
                coloredLore.add(org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            meta.setLore(coloredLore);
        }
        if (enchanted = this.config.getBoolean(configPath + ".enchanted", false)) {
            meta.addEnchant(Enchantment.UNBREAKING, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if ((customModelData = this.config.getInt(configPath + ".custom-model-data", 0)) > 0) {
            try {
                meta.setCustomModelData(Integer.valueOf(customModelData));
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to set custom model data: " + e.getMessage());
            }
        }
        if (!(itemModel = this.config.getString(configPath + ".item-model", "")).isEmpty() && !itemModel.equals("minecraft:air")) {
            try {
                String[] parts = itemModel.split(":");
                if (parts.length == 2) {
                    NamespacedKey key = new NamespacedKey(parts[0], parts[1]);
                    if (meta instanceof ItemMeta) {
                        try {
                            Method method = meta.getClass().getMethod("setItemModel", NamespacedKey.class);
                            method.invoke((Object)meta, key);
                        }
                        catch (NoSuchMethodException e) {
                            this.getLogger().warning("ItemModel API not available in this version (requires 1.21+)");
                        }
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to set item model: " + e.getMessage());
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    private String replacePlaceholders(String text, Player viewer, Player otherPlayer) {
        return this.messageManager.replacePlaceholders(text, viewer, otherPlayer);
    }

    private ItemStack createCustomItem(String itemName, Player viewer, Player otherPlayer) {
        String basePath = "gui.custom-items." + itemName;
        return this.createGuiItem(basePath, viewer, otherPlayer);
    }

    private boolean isItemEnabled(String itemPath) {
        return this.config.getBoolean(itemPath + ".enabled", true);
    }

    private Inventory createTradeInventory(Player viewer, Player otherPlayer, boolean isPlayerOne) {
        String title;
        String titleTemplate = this.messageManager.getRawMessage("gui-title");
        if (titleTemplate.isEmpty()) {
            titleTemplate = this.config.getString("gui.title", "&8TradeSpire");
        }
        if ((title = this.messageManager.replacePlaceholders(titleTemplate, viewer, otherPlayer)).contains("<") && title.contains(">")) {
            try {
                Object titleComponent = MiniMessage.miniMessage().deserialize(title);
                title = LegacyComponentSerializer.legacySection().serialize((Component)titleComponent);
            }
            catch (Exception e) {
                title = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)title);
            }
        } else {
            title = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        }
        Inventory inv = Bukkit.createInventory(null, (int)this.inventorySize, (String)title);
        if (this.isItemEnabled("gui.items.divider")) {
            ItemStack divider = this.createGuiItem("gui.items.divider", viewer, otherPlayer);
            if (this.dividerSlots.isEmpty()) {
                for (int i = 0; i < this.inventorySize; ++i) {
                    if (this.leftSlots.contains(i) || this.rightSlots.contains(i) || this.selfWaitingSlots.contains(i) || this.selfConfirmSlots.contains(i) || this.otherWaitingSlots.contains(i) || this.otherConfirmSlots.contains(i) || this.addMoneySlots.contains(i) || this.infoSlots.contains(i)) continue;
                    inv.setItem(i, divider);
                }
            } else {
                for (int slot : this.dividerSlots) {
                    if (slot < 0 || slot >= this.inventorySize) continue;
                    inv.setItem(slot, divider);
                }
            }
        }
        if (this.isItemEnabled("gui.items.self-waiting-trade")) {
            ItemStack selfWaitingButton = this.createGuiItem("gui.items.self-waiting-trade", viewer, otherPlayer);
            for (int slot : this.selfWaitingSlots) {
                if (slot < 0 || slot >= this.inventorySize) continue;
                inv.setItem(slot, selfWaitingButton);
            }
        }
        if (this.isItemEnabled("gui.items.other-waiting-trade")) {
            ItemStack otherWaitingButton = this.createGuiItem("gui.items.other-waiting-trade", viewer, otherPlayer);
            for (int slot : this.otherWaitingSlots) {
                if (slot < 0 || slot >= this.inventorySize) continue;
                inv.setItem(slot, otherWaitingButton);
            }
        }
        if (this.isEconomyEnabled() && this.isItemEnabled("gui.items.add-money")) {
            this.updateAddMoneyButton(inv, viewer, otherPlayer);
        }
        if (this.isItemEnabled("gui.items.info")) {
            this.updateTradeInfoItem(inv, viewer, otherPlayer);
        }
        for (String customItemName : this.config.getConfigurationSection("gui.custom-items").getKeys(false)) {
            if (!this.isItemEnabled("gui.custom-items." + customItemName)) continue;
            ItemStack customItem = this.createCustomItem(customItemName, viewer, otherPlayer);
            List<Integer> customSlots = this.getSlotList("gui.custom-items." + customItemName + ".slot");
            for (int slot : customSlots) {
                if (slot < 0 || slot >= this.inventorySize) continue;
                inv.setItem(slot, customItem);
            }
        }
        return inv;
    }

    private void updateTradeInfoItem(Inventory inv, Player viewer, Player otherPlayer) {
        ItemStack infoItem = this.createGuiItem("gui.items.info", viewer, otherPlayer);
        if (this.activeTrades.containsKey(viewer.getUniqueId())) {
            ActiveTrade trade = this.activeTrades.get(viewer.getUniqueId());
            ItemMeta infoMeta = infoItem.getItemMeta();
            List configLore = this.config.getStringList("gui.items.info.lore");
            if (configLore.isEmpty()) {
                ArrayList<Object> infoLore = new ArrayList<Object>();
                String playerSide = this.playerGetsLeftSide ? "Left" : "Right";
                String otherSide = this.playerGetsLeftSide ? "Right" : "Left";
                infoLore.add(String.valueOf(org.bukkit.ChatColor.WHITE) + "Your items: " + String.valueOf(org.bukkit.ChatColor.GOLD) + playerSide + " Side");
                infoLore.add(String.valueOf(org.bukkit.ChatColor.WHITE) + otherPlayer.getName() + "'s items: " + String.valueOf(org.bukkit.ChatColor.GOLD) + otherSide + " Side");
                infoLore.add(String.valueOf(org.bukkit.ChatColor.GRAY) + "Click the buttons to accept/decline");
                infoLore.add(String.valueOf(org.bukkit.ChatColor.GRAY) + "When both players accept, the trade will complete");
                boolean isPlayerOne = viewer.getUniqueId().equals(trade.getPlayerOne());
                boolean viewerAccepted = isPlayerOne ? trade.isPlayerOneAccepted() : trade.isPlayerTwoAccepted();
                boolean otherAccepted = isPlayerOne ? trade.isPlayerTwoAccepted() : trade.isPlayerOneAccepted();
                infoLore.add("");
                infoLore.add(String.valueOf(org.bukkit.ChatColor.WHITE) + "Your status: " + (viewerAccepted ? String.valueOf(org.bukkit.ChatColor.GREEN) + "Accepted" : String.valueOf(org.bukkit.ChatColor.RED) + "Not Accepted"));
                infoLore.add(String.valueOf(org.bukkit.ChatColor.WHITE) + otherPlayer.getName() + "'s status: " + (otherAccepted ? String.valueOf(org.bukkit.ChatColor.GREEN) + "Accepted" : String.valueOf(org.bukkit.ChatColor.RED) + "Not Accepted"));
                if (this.isEconomyEnabled()) {
                    infoLore.add("");
                    double viewerMoney = isPlayerOne ? trade.getPlayerOneMoney() : trade.getPlayerTwoMoney();
                    double otherMoney = isPlayerOne ? trade.getPlayerTwoMoney() : trade.getPlayerOneMoney();
                    infoLore.add(String.valueOf(org.bukkit.ChatColor.WHITE) + "Your offer: " + String.valueOf(org.bukkit.ChatColor.GOLD) + this.format(viewerMoney));
                    infoLore.add(String.valueOf(org.bukkit.ChatColor.WHITE) + otherPlayer.getName() + "'s offer: " + String.valueOf(org.bukkit.ChatColor.GOLD) + this.format(otherMoney));
                }
                infoMeta.setLore(infoLore);
                infoItem.setItemMeta(infoMeta);
            }
        }
        for (int slot : this.infoSlots) {
            if (slot < 0 || slot >= this.inventorySize) continue;
            inv.setItem(slot, infoItem);
        }
    }

    private double getBalance(OfflinePlayer player) {
        if (!this.isEconomyEnabled()) {
            return 0.0;
        }
        try {
            Method getBalance = this.econ.getClass().getMethod("getBalance", OfflinePlayer.class);
            return (Double)getBalance.invoke(this.econ, player);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to get balance: " + e.getMessage());
            return 0.0;
        }
    }

    private void updateAddMoneyButton(Inventory inv, Player player, Player otherPlayer) {
        ItemStack addMoneyItem = this.createGuiItem("gui.items.add-money", player, otherPlayer);
        ItemMeta meta = addMoneyItem.getItemMeta();
        List lore = meta.getLore();
        if (lore != null) {
            ArrayList<String> processedLore = new ArrayList<String>();
            for (String line : lore) {
                if (line.contains("%balance%")) {
                    line = line.replace("%balance%", this.format(this.getBalance((OfflinePlayer)player)));
                }
                processedLore.add(line);
            }
            meta.setLore(processedLore);
        }
        addMoneyItem.setItemMeta(meta);
        for (int slot : this.addMoneySlots) {
            if (slot < 0 || slot >= this.inventorySize) continue;
            inv.setItem(slot, addMoneyItem);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Inventory playerInventory;
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (!this.activeTrades.containsKey(player.getUniqueId())) {
            return;
        }
        ActiveTrade trade = this.activeTrades.get(player.getUniqueId());
        boolean isPlayerOne = player.getUniqueId().equals(trade.getPlayerOne());
        Inventory inventory = playerInventory = isPlayerOne ? trade.getPlayerOneInventory() : trade.getPlayerTwoInventory();
        if (!event.getInventory().equals((Object)playerInventory) || trade.isAddingMoney(player.getUniqueId())) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            if (this.activeTrades.containsKey(player.getUniqueId())) {
                this.endTrade(trade, player.getName() + " closed the trade window");
            }
        }, 1L);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory playerInventory;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.activeTrades.containsKey(player.getUniqueId())) {
            return;
        }
        ActiveTrade trade = this.activeTrades.get(player.getUniqueId());
        boolean isPlayerOne = player.getUniqueId().equals(trade.getPlayerOne());
        Inventory inventory = playerInventory = isPlayerOne ? trade.getPlayerOneInventory() : trade.getPlayerTwoInventory();
        if (event.getView().getTopInventory().equals((Object)playerInventory)) {
            int slot = event.getRawSlot();
            if (slot < playerInventory.getSize()) {
                List<Integer> playerSlots = this.playerGetsLeftSide ? this.leftSlots : this.rightSlots;
                if (this.selfWaitingSlots.contains(slot) || this.selfConfirmSlots.contains(slot)) {
                    event.setCancelled(true);
                    this.handleAcceptClick(player, trade);
                    return;
                }
                if (this.addMoneySlots.contains(slot) && this.isItemEnabled("gui.items.add-money") && this.isEconomyEnabled()) {
                    event.setCancelled(true);
                    this.updateAddMoneyButton(playerInventory, player, this.getOtherPlayer(player, trade));
                    this.openAddMoneyMenu(player);
                    return;
                }
                for (String customItemName : this.config.getConfigurationSection("gui.custom-items").getKeys(false)) {
                    List<Integer> customSlots = this.getSlotList("gui.custom-items." + customItemName + ".slot");
                    if (!customSlots.contains(slot)) continue;
                    event.setCancelled(true);
                    return;
                }
                if (!playerSlots.contains(slot)) {
                    event.setCancelled(true);
                    return;
                }
                trade.resetAcceptance();
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    this.syncInventories(trade);
                    this.updateTradeInfo(trade);
                });
                return;
            }
            if (event.isShiftClick() && event.getCurrentItem() != null) {
                event.setCancelled(true);
                ItemStack clickedItem = event.getCurrentItem().clone();
                List<Integer> playerSlots = this.playerGetsLeftSide ? this.leftSlots : this.rightSlots;
                for (int allowedSlot : playerSlots) {
                    ItemStack item = playerInventory.getItem(allowedSlot);
                    if (item != null && item.getType() != Material.AIR) continue;
                    playerInventory.setItem(allowedSlot, clickedItem);
                    event.setCurrentItem(null);
                    trade.resetAcceptance();
                    Bukkit.getScheduler().runTask((Plugin)this, () -> {
                        this.syncInventories(trade);
                        this.updateTradeInfo(trade);
                    });
                    return;
                }
                this.messageManager.sendMessage(player, "no-space-trade-slots", new TagResolver[0]);
                return;
            }
            return;
        }
    }

    private Player getOtherPlayer(Player player, ActiveTrade trade) {
        UUID otherUuid = player.getUniqueId().equals(trade.getPlayerOne()) ? trade.getPlayerTwo() : trade.getPlayerOne();
        return Bukkit.getPlayer((UUID)otherUuid);
    }

    private void forceInventoryUpdate(Player player) {
        player.updateInventory();
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Inventory playerInventory;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.activeTrades.containsKey(player.getUniqueId())) {
            return;
        }
        ActiveTrade trade = this.activeTrades.get(player.getUniqueId());
        boolean isPlayerOne = player.getUniqueId().equals(trade.getPlayerOne());
        Inventory inventory = playerInventory = isPlayerOne ? trade.getPlayerOneInventory() : trade.getPlayerTwoInventory();
        if (event.getInventory().equals((Object)playerInventory)) {
            List<Integer> playerSlots = this.playerGetsLeftSide ? this.leftSlots : this.rightSlots;
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot < 0 || slot >= playerInventory.getSize() || playerSlots.contains(slot)) continue;
                event.setCancelled(true);
                return;
            }
            trade.resetAcceptance();
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                this.syncInventories(trade);
                this.updateTradeInfo(trade);
            });
        }
    }

    private void syncInventories(ActiveTrade trade) {
        ItemStack item;
        int i;
        Inventory inv1 = trade.getPlayerOneInventory();
        Inventory inv2 = trade.getPlayerTwoInventory();
        List<Integer> player1OwnSlots = this.playerGetsLeftSide ? this.leftSlots : this.rightSlots;
        List<Integer> player1ViewOnPlayer2 = this.playerGetsLeftSide ? this.rightSlots : this.leftSlots;
        List<Integer> player2OwnSlots = this.playerGetsLeftSide ? this.leftSlots : this.rightSlots;
        List<Integer> player2ViewOnPlayer1 = this.playerGetsLeftSide ? this.rightSlots : this.leftSlots;
        for (i = 0; i < player1OwnSlots.size() && i < player2ViewOnPlayer1.size(); ++i) {
            item = inv1.getItem(player1OwnSlots.get(i).intValue());
            inv2.setItem(player2ViewOnPlayer1.get(i).intValue(), item);
        }
        for (i = 0; i < player2OwnSlots.size() && i < player1ViewOnPlayer2.size(); ++i) {
            item = inv2.getItem(player2OwnSlots.get(i).intValue());
            inv1.setItem(player1ViewOnPlayer2.get(i).intValue(), item);
        }
    }

    @EventHandler
    public void onPlayerChat(PlayerChatEvent event) {
        double amount;
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (!this.awaitingCustomAmount.containsKey(playerId) || !this.awaitingCustomAmount.get(playerId).booleanValue()) {
            return;
        }
        event.setCancelled(true);
        this.awaitingCustomAmount.remove(playerId);
        if (!this.activeTrades.containsKey(playerId)) {
            this.messageManager.sendMessage(player, "no-longer-in-trade", new TagResolver[0]);
            return;
        }
        ActiveTrade trade = this.activeTrades.get(playerId);
        String message = event.getMessage().trim();
        if (message.equalsIgnoreCase("cancel")) {
            this.messageManager.sendMessage(player, "custom-amount-cancelled", new TagResolver[0]);
            boolean isPlayerOne = playerId.equals(trade.getPlayerOne());
            Inventory playerInventory = isPlayerOne ? trade.getPlayerOneInventory() : trade.getPlayerTwoInventory();
            player.openInventory(playerInventory);
            return;
        }
        try {
            amount = Double.parseDouble(message);
            if (amount < 0.0) {
                this.messageManager.sendMessage(player, "amount-negative", new TagResolver[0]);
                this.awaitingCustomAmount.put(playerId, true);
                return;
            }
            if (amount > this.getBalance((OfflinePlayer)player)) {
                this.messageManager.sendMessage(player, "insufficient-funds", Placeholder.unparsed("amount", this.format(this.getBalance((OfflinePlayer)player))));
                this.awaitingCustomAmount.put(playerId, true);
                return;
            }
            double maxAmount = this.config.getDouble("economy.max-amount", 1000000.0);
            if (amount > maxAmount) {
                this.messageManager.sendMessage(player, "amount-exceeds-max", Placeholder.unparsed("amount", this.format(maxAmount)));
                this.awaitingCustomAmount.put(playerId, true);
                return;
            }
        }
        catch (NumberFormatException e) {
            this.messageManager.sendMessage(player, "invalid-number", new TagResolver[0]);
            this.awaitingCustomAmount.put(playerId, true);
            return;
        }
        boolean isPlayerOne = playerId.equals(trade.getPlayerOne());
        if (isPlayerOne) {
            trade.setPlayerOneMoney(amount);
        } else {
            trade.setPlayerTwoMoney(amount);
        }
        this.messageManager.sendMessage(player, "money-amount-set", Placeholder.unparsed("amount", this.format(amount)));
        Inventory playerInventory = isPlayerOne ? trade.getPlayerOneInventory() : trade.getPlayerTwoInventory();
        player.openInventory(playerInventory);
        this.updateTradeInfo(trade);
        trade.resetAcceptance();
    }

    private void handleAcceptClick(Player player, ActiveTrade trade) {
        Player otherPlayer;
        boolean newState;
        boolean currentlyAccepted;
        boolean isPlayerOne = player.getUniqueId().equals(trade.getPlayerOne());
        boolean bl = currentlyAccepted = isPlayerOne ? trade.isPlayerOneAccepted() : trade.isPlayerTwoAccepted();
        if (isPlayerOne) {
            trade.setPlayerOneAccepted(!currentlyAccepted);
        } else {
            trade.setPlayerTwoAccepted(!currentlyAccepted);
        }
        boolean bl2 = newState = isPlayerOne ? trade.isPlayerOneAccepted() : trade.isPlayerTwoAccepted();
        if (newState) {
            this.messageManager.sendMessage(player, "trade-accepted", new TagResolver[0]);
        } else {
            this.messageManager.sendMessage(player, "trade-declined", new TagResolver[0]);
        }
        Player player2 = otherPlayer = isPlayerOne ? Bukkit.getPlayer((UUID)trade.getPlayerTwo()) : Bukkit.getPlayer((UUID)trade.getPlayerOne());
        if (otherPlayer != null) {
            if (newState) {
                this.messageManager.sendMessage(otherPlayer, "other-accepted", Placeholder.unparsed("player", player.getName()));
            } else {
                this.messageManager.sendMessage(otherPlayer, "other-declined", Placeholder.unparsed("player", player.getName()));
            }
        }
        this.updateAcceptButtons(trade);
        this.updateInventoryTitles(trade);
        if (trade.isPlayerOneAccepted() && trade.isPlayerTwoAccepted()) {
            this.completeTrade(trade);
        }
    }

    private void updateInventoryTitles(ActiveTrade trade) {
        int i;
        Inventory newInv;
        Object titleComponent;
        String title;
        String titleTemplate;
        Player p1 = Bukkit.getPlayer((UUID)trade.getPlayerOne());
        Player p2 = Bukkit.getPlayer((UUID)trade.getPlayerTwo());
        if (p1 != null) {
            titleTemplate = this.messageManager.getRawMessage("gui-title");
            if (titleTemplate.isEmpty()) {
                titleTemplate = this.config.getString("gui.title", "&8TradeSpire");
            }
            if ((title = this.messageManager.replacePlaceholders(titleTemplate, p1, p2)).contains("<") && title.contains(">")) {
                try {
                    titleComponent = MiniMessage.miniMessage().deserialize(title);
                    title = LegacyComponentSerializer.legacySection().serialize((Component)titleComponent);
                }
                catch (Exception e) {
                    title = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)title);
                }
            } else {
                title = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)title);
            }
            newInv = Bukkit.createInventory(null, (int)this.inventorySize, (String)title);
            for (i = 0; i < this.inventorySize; ++i) {
                newInv.setItem(i, trade.getPlayerOneInventory().getItem(i));
            }
            trade.setPlayerOneInventory(newInv);
            p1.openInventory(newInv);
        }
        if (p2 != null) {
            titleTemplate = this.messageManager.getRawMessage("gui-title");
            if (titleTemplate.isEmpty()) {
                titleTemplate = this.config.getString("gui.title", "&8TradeSpire");
            }
            if ((title = this.messageManager.replacePlaceholders(titleTemplate, p2, p1)).contains("<") && title.contains(">")) {
                try {
                    titleComponent = MiniMessage.miniMessage().deserialize(title);
                    title = LegacyComponentSerializer.legacySection().serialize((Component)titleComponent);
                }
                catch (Exception e) {
                    title = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)title);
                }
            } else {
                title = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)title);
            }
            newInv = Bukkit.createInventory(null, (int)this.inventorySize, (String)title);
            for (i = 0; i < this.inventorySize; ++i) {
                newInv.setItem(i, trade.getPlayerTwoInventory().getItem(i));
            }
            trade.setPlayerTwoInventory(newInv);
            p2.openInventory(newInv);
        }
    }

    private void updateAcceptButtons(ActiveTrade trade) {
        this.updateAcceptButtonsInInventory(trade.getPlayerOneInventory(), trade);
        this.updateAcceptButtonsInInventory(trade.getPlayerTwoInventory(), trade);
    }

    private void updateAcceptButtonsInInventory(Inventory inv, ActiveTrade trade) {
        block23: {
            ItemStack otherWaitingButton;
            Player p2;
            Player p1;
            block22: {
                ItemStack otherConfirmButton;
                ItemStack waitingButton;
                ItemStack confirmButton;
                p1 = Bukkit.getPlayer((UUID)trade.getPlayerOne());
                p2 = Bukkit.getPlayer((UUID)trade.getPlayerTwo());
                if (p1 == null || p2 == null) {
                    return;
                }
                if (trade.isPlayerOneAccepted()) {
                    if (this.isItemEnabled("gui.items.self-confirm-trade")) {
                        confirmButton = this.createGuiItem("gui.items.self-confirm-trade", p1, p2);
                        for (int slot : this.selfConfirmSlots) {
                            if (slot < 0 || slot >= this.inventorySize) continue;
                            trade.getPlayerOneInventory().setItem(slot, confirmButton);
                        }
                    }
                } else if (this.isItemEnabled("gui.items.self-waiting-trade")) {
                    waitingButton = this.createGuiItem("gui.items.self-waiting-trade", p1, p2);
                    for (int slot : this.selfWaitingSlots) {
                        if (slot < 0 || slot >= this.inventorySize) continue;
                        trade.getPlayerOneInventory().setItem(slot, waitingButton);
                    }
                }
                if (trade.isPlayerTwoAccepted()) {
                    if (this.isItemEnabled("gui.items.self-confirm-trade")) {
                        confirmButton = this.createGuiItem("gui.items.self-confirm-trade", p2, p1);
                        for (int slot : this.selfConfirmSlots) {
                            if (slot < 0 || slot >= this.inventorySize) continue;
                            trade.getPlayerTwoInventory().setItem(slot, confirmButton);
                        }
                    }
                } else if (this.isItemEnabled("gui.items.self-waiting-trade")) {
                    waitingButton = this.createGuiItem("gui.items.self-waiting-trade", p2, p1);
                    for (int slot : this.selfWaitingSlots) {
                        if (slot < 0 || slot >= this.inventorySize) continue;
                        trade.getPlayerTwoInventory().setItem(slot, waitingButton);
                    }
                }
                if (trade.isPlayerTwoAccepted()) {
                    if (this.isItemEnabled("gui.items.other-confirm-trade")) {
                        otherConfirmButton = this.createGuiItem("gui.items.other-confirm-trade", p1, p2);
                        for (int slot : this.otherConfirmSlots) {
                            if (slot < 0 || slot >= this.inventorySize) continue;
                            trade.getPlayerOneInventory().setItem(slot, otherConfirmButton);
                        }
                    }
                } else if (this.isItemEnabled("gui.items.other-waiting-trade")) {
                    otherWaitingButton = this.createGuiItem("gui.items.other-waiting-trade", p1, p2);
                    for (int slot : this.otherWaitingSlots) {
                        if (slot < 0 || slot >= this.inventorySize) continue;
                        trade.getPlayerOneInventory().setItem(slot, otherWaitingButton);
                    }
                }
                if (!trade.isPlayerOneAccepted()) break block22;
                if (!this.isItemEnabled("gui.items.other-confirm-trade")) break block23;
                otherConfirmButton = this.createGuiItem("gui.items.other-confirm-trade", p2, p1);
                for (int slot : this.otherConfirmSlots) {
                    if (slot < 0 || slot >= this.inventorySize) continue;
                    trade.getPlayerTwoInventory().setItem(slot, otherConfirmButton);
                }
                break block23;
            }
            if (this.isItemEnabled("gui.items.other-waiting-trade")) {
                otherWaitingButton = this.createGuiItem("gui.items.other-waiting-trade", p2, p1);
                for (int slot : this.otherWaitingSlots) {
                    if (slot < 0 || slot >= this.inventorySize) continue;
                    trade.getPlayerTwoInventory().setItem(slot, otherWaitingButton);
                }
            }
        }
    }

    private void returnItemsToPlayer(Player player, Inventory inventory) {
        if (player == null || inventory == null) {
            return;
        }
        List<Integer> playerSlots = this.playerGetsLeftSide ? this.leftSlots : this.rightSlots;
        for (int slot : playerSlots) {
            HashMap leftover;
            ItemStack item = inventory.getItem(slot);
            if (item == null || item.getType() == Material.AIR || (leftover = player.getInventory().addItem(new ItemStack[]{item})).isEmpty()) continue;
            for (ItemStack drop : leftover.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), drop);
            }
            if (this.messageManager.getRawMessage("no-space-inventory").isEmpty()) continue;
            this.messageManager.sendMessage(player, "no-space-inventory", new TagResolver[0]);
        }
    }

    private void withdrawPlayer(OfflinePlayer player, double amount) {
        if (!this.isEconomyEnabled()) {
            return;
        }
        try {
            Method withdrawPlayer = this.econ.getClass().getMethod("withdrawPlayer", OfflinePlayer.class, Double.TYPE);
            withdrawPlayer.invoke(this.econ, player, amount);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to withdraw money: " + e.getMessage());
        }
    }

    private void depositPlayer(OfflinePlayer player, double amount) {
        if (!this.isEconomyEnabled()) {
            return;
        }
        try {
            Method depositPlayer = this.econ.getClass().getMethod("depositPlayer", OfflinePlayer.class, Double.TYPE);
            depositPlayer.invoke(this.econ, player, amount);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to deposit money: " + e.getMessage());
        }
    }

    private String format(double amount) {
        if (!this.isEconomyEnabled()) {
            return "0";
        }
        try {
            Method format = this.econ.getClass().getMethod("format", Double.TYPE);
            return (String)format.invoke(this.econ, amount);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to format money: " + e.getMessage());
            return String.valueOf(amount);
        }
    }

    private void completeTrade(ActiveTrade trade) {
        ItemStack item;
        Player playerOne = Bukkit.getPlayer((UUID)trade.getPlayerOne());
        Player playerTwo = Bukkit.getPlayer((UUID)trade.getPlayerTwo());
        if (playerOne == null || playerTwo == null) {
            trade.cancelTrade("One of the players went offline");
            return;
        }
        ArrayList<ItemStack> playerOneItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> playerTwoItems = new ArrayList<ItemStack>();
        List<Integer> playerSlots = this.playerGetsLeftSide ? this.leftSlots : this.rightSlots;
        for (int slot : playerSlots) {
            item = trade.getPlayerOneInventory().getItem(slot);
            if (item == null || item.getType() == Material.AIR) continue;
            playerOneItems.add(item);
        }
        for (int slot : playerSlots) {
            item = trade.getPlayerTwoInventory().getItem(slot);
            if (item == null || item.getType() == Material.AIR) continue;
            playerTwoItems.add(item);
        }
        this.transferItemsToPlayer(playerOneItems, playerTwo);
        this.transferItemsToPlayer(playerTwoItems, playerOne);
        if (this.isEconomyEnabled()) {
            if (trade.getPlayerOneMoney() > 0.0) {
                this.withdrawPlayer((OfflinePlayer)playerOne, trade.getPlayerOneMoney());
                this.depositPlayer((OfflinePlayer)playerTwo, trade.getPlayerOneMoney());
            }
            if (trade.getPlayerTwoMoney() > 0.0) {
                this.withdrawPlayer((OfflinePlayer)playerTwo, trade.getPlayerTwoMoney());
                this.depositPlayer((OfflinePlayer)playerOne, trade.getPlayerTwoMoney());
            }
        }
        playerOne.closeInventory();
        playerTwo.closeInventory();
        this.activeTrades.remove(playerOne.getUniqueId());
        this.activeTrades.remove(playerTwo.getUniqueId());
        this.messageManager.sendMessage(playerOne, "trade-completed", Placeholder.unparsed("player", playerTwo.getName()));
        this.messageManager.sendMessage(playerTwo, "trade-completed", Placeholder.unparsed("player", playerOne.getName()));
        if (this.isEconomyEnabled()) {
            if (trade.getPlayerTwoMoney() > 0.0) {
                this.messageManager.sendMessage(playerOne, "trade-received-items", Placeholder.unparsed("money", " and " + this.format(trade.getPlayerTwoMoney())));
            } else {
                this.messageManager.sendMessage(playerOne, "trade-received-items", Placeholder.unparsed("money", ""));
            }
            if (trade.getPlayerOneMoney() > 0.0) {
                this.messageManager.sendMessage(playerTwo, "trade-received-items", Placeholder.unparsed("money", " and " + this.format(trade.getPlayerOneMoney())));
            } else {
                this.messageManager.sendMessage(playerTwo, "trade-received-items", Placeholder.unparsed("money", ""));
            }
        } else {
            this.messageManager.sendMessage(playerOne, "trade-received-items", Placeholder.unparsed("money", ""));
            this.messageManager.sendMessage(playerTwo, "trade-received-items", Placeholder.unparsed("money", ""));
        }
    }

    private void transferItemsToPlayer(List<ItemStack> items, Player toPlayer) {
        for (ItemStack item : items) {
            HashMap leftover = toPlayer.getInventory().addItem(new ItemStack[]{item});
            if (leftover.isEmpty()) continue;
            for (ItemStack drop : leftover.values()) {
                toPlayer.getWorld().dropItemNaturally(toPlayer.getLocation(), drop);
            }
            if (this.messageManager.getRawMessage("no-space-inventory").isEmpty()) continue;
            this.messageManager.sendMessage(toPlayer, "no-space-inventory", new TagResolver[0]);
        }
    }

    private void openAddMoneyMenu(Player player) {
        if (!this.activeTrades.containsKey(player.getUniqueId())) {
            return;
        }
        ActiveTrade trade = this.activeTrades.get(player.getUniqueId());
        trade.setAddingMoney(player.getUniqueId(), true);
        Inventory moneyInv = Bukkit.createInventory(null, (int)18, (String)(String.valueOf(org.bukkit.ChatColor.GOLD) + "Enter Money Amount"));
        moneyInv.setItem(0, this.createMoneyOption(1, Material.GOLD_NUGGET));
        moneyInv.setItem(1, this.createMoneyOption(10, Material.GOLD_NUGGET));
        moneyInv.setItem(2, this.createMoneyOption(100, Material.GOLD_INGOT));
        moneyInv.setItem(3, this.createMoneyOption(1000, Material.GOLD_INGOT));
        moneyInv.setItem(4, this.createMoneyOption(10000, Material.GOLD_BLOCK));
        ItemStack customAmount = new ItemStack(Material.PAPER);
        ItemMeta customMeta = customAmount.getItemMeta();
        customMeta.setDisplayName(String.valueOf(org.bukkit.ChatColor.AQUA) + "Custom Amount");
        ArrayList<CallSite> customLore = new ArrayList<CallSite>();
        customLore.add((CallSite)((Object)(String.valueOf(org.bukkit.ChatColor.GRAY) + "Click to enter a custom amount")));
        customLore.add((CallSite)((Object)(String.valueOf(org.bukkit.ChatColor.GRAY) + "You'll type the amount in chat")));
        customMeta.setLore(customLore);
        customAmount.setItemMeta(customMeta);
        moneyInv.setItem(5, customAmount);
        ItemStack reset = new ItemStack(Material.BARRIER);
        ItemMeta resetMeta = reset.getItemMeta();
        resetMeta.setDisplayName(String.valueOf(org.bukkit.ChatColor.RED) + "Reset Amount");
        reset.setItemMeta(resetMeta);
        moneyInv.setItem(16, reset);
        ItemStack confirm = new ItemStack(Material.EMERALD);
        ItemMeta confirmMeta = confirm.getItemMeta();
        confirmMeta.setDisplayName(String.valueOf(org.bukkit.ChatColor.GREEN) + "Confirm");
        ArrayList<CallSite> confirmLore = new ArrayList<CallSite>();
        boolean isPlayerOne = player.getUniqueId().equals(trade.getPlayerOne());
        double currentMoney = isPlayerOne ? trade.getPlayerOneMoney() : trade.getPlayerTwoMoney();
        confirmLore.add((CallSite)((Object)(String.valueOf(org.bukkit.ChatColor.WHITE) + "Current amount: " + this.format(currentMoney))));
        confirmLore.add((CallSite)((Object)(String.valueOf(org.bukkit.ChatColor.WHITE) + "Your balance: " + this.format(this.getBalance((OfflinePlayer)player)))));
        confirmMeta.setLore(confirmLore);
        confirm.setItemMeta(confirmMeta);
        moneyInv.setItem(17, confirm);
        player.openInventory(moneyInv);
    }

    private ItemStack createMoneyOption(int amount, Material material) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(String.valueOf(org.bukkit.ChatColor.GOLD) + "Add " + this.format(amount));
        meta.setLore(Arrays.asList(String.valueOf(org.bukkit.ChatColor.GRAY) + "Click to add this amount"));
        item.setItemMeta(meta);
        return item;
    }

    @EventHandler
    public void onMoneyMenuClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!title.equals(String.valueOf(org.bukkit.ChatColor.GOLD) + "Enter Money Amount")) {
            return;
        }
        event.setCancelled(true);
        if (!this.activeTrades.containsKey(player.getUniqueId())) {
            player.closeInventory();
            return;
        }
        ActiveTrade trade = this.activeTrades.get(player.getUniqueId());
        boolean isPlayerOne = player.getUniqueId().equals(trade.getPlayerOne());
        int slot = event.getRawSlot();
        if (slot < 0 || slot >= event.getInventory().getSize()) {
            return;
        }
        double currentMoney = isPlayerOne ? trade.getPlayerOneMoney() : trade.getPlayerTwoMoney();
        double playerBalance = this.getBalance((OfflinePlayer)player);
        switch (slot) {
            case 0: {
                this.addMoney(trade, player, isPlayerOne, currentMoney, 1.0);
                break;
            }
            case 1: {
                this.addMoney(trade, player, isPlayerOne, currentMoney, 10.0);
                break;
            }
            case 2: {
                this.addMoney(trade, player, isPlayerOne, currentMoney, 100.0);
                break;
            }
            case 3: {
                this.addMoney(trade, player, isPlayerOne, currentMoney, 1000.0);
                break;
            }
            case 4: {
                this.addMoney(trade, player, isPlayerOne, currentMoney, 10000.0);
                break;
            }
            case 5: {
                player.closeInventory();
                this.awaitingCustomAmount.put(player.getUniqueId(), true);
                this.messageManager.sendMessage(player, "custom-amount-header", new TagResolver[0]);
                this.messageManager.sendMessage(player, "custom-amount-title", new TagResolver[0]);
                this.messageManager.sendMessage(player, "custom-amount-instruction", new TagResolver[0]);
                this.messageManager.sendMessage(player, "custom-amount-balance", Placeholder.unparsed("amount", this.format(playerBalance)));
                this.messageManager.sendMessage(player, "custom-amount-current", Placeholder.unparsed("amount", this.format(currentMoney)));
                this.messageManager.sendMessage(player, "custom-amount-cancel", new TagResolver[0]);
                this.messageManager.sendMessage(player, "custom-amount-header", new TagResolver[0]);
                break;
            }
            case 16: {
                if (isPlayerOne) {
                    trade.setPlayerOneMoney(0.0);
                } else {
                    trade.setPlayerTwoMoney(0.0);
                }
                this.updateMoneyConfirmItem(event.getInventory(), player, trade);
                break;
            }
            case 17: {
                trade.setAddingMoney(player.getUniqueId(), false);
                Inventory playerInventory = isPlayerOne ? trade.getPlayerOneInventory() : trade.getPlayerTwoInventory();
                player.openInventory(playerInventory);
                this.updateTradeInfo(trade);
                trade.resetAcceptance();
            }
        }
    }

    private void addMoney(ActiveTrade trade, Player player, boolean isPlayerOne, double currentMoney, double amount) {
        double newAmount = currentMoney + amount;
        double playerBalance = this.getBalance((OfflinePlayer)player);
        if (newAmount > playerBalance) {
            this.messageManager.sendMessage(player, "not-enough-money", new TagResolver[0]);
            return;
        }
        double maxAmount = this.config.getDouble("economy.max-amount", 1000000.0);
        if (newAmount > maxAmount) {
            this.messageManager.sendMessage(player, "amount-exceeds-max", Placeholder.unparsed("amount", this.format(maxAmount)));
            return;
        }
        if (isPlayerOne) {
            trade.setPlayerOneMoney(newAmount);
        } else {
            trade.setPlayerTwoMoney(newAmount);
        }
        this.updateMoneyConfirmItem(player.getOpenInventory().getTopInventory(), player, trade);
    }

    private void updateMoneyConfirmItem(Inventory inv, Player player, ActiveTrade trade) {
        boolean isPlayerOne = player.getUniqueId().equals(trade.getPlayerOne());
        double currentMoney = isPlayerOne ? trade.getPlayerOneMoney() : trade.getPlayerTwoMoney();
        ItemStack confirm = inv.getItem(17);
        if (confirm != null) {
            ItemMeta meta = confirm.getItemMeta();
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(org.bukkit.ChatColor.WHITE) + "Current amount: " + this.format(currentMoney))));
            lore.add((CallSite)((Object)(String.valueOf(org.bukkit.ChatColor.WHITE) + "Your balance: " + this.format(this.getBalance((OfflinePlayer)player)))));
            meta.setLore(lore);
            confirm.setItemMeta(meta);
        }
    }

    private void updateTradeInfo(ActiveTrade trade) {
        this.updateTradeInfoInInventory(trade.getPlayerOneInventory(), trade);
        this.updateTradeInfoInInventory(trade.getPlayerTwoInventory(), trade);
    }

    private void updateTradeInfoInInventory(Inventory inv, ActiveTrade trade) {
        ItemStack infoItem = new ItemStack(Material.PAPER);
        ItemMeta infoMeta = infoItem.getItemMeta();
        infoMeta.setDisplayName(String.valueOf(org.bukkit.ChatColor.GOLD) + "Trade Information");
        ArrayList<Object> infoLore = new ArrayList<Object>();
        Player playerOne = Bukkit.getPlayer((UUID)trade.getPlayerOne());
        Player playerTwo = Bukkit.getPlayer((UUID)trade.getPlayerTwo());
        if (playerOne != null && playerTwo != null) {
            if (this.isEconomyEnabled()) {
                infoLore.add(String.valueOf(org.bukkit.ChatColor.WHITE) + playerOne.getName() + String.valueOf(org.bukkit.ChatColor.GRAY) + " offers " + String.valueOf(org.bukkit.ChatColor.GOLD) + this.format(trade.getPlayerOneMoney()));
                infoLore.add(String.valueOf(org.bukkit.ChatColor.WHITE) + playerTwo.getName() + String.valueOf(org.bukkit.ChatColor.GRAY) + " offers " + String.valueOf(org.bukkit.ChatColor.GOLD) + this.format(trade.getPlayerTwoMoney()));
                infoLore.add("");
            }
            infoLore.add(String.valueOf(org.bukkit.ChatColor.WHITE) + playerOne.getName() + String.valueOf(org.bukkit.ChatColor.GRAY) + " has " + (trade.isPlayerOneAccepted() ? String.valueOf(org.bukkit.ChatColor.GREEN) + "accepted" : String.valueOf(org.bukkit.ChatColor.RED) + "not accepted"));
            infoLore.add(String.valueOf(org.bukkit.ChatColor.WHITE) + playerTwo.getName() + String.valueOf(org.bukkit.ChatColor.GRAY) + " has " + (trade.isPlayerTwoAccepted() ? String.valueOf(org.bukkit.ChatColor.GREEN) + "accepted" : String.valueOf(org.bukkit.ChatColor.RED) + "not accepted"));
        }
        infoMeta.setLore(infoLore);
        infoItem.setItemMeta(infoMeta);
        for (int slot : this.infoSlots) {
            if (slot < 0 || slot >= this.inventorySize) continue;
            inv.setItem(slot, infoItem);
        }
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public boolean hasActiveTrade(UUID playerUuid) {
        return this.activeTrades.containsKey(playerUuid);
    }

    public boolean hasPendingTradeRequest(UUID playerUuid) {
        return this.tradeRequests.containsKey(playerUuid);
    }

    public boolean isPlayerConfirming(UUID playerUuid) {
        if (!this.activeTrades.containsKey(playerUuid)) {
            return false;
        }
        ActiveTrade trade = this.activeTrades.get(playerUuid);
        return playerUuid.equals(trade.getPlayerOne()) ? trade.isPlayerOneAccepted() : trade.isPlayerTwoAccepted();
    }

    private class ActiveTrade {
        private final UUID playerOne;
        private final UUID playerTwo;
        private Inventory playerOneInventory;
        private Inventory playerTwoInventory;
        private boolean playerOneAccepted;
        private boolean playerTwoAccepted;
        private double playerOneMoney;
        private double playerTwoMoney;
        private final Map<UUID, Boolean> addingMoney = new HashMap<UUID, Boolean>();

        public ActiveTrade(UUID playerOne, UUID playerTwo) {
            this.playerOne = playerOne;
            this.playerTwo = playerTwo;
            this.playerOneAccepted = false;
            this.playerTwoAccepted = false;
            this.playerOneMoney = 0.0;
            this.playerTwoMoney = 0.0;
            this.addingMoney.put(playerOne, false);
            this.addingMoney.put(playerTwo, false);
        }

        public UUID getPlayerOne() {
            return this.playerOne;
        }

        public UUID getPlayerTwo() {
            return this.playerTwo;
        }

        public Inventory getPlayerOneInventory() {
            return this.playerOneInventory;
        }

        public void setPlayerOneInventory(Inventory inventory) {
            this.playerOneInventory = inventory;
        }

        public Inventory getPlayerTwoInventory() {
            return this.playerTwoInventory;
        }

        public void setPlayerTwoInventory(Inventory inventory) {
            this.playerTwoInventory = inventory;
        }

        public boolean isPlayerOneAccepted() {
            return this.playerOneAccepted;
        }

        public void setPlayerOneAccepted(boolean accepted) {
            this.playerOneAccepted = accepted;
        }

        public boolean isPlayerTwoAccepted() {
            return this.playerTwoAccepted;
        }

        public void setPlayerTwoAccepted(boolean accepted) {
            this.playerTwoAccepted = accepted;
        }

        public void resetAcceptance() {
            this.playerOneAccepted = false;
            this.playerTwoAccepted = false;
            TradeSpire.this.updateAcceptButtons(this);
            TradeSpire.this.updateInventoryTitles(this);
        }

        public double getPlayerOneMoney() {
            return this.playerOneMoney;
        }

        public void setPlayerOneMoney(double amount) {
            this.playerOneMoney = amount;
        }

        public double getPlayerTwoMoney() {
            return this.playerTwoMoney;
        }

        public void setPlayerTwoMoney(double amount) {
            this.playerTwoMoney = amount;
        }

        public boolean isAddingMoney(UUID playerId) {
            return this.addingMoney.getOrDefault(playerId, false);
        }

        public void setAddingMoney(UUID playerId, boolean adding) {
            this.addingMoney.put(playerId, adding);
        }

        public void cancelTrade(String reason) {
            Player p1 = Bukkit.getPlayer((UUID)this.playerOne);
            Player p2 = Bukkit.getPlayer((UUID)this.playerTwo);
            if (p1 != null && p1.isOnline()) {
                p1.closeInventory();
            }
            if (p2 != null && p2.isOnline()) {
                p2.closeInventory();
            }
            TradeSpire.this.endTrade(this, reason);
        }
    }

    private class TradeRequest {
        private final UUID sender;
        private final UUID target;
        private final long timestamp;

        public TradeRequest(TradeSpire tradeSpire, UUID sender, UUID target) {
            this.sender = sender;
            this.target = target;
            this.timestamp = System.currentTimeMillis();
        }

        public UUID getSender() {
            return this.sender;
        }

        public UUID getTarget() {
            return this.target;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

