/*
 * Decompiled with CFR 0.152.
 */
package com.tradespire;

import com.tradespire.TradeSpire;
import com.tradespire.libs.kyori.adventure.text.Component;
import com.tradespire.libs.kyori.adventure.text.minimessage.MiniMessage;
import com.tradespire.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import com.tradespire.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.tradespire.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManager {
    private final TradeSpire plugin;
    private final MiniMessage miniMessage;
    private final LegacyComponentSerializer legacySerializer;
    private FileConfiguration messages;
    private final Map<String, String> messageCache = new HashMap<String, String>();

    public MessageManager(TradeSpire plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
        this.legacySerializer = LegacyComponentSerializer.legacySection();
        this.loadMessages();
    }

    public void loadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            try {
                this.plugin.getDataFolder().mkdirs();
                try (InputStream in = this.plugin.getResource("messages.yml");){
                    if (in != null) {
                        Files.copy(in, messagesFile.toPath(), new CopyOption[0]);
                    } else {
                        messagesFile.createNewFile();
                        this.plugin.getLogger().warning("messages.yml resource not found, created empty file");
                    }
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create messages.yml: " + e.getMessage());
            }
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.messageCache.clear();
        this.cacheMessages("", (ConfigurationSection)this.messages);
        this.plugin.getLogger().info("Loaded " + this.messageCache.size() + " messages from messages.yml");
    }

    private void cacheMessages(String path, ConfigurationSection config) {
        for (String key : config.getKeys(false)) {
            String message;
            String fullPath;
            String string = fullPath = path.isEmpty() ? key : path + "." + key;
            if (config.isConfigurationSection(key)) {
                this.cacheMessages(fullPath, config.getConfigurationSection(key));
                continue;
            }
            if (!config.isString(key) || (message = config.getString(key)) == null) continue;
            this.messageCache.put(fullPath, message);
        }
    }

    public Component getMessage(String key, TagResolver ... placeholders) {
        String message = this.messageCache.get(key);
        if (message == null) {
            this.plugin.getLogger().warning("Missing message key: " + key);
            return Component.text("Missing message: " + key);
        }
        if (message.trim().isEmpty()) {
            return Component.empty();
        }
        return this.miniMessage.deserialize(message, placeholders);
    }

    public void sendMessage(CommandSender sender, String key, TagResolver ... placeholders) {
        String rawMessage = this.messageCache.get(key);
        if (rawMessage == null || rawMessage.trim().isEmpty()) {
            return;
        }
        Component message = this.getMessage(key, placeholders);
        String legacyMessage = this.legacySerializer.serialize(message);
        sender.sendMessage(legacyMessage);
    }

    public void sendMessage(Player player, String key, TagResolver ... placeholders) {
        this.sendMessage((CommandSender)player, key, placeholders);
    }

    public void sendMessage(CommandSender sender, String key, String placeholder, String value) {
        this.sendMessage(sender, key, Placeholder.unparsed(placeholder, value));
    }

    public void sendMessage(CommandSender sender, String key, Map<String, String> placeholders) {
        TagResolver[] resolvers = (TagResolver[])placeholders.entrySet().stream().map(entry -> Placeholder.unparsed((String)entry.getKey(), (String)entry.getValue())).toArray(TagResolver[]::new);
        this.sendMessage(sender, key, resolvers);
    }

    public void sendHelpMessages(CommandSender sender, String basePath, boolean isAdmin) {
        this.sendMessage(sender, basePath + ".header", new TagResolver[0]);
        this.sendMessage(sender, basePath + ".trade-player", new TagResolver[0]);
        this.sendMessage(sender, basePath + ".trade-send", new TagResolver[0]);
        this.sendMessage(sender, basePath + ".trade-accept", new TagResolver[0]);
        this.sendMessage(sender, basePath + ".trade-deny", new TagResolver[0]);
        this.sendMessage(sender, basePath + ".trade-toggle", new TagResolver[0]);
        this.sendMessage(sender, basePath + ".trade-help", new TagResolver[0]);
        if (isAdmin) {
            this.sendMessage(sender, basePath + ".trade-reload", new TagResolver[0]);
        }
        if (basePath.contains("console")) {
            this.sendMessage(sender, basePath + ".console-note", new TagResolver[0]);
        }
    }

    public String getRawMessage(String key) {
        return this.messageCache.getOrDefault(key, "");
    }

    public boolean hasMessage(String key) {
        return this.messageCache.containsKey(key) && !this.messageCache.get(key).trim().isEmpty();
    }

    public void reloadMessages() {
        this.messageCache.clear();
        this.loadMessages();
        this.plugin.getLogger().info("Messages reloaded successfully!");
    }

    public static TagResolver placeholder(String key, String value) {
        return Placeholder.unparsed(key, value);
    }

    public static TagResolver[] placeholders(String ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Key-value pairs must be even");
        }
        TagResolver[] resolvers = new TagResolver[keyValuePairs.length / 2];
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            resolvers[i / 2] = Placeholder.unparsed(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return resolvers;
    }

    public Map<String, String> getAllMessages() {
        return new HashMap<String, String>(this.messageCache);
    }

    public boolean isMessageEnabled(String key) {
        String message = this.messageCache.get(key);
        return message != null && !message.trim().isEmpty();
    }

    public void sendMessageIfExists(CommandSender sender, String key, TagResolver ... placeholders) {
        if (this.isMessageEnabled(key)) {
            this.sendMessage(sender, key, placeholders);
        }
    }
}

