/*
 * Decompiled with CFR 0.152.
 */
package com.tradespire;

import com.tradespire.TradeSpire;
import com.tradespire.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import com.tradespire.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TradeCommand
implements CommandExecutor,
TabCompleter {
    private final TradeSpire plugin;

    public TradeCommand(TradeSpire plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            if (sender instanceof Player) {
                this.showHelp((Player)sender);
            } else {
                this.plugin.getMessageManager().sendMessage(sender, "player-only", new TagResolver[0]);
            }
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                if (sender instanceof Player) {
                    this.showHelp((Player)sender);
                    break;
                }
                this.showConsoleHelp(sender);
                break;
            }
            case "toggle": {
                if (!(sender instanceof Player)) {
                    this.plugin.getMessageManager().sendMessage(sender, "player-only", new TagResolver[0]);
                    return true;
                }
                this.handleToggleCommand((Player)sender);
                break;
            }
            case "reload": {
                if (!sender.hasPermission("tradespire.admin")) {
                    this.plugin.getMessageManager().sendMessage(sender, "no-permission", new TagResolver[0]);
                    return true;
                }
                try {
                    this.plugin.reloadPluginConfig();
                    this.plugin.getMessageManager().sendMessage(sender, "config-reloaded", new TagResolver[0]);
                }
                catch (Exception e) {
                    this.plugin.getMessageManager().sendMessage(sender, "reload-error", Placeholder.unparsed("reason", e.getMessage()));
                    this.plugin.getLogger().severe("Error reloading configuration: " + e.getMessage());
                }
                break;
            }
            case "send": 
            case "request": {
                if (!(sender instanceof Player)) {
                    this.plugin.getMessageManager().sendMessage(sender, "player-only", new TagResolver[0]);
                    return true;
                }
                if (args.length < 2) {
                    this.plugin.getMessageManager().sendMessage(sender, "invalid-usage", new TagResolver[0]);
                    return true;
                }
                Player player = (Player)sender;
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    this.plugin.getMessageManager().sendMessage(sender, "player-not-found", new TagResolver[0]);
                    return true;
                }
                if (target.equals((Object)player)) {
                    this.plugin.getMessageManager().sendMessage(sender, "cannot-trade-self", new TagResolver[0]);
                    return true;
                }
                this.plugin.sendTradeRequest(player, target);
                break;
            }
            case "accept": {
                if (!(sender instanceof Player)) {
                    this.plugin.getMessageManager().sendMessage(sender, "player-only", new TagResolver[0]);
                    return true;
                }
                this.plugin.acceptTradeRequest((Player)sender);
                break;
            }
            case "deny": 
            case "decline": {
                if (!(sender instanceof Player)) {
                    this.plugin.getMessageManager().sendMessage(sender, "player-only", new TagResolver[0]);
                    return true;
                }
                this.plugin.denyTradeRequest((Player)sender);
                break;
            }
            default: {
                if (!(sender instanceof Player)) {
                    this.plugin.getMessageManager().sendMessage(sender, "player-only", new TagResolver[0]);
                    return true;
                }
                Player playerSender = (Player)sender;
                Player targetPlayer = Bukkit.getPlayer((String)args[0]);
                if (targetPlayer != null && !targetPlayer.equals((Object)playerSender)) {
                    this.plugin.sendTradeRequest(playerSender, targetPlayer);
                    break;
                }
                this.showHelp(playerSender);
            }
        }
        return true;
    }

    private void handleToggleCommand(Player player) {
        boolean currentState = this.plugin.getDatabaseManager().isTradeToggleEnabled(player.getUniqueId());
        boolean newState = !currentState;
        this.plugin.getDatabaseManager().setTradeToggle(player.getUniqueId(), newState).thenRun(() -> {
            if (newState) {
                this.plugin.getMessageManager().sendMessage(player, "trade-toggle-enabled", new TagResolver[0]);
            } else {
                this.plugin.getMessageManager().sendMessage(player, "trade-toggle-disabled", new TagResolver[0]);
            }
        });
    }

    private void showHelp(Player player) {
        boolean isAdmin = player.hasPermission("tradespire.admin");
        this.plugin.getMessageManager().sendHelpMessages((CommandSender)player, "help", isAdmin);
    }

    private void showConsoleHelp(CommandSender sender) {
        this.plugin.getMessageManager().sendHelpMessages(sender, "help.console", false);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            String partialInput = args[0].toLowerCase();
            if (sender instanceof Player) {
                completions.addAll(Arrays.asList("send", "accept", "deny", "toggle", "help"));
            } else {
                completions.add("help");
            }
            if (sender.hasPermission("tradespire.admin")) {
                completions.add("reload");
            }
            List<String> filteredCompletions = completions.stream().filter(s -> s.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
            if (sender instanceof Player) {
                Bukkit.getOnlinePlayers().forEach(player -> {
                    if (player.getName().toLowerCase().startsWith(partialInput)) {
                        filteredCompletions.add(player.getName());
                    }
                });
            }
            return filteredCompletions;
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("send") || args[0].equalsIgnoreCase("request"))) {
            String partialInput = args[1].toLowerCase();
            ArrayList<String> playerNames = new ArrayList<String>();
            if (sender instanceof Player) {
                Bukkit.getOnlinePlayers().forEach(player -> {
                    if (player != sender && player.getName().toLowerCase().startsWith(partialInput)) {
                        playerNames.add(player.getName());
                    }
                });
            }
            return playerNames;
        }
        return new ArrayList<String>();
    }
}

