/*
 * Decompiled with CFR 0.152.
 */
package com.tradespire;

import com.tradespire.TradeSpire;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TradeSpirePlaceholders
extends PlaceholderExpansion {
    private final TradeSpire plugin;

    public TradeSpirePlaceholders(TradeSpire plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "tradespire";
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (player == null) {
            return "";
        }
        if (params.equals("trade_toggle")) {
            boolean enabled = this.plugin.getDatabaseManager().isTradeToggleEnabled(player.getUniqueId());
            return enabled ? "enabled" : "disabled";
        }
        if (params.equals("trade_toggle_status")) {
            boolean enabled = this.plugin.getDatabaseManager().isTradeToggleEnabled(player.getUniqueId());
            return enabled ? "\u2713" : "\u2717";
        }
        if (player.isOnline()) {
            Player onlinePlayer = player.getPlayer();
            if (params.equals("has_active_trade")) {
                boolean hasActiveTrade = this.plugin.hasActiveTrade(onlinePlayer.getUniqueId());
                return hasActiveTrade ? "true" : "false";
            }
            if (params.equals("pending_requests")) {
                boolean hasPendingRequest = this.plugin.hasPendingTradeRequest(onlinePlayer.getUniqueId());
                return hasPendingRequest ? "true" : "false";
            }
            if (params.equals("is_confirming")) {
                boolean isConfirming = this.plugin.isPlayerConfirming(onlinePlayer.getUniqueId());
                return isConfirming ? "true" : "false";
            }
        } else {
            if (params.equals("has_active_trade")) {
                return "false";
            }
            if (params.equals("pending_requests")) {
                return "false";
            }
            if (params.equals("is_confirming")) {
                return "false";
            }
        }
        return null;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        return this.onRequest((OfflinePlayer)player, params);
    }
}

