/*
 * Decompiled with CFR 0.152.
 */
package undead.armies.behaviour.group.task;

import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import undead.armies.UndeadArmies;
import undead.armies.base.GetSingle;
import undead.armies.behaviour.group.task.BaseTask;
import undead.armies.behaviour.single.Single;

public class Stack
extends BaseTask {
    public static final int stack = 0;
    public static final int dismount = 1;
    public static final int emptyCounterBeforeDeleteSelf = 1;
    public static final float minimumDistanceToStack = 3.0f;
    public int emptyCounter = 0;

    @Override
    public void handleTask(@NotNull Single single, @NotNull LivingEntity target) {
        switch (single.groupStorage.assignedTask) {
            case 0: {
                if (single.pathfinderMob.is((Entity)this.starter.pathfinderMob)) {
                    if (this.emptyCounter > 1) {
                        this.emptyCounter = 0;
                        this.starter = null;
                        single.groupStorage.reset();
                    } else if (this.starter.pathfinderMob.getPassengers().isEmpty()) {
                        ++this.emptyCounter;
                    }
                    return;
                }
                if (this.starter.pathfinderMob.distanceTo((Entity)single.pathfinderMob) <= 3.0f) {
                    this.starter.pathfinderMob.startRiding((Entity)single.pathfinderMob);
                    this.starter.groupStorage.assignedTask = 1;
                    this.starter = single;
                    return;
                }
                single.pathfinderMob.getNavigation().moveTo((Entity)this.starter.pathfinderMob, (double)0.2f);
                break;
            }
            case 1: {
                BlockPos pathFinderMobBlockPos = single.pathfinderMob.blockPosition();
                int pathFinderMobHeight = (int)Math.ceil(single.pathfinderMob.getEyeHeight());
                Level level = single.pathfinderMob.level();
                Vec3 targetPosition = target.position();
                double distance = targetPosition.distanceTo(single.pathfinderMob.position());
                for (int x = -2; x < 2; ++x) {
                    for (int z = -2; z < 2; ++z) {
                        for (int y = -2; y < 2; ++y) {
                            BlockState blockState;
                            BlockPos blockPos = new BlockPos(pathFinderMobBlockPos.getX() + x, pathFinderMobBlockPos.getY() + y, pathFinderMobBlockPos.getZ() + z);
                            if (targetPosition.distanceTo(new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ())) + 1.0 >= distance || (blockState = level.getBlockState(blockPos)).isEmpty() || blockState.getBlock() instanceof LiquidBlock) continue;
                            boolean success = true;
                            for (int i = 0; i < pathFinderMobHeight; ++i) {
                                BlockPos blockPosAtY = blockPos.atY(blockPos.getY() + i + 1);
                                if (level.getBlockState(blockPosAtY).isEmpty()) continue;
                                Block block = level.getBlockState(blockPosAtY).getBlock();
                                if (block instanceof LiquidBlock) {
                                    LiquidBlock liquidBlock = (LiquidBlock)block;
                                    if (liquidBlock.fluid instanceof WaterFluid) continue;
                                }
                                success = false;
                                break;
                            }
                            if (!success) continue;
                            UndeadArmies.logger.debug("dist " + targetPosition.distanceTo(new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ())) + " dist: " + distance);
                            single.pathfinderMob.stopRiding();
                            single.pathfinderMob.dismountTo((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.0, (double)blockPos.getZ() + 0.5);
                            if (!target.isDeadOrDying()) {
                                single.pathfinderMob.getNavigation().moveTo((Entity)target, (double)0.2f);
                            }
                            if (single.pathfinderMob.getPassengers().isEmpty()) {
                                single.groupStorage.reset();
                                continue;
                            }
                            this.splitTask(single);
                        }
                    }
                }
                break;
            }
        }
    }

    @Override
    public boolean handleDelete(@NotNull Single single) {
        if (single.pathfinderMob.getVehicle() == null) {
            single.groupStorage.assignedTask = 0;
            this.starter = single;
        }
        return false;
    }

    @Override
    public void splitTask(@NotNull Single single) {
        single.groupStorage.task = new Stack(single, this.taskIndex);
        single.groupStorage.assignedTask = 0;
        this.changeTaskForPassengers(single.groupStorage.task, (Entity)single.pathfinderMob);
    }

    protected void changeTaskForPassengers(BaseTask baseTask, Entity entity) {
        if (!(entity instanceof PathfinderMob)) {
            return;
        }
        if (entity instanceof GetSingle) {
            GetSingle getSingle = (GetSingle)entity;
            ((PathfinderMob)entity).addEffect(new MobEffectInstance(MobEffects.GLOWING, 60));
            if (getSingle.getSingle().groupStorage == null) {
                return;
            }
            getSingle.getSingle().groupStorage.task = baseTask;
            for (Entity passenger : entity.getPassengers()) {
                this.changeTaskForPassengers(baseTask, passenger);
            }
        }
    }

    public Stack(@NotNull Single starter, int taskIndex) {
        super(starter, taskIndex);
    }
}

