/*
 * Decompiled with CFR 0.152.
 */
package undead.armies.behaviour.group.task.selector;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import undead.armies.behaviour.group.task.BaseTask;
import undead.armies.behaviour.group.task.Mine;
import undead.armies.behaviour.group.task.selector.BaseTaskSelector;
import undead.armies.behaviour.single.Single;

public class MineTaskSelector
extends BaseTaskSelector {
    public static final MineTaskSelector instance = new MineTaskSelector();
    public static final double maxDistanceFromTask = 12.0;
    public static final double distanceToBeConsideredAsNotMoving = 1.0;

    protected static int getPositiveOrNegativeOne(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public static ArrayList<BlockPos> getBlockPosForSingle(@NotNull Single single, @NotNull Vec3 directionToTarget) {
        int z;
        int y;
        int x;
        int yDirection;
        int xDirection = MineTaskSelector.getPositiveOrNegativeOne(directionToTarget.x);
        int zDirection = MineTaskSelector.getPositiveOrNegativeOne(directionToTarget.z);
        ArrayList<BlockPos> output = new ArrayList<BlockPos>();
        if (directionToTarget.y < 0.0) {
            BlockPos blockPos = single.pathfinderMob.blockPosition();
            yDirection = -1;
            x = blockPos.getX();
            y = blockPos.getY();
            z = blockPos.getZ();
        } else {
            BlockPos blockPos = single.pathfinderMob.blockPosition().atY(single.pathfinderMob.getBlockY() + 1);
            yDirection = 1;
            x = blockPos.getX();
            y = blockPos.getY();
            z = blockPos.getZ();
            output.add(new BlockPos(x, y + 2, z));
            output.add(new BlockPos(x + xDirection, y + 2, z));
            output.add(new BlockPos(x, y + 2, z + zDirection));
            output.add(new BlockPos(x + xDirection, y + 2, z + zDirection));
        }
        output.add(new BlockPos(x, y + yDirection, z));
        output.add(new BlockPos(x + xDirection, y + yDirection, z));
        output.add(new BlockPos(x, y + yDirection, z + zDirection));
        output.add(new BlockPos(x + xDirection, y + yDirection, z + zDirection));
        output.add(new BlockPos(x, y, z));
        output.add(new BlockPos(x + xDirection, y, z));
        output.add(new BlockPos(x, y, z + zDirection));
        output.add(new BlockPos(x + xDirection, y, z + zDirection));
        return output;
    }

    @Override
    public BaseTask getSuitableTask(@NotNull ArrayList<BaseTask> tasks, @NotNull Single single, @NotNull LivingEntity target, @NotNull int taskIndex) {
        if (single.lastPosition.distanceTo(single.currentPosition) >= 1.0) {
            return null;
        }
        BaseTaskSelector.cleanTasks(tasks);
        Vec3 position = single.pathfinderMob.position();
        for (BaseTask baseTask : tasks) {
            if (!(baseTask instanceof Mine)) continue;
            Mine mine = (Mine)baseTask;
            if (!(position.distanceTo(mine.mineTargetVec3) <= 12.0)) continue;
            return baseTask;
        }
        Vec3 directionToTarget = target.position().subtract(position);
        ArrayList<BlockPos> blockPos = MineTaskSelector.getBlockPosForSingle(single, directionToTarget);
        if (blockPos.isEmpty()) {
            return null;
        }
        tasks.add(new Mine(single, taskIndex, blockPos));
        return tasks.get(tasks.size() - 1);
    }

    private MineTaskSelector() {
    }
}

