/*
 * Decompiled with CFR 0.152.
 */
package undead.armies.behaviour.group.task.selector;

import java.util.ArrayList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import undead.armies.behaviour.group.task.BaseTask;
import undead.armies.behaviour.group.task.Stack;
import undead.armies.behaviour.group.task.selector.BaseTaskSelector;
import undead.armies.behaviour.single.Single;

public class StackTaskSelector
extends BaseTaskSelector {
    public static final double distanceAdder = 1.5;
    public static final double distanceToBeConsideredAsNotMoving = 1.3;
    public static final StackTaskSelector instance = new StackTaskSelector();

    @Override
    public BaseTask getSuitableTask(@NotNull ArrayList<BaseTask> tasks, @NotNull Single single, @NotNull LivingEntity target, int taskIndex) {
        if (single.lastPosition.distanceTo(single.currentPosition) >= 1.3) {
            return null;
        }
        BaseTaskSelector.cleanTasks(tasks);
        single.groupStorage.assignedTask = 0;
        Vec3 targetPosition = target.position();
        double distanceToTargetPosition = single.pathfinderMob.position().distanceTo(targetPosition) + 1.5;
        for (BaseTask task : tasks) {
            if (!(task.starter.pathfinderMob.position().distanceTo(targetPosition) <= distanceToTargetPosition)) continue;
            return task;
        }
        tasks.add(new Stack(single, taskIndex));
        return tasks.get(tasks.size() - 1);
    }

    private StackTaskSelector() {
    }
}

