/*
 * Decompiled with CFR 0.152.
 */
package undead.armies.behaviour.group;

import java.util.ArrayList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import undead.armies.behaviour.group.Group;
import undead.armies.behaviour.group.GroupStorage;
import undead.armies.behaviour.group.task.selector.MineTaskSelector;
import undead.armies.behaviour.group.task.selector.StackTaskSelector;
import undead.armies.behaviour.group.task.selector.TaskSelectorStorage;
import undead.armies.behaviour.single.Single;

public final class GroupUtil {
    public static final GroupUtil instance = new GroupUtil();

    public void setTaskSelectors(@NotNull ArrayList<TaskSelectorStorage> taskSelectorStorages) {
        taskSelectorStorages.add(new TaskSelectorStorage(StackTaskSelector.instance, 0.5f));
        taskSelectorStorages.add(new TaskSelectorStorage(MineTaskSelector.instance, 0.5f));
    }

    protected Group createGroup(LivingEntity target, Single requester) {
        return new Group(target);
    }

    protected GroupStorage createGroupStorage(Group group, Single requester) {
        return new GroupStorage(group);
    }

    public Group getGroupThatAttacks(LivingEntity target, Single requester) {
        if (target == null) {
            return null;
        }
        for (Group group : Group.groups) {
            if (!group.target.is((Entity)target)) continue;
            return group;
        }
        int groupsSize = Group.groups.size();
        Group.groups.add(this.createGroup(target, requester));
        return Group.groups.get(groupsSize);
    }

    public GroupStorage getGroupStorageThatAttacks(LivingEntity target, Single requester) {
        Group group = this.getGroupThatAttacks(target, requester);
        if (group == null) {
            return null;
        }
        return this.createGroupStorage(group, requester);
    }

    private GroupUtil() {
    }
}

