/*
 * Decompiled with CFR 0.152.
 */
package undead.armies.behaviour.group.task;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import undead.armies.behaviour.group.task.BaseTask;
import undead.armies.behaviour.group.task.selector.TaskSelectorStorage;
import undead.armies.behaviour.single.Single;

public class Mine
extends BaseTask {
    public static final double maxMiningDistance = 3.0;
    public static final float blastResistanceToHitPointRatio = 8.0f;
    protected final ArrayList<BlockPos> mineTargets;
    protected BlockPos mineTarget;
    public final Vec3 mineTargetVec3;
    public int miningProgress = 0;

    @Override
    public void handleTask(@NotNull Single single, @NotNull LivingEntity target) {
        if (single.pathfinderMob.position().distanceTo(this.mineTargetVec3) >= 3.0) {
            single.pathfinderMob.getNavigation().moveTo(this.mineTargetVec3.x, this.mineTargetVec3.y, this.mineTargetVec3.z, (double)0.2f);
            return;
        }
        ++this.miningProgress;
        Level level = single.pathfinderMob.level();
        BlockState blockState = level.getBlockState(this.mineTarget);
        if (blockState.isEmpty()) {
            if (this.mineTargets.isEmpty()) {
                this.starter = null;
                single.groupStorage.reset();
                return;
            }
            this.mineTarget = this.mineTargets.removeLast();
            this.miningProgress = 0;
            return;
        }
        float requiredMiningProgress = blockState.getBlock().getExplosionResistance() * 8.0f;
        level.playSound(null, this.mineTarget, blockState.getSoundType((LevelReader)level, this.mineTarget, (Entity)single.pathfinderMob).getHitSound(), SoundSource.BLOCKS, (float)this.miningProgress / requiredMiningProgress * 2.0f + 1.0f, 1.0f);
        if ((float)this.miningProgress > requiredMiningProgress) {
            Block.dropResources((BlockState)blockState, (Level)level, (BlockPos)this.mineTarget);
            level.setBlock(this.mineTarget, Blocks.AIR.defaultBlockState(), 3);
            level.playSound(null, this.mineTarget, blockState.getSoundType((LevelReader)level, this.mineTarget, (Entity)single.pathfinderMob).getBreakSound(), SoundSource.BLOCKS, 3.0f, 1.0f);
        }
    }

    @Override
    public boolean handleDelete(@NotNull Single single) {
        if (this.starter == null) {
            return true;
        }
        this.starter = single;
        return false;
    }

    public Mine(@NotNull Single starter, TaskSelectorStorage taskSelectorStorage, @NotNull ArrayList<BlockPos> mineTargets) {
        super(starter, taskSelectorStorage);
        this.mineTargets = mineTargets;
        this.mineTarget = this.mineTargets.removeLast();
        this.mineTargetVec3 = starter.currentPosition;
    }
}

