/*
 * Decompiled with CFR 0.152.
 */
package undead.armies.behaviour.group.task.selector;

import java.util.ArrayList;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import undead.armies.behaviour.group.task.BaseTask;
import undead.armies.behaviour.group.task.selector.TaskSelectorStorage;
import undead.armies.behaviour.single.Single;

public abstract class BaseTaskSelector {
    public static float distanceToBeConsideredAsMoving = 0.7f;

    public static void cleanTasks(@NotNull ArrayList<BaseTask> tasks) {
        tasks.removeIf(baseTask -> {
            if (baseTask.starter == null || baseTask.starter.pathfinderMob.isDeadOrDying() || baseTask.starter.groupStorage == null) {
                baseTask.deleted = true;
                return true;
            }
            return false;
        });
    }

    public static boolean isMoving(@NotNull Single single) {
        return single.lastPosition.distanceTo(single.currentPosition) >= (double)distanceToBeConsideredAsMoving;
    }

    public abstract BaseTask getSuitableTask(@NotNull TaskSelectorStorage var1, @NotNull Single var2, @NotNull LivingEntity var3);

    public abstract boolean tick(@NotNull TaskSelectorStorage var1, @NotNull Single var2, @NotNull LivingEntity var3);
}

