/*
 * Decompiled with CFR 0.152.
 */
package undead.armies.behaviour.group.task.selector;

import java.util.ArrayList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import undead.armies.behaviour.group.task.BaseTask;
import undead.armies.behaviour.group.task.Stack;
import undead.armies.behaviour.group.task.selector.BaseTaskSelector;
import undead.armies.behaviour.group.task.selector.TaskSelectorStorage;
import undead.armies.behaviour.single.Single;

public class StackTaskSelector
extends BaseTaskSelector {
    public static final double distanceAdder = 1.5;
    public static final float baseWeight = 0.5f;
    public static final double expectedDistanceToPlayer = 5.0;
    public static final StackTaskSelector instance = new StackTaskSelector();

    @Override
    public BaseTask getSuitableTask(@NotNull TaskSelectorStorage taskSelectorStorage, @NotNull Single single, @NotNull LivingEntity target) {
        if (BaseTaskSelector.isMoving(single)) {
            return null;
        }
        ArrayList<BaseTask> tasks = taskSelectorStorage.taskStorage;
        BaseTaskSelector.cleanTasks(tasks);
        single.groupStorage.assignedTask = 0;
        Vec3 targetPosition = target.position();
        double distanceToTargetPosition = single.pathfinderMob.position().distanceTo(targetPosition) + 1.5;
        for (BaseTask task : tasks) {
            if (!(task.starter.pathfinderMob.position().distanceTo(targetPosition) <= distanceToTargetPosition)) continue;
            return task;
        }
        tasks.add(new Stack(single, taskSelectorStorage));
        return tasks.get(tasks.size() - 1);
    }

    @Override
    public boolean tick(@NotNull TaskSelectorStorage taskSelectorStorage, @NotNull Single single, @NotNull LivingEntity target) {
        double sumOfDifferences = 0.0;
        double targetHeight = target.position().y;
        int numberOfEntries = 0;
        float calculatedWeight = 0.5f;
        for (BaseTask task : taskSelectorStorage.taskStorage) {
            if (task.starter == null || task.starter.currentPosition == null) continue;
            sumOfDifferences += targetHeight - task.starter.currentPosition.y;
            ++numberOfEntries;
        }
        sumOfDifferences = sumOfDifferences / (double)numberOfEntries / 5.0;
        float commonFloat = 0.2f + (float)sumOfDifferences / 10.0f;
        if (sumOfDifferences > 0.0) {
            calculatedWeight += 0.15f;
        }
        if (sumOfDifferences > 1.0) {
            calculatedWeight += commonFloat;
        }
        if (sumOfDifferences < 0.0) {
            calculatedWeight -= 0.15f;
        }
        if (sumOfDifferences < 1.0) {
            Math.max(calculatedWeight -= commonFloat, 0.1f);
            int taskStorageSize = taskSelectorStorage.taskStorage.size();
            int amountToBeDeleted = (int)Math.floor(0.5f - calculatedWeight) * taskStorageSize + 1;
            if (amountToBeDeleted > taskStorageSize) {
                amountToBeDeleted = taskStorageSize;
            }
            for (int i = 0; i < amountToBeDeleted; ++i) {
                taskSelectorStorage.taskStorage.removeLast().killed = true;
            }
        }
        taskSelectorStorage.rawWeight = calculatedWeight;
        return true;
    }

    private StackTaskSelector() {
    }
}

