/*
 * Decompiled with CFR 0.152.
 */
package undead.armies;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class Util {
    public static void throwPotion(LivingEntity livingEntity, LivingEntity target, ItemStack itemStack, float velocity, float accuracy) {
        Level level = livingEntity.level();
        level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.SPLASH_POTION_THROW, SoundSource.NEUTRAL, 1.0f, 1.0f);
        if (!livingEntity.level().isClientSide()) {
            ThrownPotion thrownPotion = new ThrownPotion(livingEntity.level(), livingEntity);
            thrownPotion.setItem(itemStack);
            Vec3 movementDelta = target.getDeltaMovement();
            double x = target.getX() + movementDelta.x - livingEntity.getX();
            double z = target.getZ() + movementDelta.z - livingEntity.getZ();
            double distance = Math.sqrt(x * x + z * z);
            thrownPotion.shoot(x, distance / (double)velocity * 0.5, z, velocity, accuracy);
            level.addFreshEntity((Entity)thrownPotion);
        }
    }
}

