/*
 * Decompiled with CFR 0.152.
 */
package undead.armies.behaviour.group.task;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.WaterFluid;
import undead.armies.UndeadArmies;
import undead.armies.behaviour.group.task.BaseTask;
import undead.armies.behaviour.group.task.selector.StackTaskSelector;
import undead.armies.behaviour.single.Single;

public class Stack
extends BaseTask {
    public static final int stack = 1;
    public static final int dismount = 2;
    public static final int hitCounterToMakeStackingMobsFall = 3;
    public static final float hitDamageToMakeStackingMobsFall = 3.0f;
    public static final float minimumDistanceToStack = 3.0f;

    public Stack(Single single) {
        super(single);
        UndeadArmies.logger.debug("created stack task!");
    }

    @Override
    public void handleTask(Single single, LivingEntity target) {
        if (single.groupStorage == null) {
            return;
        }
        switch (single.groupStorage.assignedTask) {
            case 1: {
                if (single.pathfinderMob.is((Entity)this.starter.pathfinderMob)) {
                    return;
                }
                if (this.starter.pathfinderMob.distanceTo((Entity)single.pathfinderMob) <= 3.0f) {
                    this.starter.pathfinderMob.startRiding((Entity)single.pathfinderMob);
                    this.starter.groupStorage.assignedTask = 2;
                    this.starter = single;
                    return;
                }
                single.pathfinderMob.getNavigation().moveTo((Entity)this.starter.pathfinderMob, (double)0.2f);
                break;
            }
            case 2: {
                UndeadArmies.logger.debug("task " + single.groupStorage.assignedTask + " b");
                if (this.deleted && single.pathfinderMob.getVehicle() == null) {
                    this.deleted = false;
                    this.starter = single;
                    single.groupStorage.assignedTask = 1;
                    StackTaskSelector.addTaskBack.add(this);
                }
                BlockPos pathFinderMobBlockPos = single.pathfinderMob.blockPosition();
                int pathFinderMobHeight = (int)Math.ceil(single.pathfinderMob.getEyeHeight());
                Level level = single.pathfinderMob.level();
                for (int x = -2; x < 2; ++x) {
                    for (int z = -2; z < 2; ++z) {
                        for (int y = -1; y < 2; ++y) {
                            BlockPos blockPos = new BlockPos(pathFinderMobBlockPos.getX() + x, pathFinderMobBlockPos.getY() + y, pathFinderMobBlockPos.getZ() + z);
                            BlockState blockState = level.getBlockState(blockPos);
                            if (blockState.isEmpty() || blockState.getBlock() instanceof LiquidBlock) continue;
                            boolean success = true;
                            for (int i = 0; i < pathFinderMobHeight; ++i) {
                                BlockPos blockPosAtY = blockPos.atY(blockPos.getY() + i + 1);
                                if (level.getBlockState(blockPosAtY).isEmpty()) continue;
                                Block block = level.getBlockState(blockPosAtY).getBlock();
                                if (block instanceof LiquidBlock) {
                                    LiquidBlock liquidBlock = (LiquidBlock)block;
                                    if (liquidBlock.fluid instanceof WaterFluid) continue;
                                }
                                success = false;
                                break;
                            }
                            if (success) {
                                UndeadArmies.logger.debug("success!");
                                single.pathfinderMob.stopRiding();
                                single.pathfinderMob.dismountTo((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.0, (double)blockPos.getZ() + 0.5);
                                if (!target.isDeadOrDying()) {
                                    single.pathfinderMob.getNavigation().moveTo((Entity)target, (double)0.2f);
                                }
                                single.groupStorage.assignedTask = -1;
                                single.groupStorage.task = null;
                            }
                            UndeadArmies.logger.debug("finished task! ");
                        }
                    }
                }
                break;
            }
        }
    }
}

