/*
 * Decompiled with CFR 0.152.
 */
package undead.armies.behaviour.type;

import net.minecraft.util.RandomSource;
import undead.armies.behaviour.type.Alchemist;
import undead.armies.behaviour.type.BaseType;
import undead.armies.behaviour.type.Engineer;
import undead.armies.behaviour.type.Giant;
import undead.armies.behaviour.type.Normal;

public final class TypeUtil {
    public static final TypeUtil instance = new TypeUtil();

    private TypeUtil() {
    }

    public BaseType[] getAllMobTypes() {
        return new BaseType[]{Alchemist.alchemist, Engineer.engineer, Giant.giant, Normal.normal};
    }

    public BaseType defaultMobType() {
        return Normal.normal;
    }

    public BaseType getMobType(RandomSource randomSource) {
        BaseType[] baseTypes = this.getAllMobTypes();
        int mobTypesLength = baseTypes.length;
        float[] chances = new float[mobTypesLength];
        float divisor = 0.0f;
        for (int i = 0; i < mobTypesLength; ++i) {
            chances[i] = baseTypes[i].chance();
            divisor += chances[i];
        }
        float randomResult = randomSource.nextFloat();
        float cumulative = 0.0f;
        for (int i = 0; i < mobTypesLength; ++i) {
            if (!((cumulative += chances[i] / divisor) >= randomResult)) continue;
            return baseTypes[i];
        }
        return this.defaultMobType();
    }
}

