/*
 * Decompiled with CFR 0.152.
 */
package net.player005.vegandelightfabric.labels;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_7923;
import net.player005.recipe_modification.api.RecipeModification;
import net.player005.vegandelightfabric.labels.VeganNBT;
import net.player005.vegandelightfabric.labels.VeganTags;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class VeganLabels {
    private static final Map<class_1792, VeganStatus> veganFromRecipes = new HashMap<class_1792, VeganStatus>();
    private static boolean debugMode = false;

    @ApiStatus.Internal
    public static void initialize() {
        RecipeModification.registerGlobalResultModifier((recipe, result, recipeInput) -> {
            if (recipeInput != null) {
                ArrayList<class_1799> list = new ArrayList<class_1799>();
                for (int i = 0; i < recipeInput.method_5439(); ++i) {
                    class_1799 stack = recipeInput.method_5438(i);
                    if (stack.method_7960()) continue;
                    list.add(stack);
                }
                VeganLabels.modifyRecipeResult(list, result);
            }
            return result;
        });
        Stopwatch timer = Stopwatch.createStarted();
        ArrayList<class_1792> traversedList = new ArrayList<class_1792>(class_7923.field_41178.method_10204());
        for (class_1792 item : class_7923.field_41178) {
            if (traversedList.contains(item)) continue;
            VeganLabels.scanRecipesRecursively(item, traversedList);
        }
        LoggerFactory.getLogger(VeganLabels.class).info("Scanned {} items for vegan recipes in {}", (Object)class_7923.field_41178.method_10204(), (Object)timer);
    }

    public static VeganStatus isVegan(class_1799 itemStack) {
        Boolean fromComponent = VeganNBT.getVeganFromNBT(itemStack);
        if (fromComponent != null) {
            return VeganStatus.fromBoolean(fromComponent);
        }
        if (itemStack.method_31573(VeganTags.VEGAN)) {
            return VeganStatus.VEGAN;
        }
        if (itemStack.method_31573(VeganTags.NOT_VEGAN)) {
            return VeganStatus.NOT_VEGAN;
        }
        return veganFromRecipes.getOrDefault(itemStack.method_7909(), VeganStatus.UNKNOWN);
    }

    public static void setIsVegan(class_1799 stack, boolean isVegan) {
        boolean isFood;
        boolean bl = isFood = stack.method_31573(VeganTags.SHOULD_HAVE_DATA_COMPONENTS_ADDED) || stack.method_7976() == class_1839.field_8950 || stack.method_7976() == class_1839.field_8946;
        if (!isFood && !VeganNBT.containsSubstitute(stack)) {
            return;
        }
        VeganStatus currentStatus = VeganLabels.isVegan(stack);
        if (VeganNBT.hasVeganNBTTag(stack)) {
            return;
        }
        if (isVegan && (currentStatus == VeganStatus.VEGAN || currentStatus == VeganStatus.UNKNOWN)) {
            return;
        }
        if (!isVegan && currentStatus == VeganStatus.NOT_VEGAN) {
            return;
        }
        VeganNBT.setVeganInNBT(stack, isVegan);
    }

    private static void scanRecipesRecursively(class_1792 item, List<class_1792> alreadyTraversed) {
        alreadyTraversed.add(item);
        ImmutableCollection recipes = RecipeModification.getRecipesByResult((class_1792)item);
        int veganRecipes = 0;
        int nonVeganRecipes = 0;
        for (class_1860 recipe : recipes) {
            if (VeganLabels.recipeNotVegan(alreadyTraversed, recipe)) {
                ++nonVeganRecipes;
                continue;
            }
            ++veganRecipes;
        }
        VeganStatus result = VeganStatus.UNKNOWN;
        if (veganRecipes > nonVeganRecipes) {
            result = VeganStatus.VEGAN;
        }
        if (veganRecipes < nonVeganRecipes) {
            result = VeganStatus.NOT_VEGAN;
        }
        int differencePercentage = (int)(100.0f * (float)Math.abs(veganRecipes - nonVeganRecipes) / (float)recipes.size());
        if (recipes.size() > 1 && differencePercentage < 20) {
            result = VeganStatus.UNKNOWN;
        }
        veganFromRecipes.put(item, result);
    }

    private static boolean recipeNotVegan(List<class_1792> alreadyTraversed, class_1860<?> recipe) {
        for (class_1856 ingredient : recipe.method_8117()) {
            int nonVeganItems = 0;
            int total = 0;
            for (class_1799 itemStack : ingredient.method_8105()) {
                if (itemStack.method_31573(VeganTags.VEGAN_ALTERNATIVE)) continue;
                VeganStatus vegan = VeganLabels.isVegan(itemStack);
                if (vegan == VeganStatus.UNKNOWN) {
                    class_1792 unknownItem = itemStack.method_7909();
                    if (!alreadyTraversed.contains(unknownItem)) {
                        VeganLabels.scanRecipesRecursively(unknownItem, alreadyTraversed);
                    }
                    vegan = veganFromRecipes.getOrDefault(unknownItem, VeganStatus.UNKNOWN);
                }
                if (vegan == VeganStatus.NOT_VEGAN) {
                    ++nonVeganItems;
                }
                ++total;
            }
            if (!((float)nonVeganItems / (float)total >= 0.5f)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldRenderTooltip(class_1799 itemStack) {
        return !Boolean.FALSE.equals(VeganNBT.getVeganFromNBT(itemStack)) && !itemStack.method_31573(VeganTags.VEGAN_ALTERNATIVE) && VeganNBT.containsSubstitute(itemStack);
    }

    public static void addTooltipLines(class_1799 stack, List<class_2561> tooltip) {
        if (Boolean.FALSE.equals(VeganNBT.getVeganFromNBT(stack))) {
            tooltip.add(1, (class_2561)class_2561.method_43470((String)"Not vegan").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true))));
        }
        if (debugMode) {
            tooltip.add(1, (class_2561)class_2561.method_43470((String)("Result: " + VeganLabels.isVegan(stack).name())));
            tooltip.add(1, (class_2561)class_2561.method_43470((String)("Default from recipes: " + String.valueOf((Object)veganFromRecipes.get(stack.method_7909())))));
            tooltip.add(1, (class_2561)class_2561.method_43470((String)("Component: " + VeganNBT.getVeganFromNBT(stack))));
        }
        if (!VeganLabels.shouldRenderTooltip(stack)) {
            return;
        }
        tooltip.add(1, (class_2561)class_2561.method_43470((String)"Vegan").method_10862(class_2583.field_24360.method_36139(35908).method_10978(Boolean.valueOf(true)).method_10982(Boolean.valueOf(true))));
    }

    private static void modifyRecipeResult(List<class_1799> recipeInput, class_1799 result) {
        boolean vegan = true;
        for (class_1799 item : recipeInput) {
            if (VeganLabels.isVegan(item) == VeganStatus.NOT_VEGAN) {
                vegan = false;
            }
            if (!item.method_31573(VeganTags.VEGAN_ALTERNATIVE) && !VeganNBT.containsSubstitute(item)) continue;
            VeganNBT.setContainsSubstitute(result);
        }
        VeganLabels.setIsVegan(result, vegan);
    }

    public static enum VeganStatus {
        VEGAN,
        NOT_VEGAN,
        UNKNOWN;


        static VeganStatus fromBoolean(@Nullable Boolean b) {
            if (b == null) {
                return UNKNOWN;
            }
            return b != false ? VEGAN : NOT_VEGAN;
        }
    }
}

