/*
 * Decompiled with CFR 0.152.
 */
package net.player005.vegandelightfabric.labels;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.player005.vegandelightfabric.VeganItems;
import org.jetbrains.annotations.ApiStatus;
import vectorwing.farmersdelight.common.registry.ModItems;

public abstract class ReplacementMap {
    private static final Multimap<Item, Item> map = MultimapBuilder.hashKeys().arrayListValues().build();
    private static final Style textStyle;
    private static final Style itemNameStyle;

    public static void registerReplacement(Item replacement, Item original) {
        map.put((Object)replacement, (Object)original);
    }

    public static Collection<Item> replaces(Item item) {
        return map.get((Object)item);
    }

    @ApiStatus.Internal
    public static void addTooltipLines(Item replacement, List<Component> tooltip) {
        Collection<Item> items = ReplacementMap.replaces(replacement);
        if (items.isEmpty()) {
            return;
        }
        MutableComponent nameList = ReplacementMap.createItemList(items);
        tooltip.add(1, (Component)Component.translatable((String)"tooltip.vegandelight.replaces", (Object[])new Object[]{nameList.setStyle(itemNameStyle)}).setStyle(textStyle));
    }

    private static MutableComponent createItemList(Collection<Item> items) {
        MutableComponent nameList = Component.empty();
        Iterator<Item> iter = items.iterator();
        nameList.append((Component)Component.translatable((String)iter.next().getDescriptionId()));
        iter.forEachRemaining(it -> nameList.append(", ").append((Component)Component.translatable((String)it.getDescriptionId())));
        return nameList;
    }

    static {
        ReplacementMap.registerReplacement((Item)VeganItems.LEATHER_SUBSTITUTE.value(), Items.LEATHER);
        ReplacementMap.registerReplacement((Item)VeganItems.SOYMILK_BUCKET.value(), Items.MILK_BUCKET);
        ReplacementMap.registerReplacement((Item)VeganItems.SOYMILK_BOTTLE.value(), (Item)ModItems.MILK_BOTTLE.get());
        ReplacementMap.registerReplacement((Item)VeganItems.SILKEN_TOFU.value(), Items.EGG);
        ReplacementMap.registerReplacement((Item)VeganItems.MINCED_TOFU.value(), (Item)ModItems.MINCED_BEEF.get());
        ReplacementMap.registerReplacement((Item)VeganItems.TOFU_PATTY.value(), (Item)ModItems.BEEF_PATTY.get());
        ReplacementMap.registerReplacement((Item)VeganItems.TOFISH.value(), Items.COD);
        ReplacementMap.registerReplacement((Item)VeganItems.SMOKED_TOFISH.value(), Items.SALMON);
        ReplacementMap.registerReplacement((Item)VeganItems.COOKED_TOFISH.value(), Items.COOKED_COD);
        ReplacementMap.registerReplacement((Item)VeganItems.COOKED_SMOKED_TOFISH.value(), Items.COOKED_SALMON);
        ReplacementMap.registerReplacement((Item)VeganItems.TOFISH_ROLL.value(), (Item)ModItems.COD_ROLL.get());
        ReplacementMap.registerReplacement((Item)VeganItems.SMOKED_TOFISH_ROLL.value(), (Item)ModItems.SALMON_ROLL.get());
        ReplacementMap.registerReplacement((Item)VeganItems.TOFU_SLICES.value(), Items.MUTTON);
        ReplacementMap.registerReplacement((Item)VeganItems.TOFU_SLICES.value(), Items.CHICKEN);
        ReplacementMap.registerReplacement((Item)VeganItems.SMOKED_TOFU_SLICES.value(), Items.PORKCHOP);
        ReplacementMap.registerReplacement((Item)VeganItems.COOKED_TOFU_SLICES.value(), Items.COOKED_MUTTON);
        ReplacementMap.registerReplacement((Item)VeganItems.COOKED_TOFU_SLICES.value(), Items.COOKED_CHICKEN);
        ReplacementMap.registerReplacement((Item)VeganItems.COOKED_SMOKED_TOFU_SLICES.value(), Items.COOKED_PORKCHOP);
        textStyle = Style.EMPTY.withColor(0x555555).withItalic(Boolean.valueOf(true));
        itemNameStyle = Style.EMPTY.withColor(0x999999).withItalic(Boolean.valueOf(true));
    }
}

