/*
 * Decompiled with CFR 0.152.
 */
package net.player005.vegandelightfabric.neoforge;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public final class VeganFluidHandler
implements IFluidHandlerItem {
    private ItemStack current;
    private final ItemStack full;
    private final Item empty;
    private final FluidStack fluidStack;
    private final FluidType type;
    private final int capacity;

    public VeganFluidHandler(ItemStack full, Item empty, boolean defaultFull, Fluid fluid, int capacity) {
        if (defaultFull) {
            this.current = full.copy();
            this.fluidStack = new FluidStack(fluid, capacity);
        } else {
            this.current = new ItemStack((ItemLike)empty);
            this.fluidStack = FluidStack.EMPTY;
        }
        this.full = full;
        this.empty = empty;
        this.type = fluid.getFluidType();
        this.capacity = capacity;
    }

    public ItemStack getContainer() {
        return this.current;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.fluidStack;
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return stack.is(this.fluidStack.getFluidType());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.current.getCount() != 1 || resource.getAmount() < this.capacity || !this.fluidStack.isEmpty() || !resource.is(this.type)) {
            return 0;
        }
        if (action.execute()) {
            this.current = this.full.copy();
        }
        return this.capacity;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.current.getCount() != 1 || resource.getAmount() < this.capacity) {
            return FluidStack.EMPTY;
        }
        if (!this.fluidStack.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)this.fluidStack, (FluidStack)resource)) {
            if (action.execute()) {
                this.current = new ItemStack((ItemLike)this.empty);
            }
            return this.fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.current.getCount() != 1 || maxDrain < this.capacity) {
            return FluidStack.EMPTY;
        }
        if (!this.fluidStack.isEmpty()) {
            if (action.execute()) {
                this.current = new ItemStack((ItemLike)this.empty);
            }
            return this.fluidStack;
        }
        return FluidStack.EMPTY;
    }
}

