/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import java.awt.Rectangle;
import java.io.IOException;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shaper.RemoteScannerTileEntity;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.blocks.shaper.ScannerTileEntity;
import mcjty.rftools.blocks.shaper.ShapeGuiTools;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import mcjty.rftools.shapes.IShapeParentGui;
import mcjty.rftools.shapes.ShapeID;
import mcjty.rftools.shapes.ShapeRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.input.Mouse;

public class GuiScanner
extends GenericGuiContainer<ScannerTileEntity>
implements IShapeParentGui {
    public static final int SCANNER_WIDTH = 256;
    public static final int SCANNER_HEIGHT = 238;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/scanner.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private EnergyBar energyBar;
    private ToggleButton showAxis;
    private ToggleButton showOuter;
    private ToggleButton showScan;
    private Button scanButton;
    private Label offsetLabel;
    private Label dimensionLabel;
    private Label progressLabel;
    private ShapeRenderer shapeRenderer = null;
    private int filterCnt = 0;

    public GuiScanner(ScannerTileEntity shaperTileEntity, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)shaperTileEntity, (Container)container, GuiProxy.GUI_MANUAL_SHAPE, "scanner");
        this.field_146999_f = 256;
        this.field_147000_g = 238;
    }

    public GuiScanner(RemoteScannerTileEntity shaperTileEntity, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)shaperTileEntity, (Container)container, GuiProxy.GUI_MANUAL_SHAPE, "remote_scanner");
        this.field_146999_f = 256;
        this.field_147000_g = 238;
    }

    private ShapeRenderer getShapeRenderer() {
        if (this.shapeRenderer == null) {
            this.shapeRenderer = new ShapeRenderer(this.getShapeID());
        }
        return this.shapeRenderer;
    }

    private ShapeID getShapeID() {
        ItemStack renderStack = ((ScannerTileEntity)this.tileEntity).getRenderStack();
        return new ShapeID(0, null, ShapeCardItem.getScanId(renderStack), false, ShapeCardItem.isSolid(renderStack));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.getShapeRenderer().initView(this.getPreviewLeft(), this.field_147009_r + 100);
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        long maxEnergyStored = ((ScannerTileEntity)this.tileEntity).getCapacity();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setHorizontal().setMaxValue(maxEnergyStored).setLayoutHint(8, 120, 70, 10)).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        toplevel.addChild((Widget)this.energyBar);
        ImageChoiceLabel redstoneMode = this.initRedstoneMode();
        toplevel.addChild((Widget)redstoneMode);
        this.showAxis = ShapeGuiTools.createAxisButton((Gui)this, toplevel, 5, 176);
        this.showOuter = ShapeGuiTools.createBoxButton((Gui)this, toplevel, 31, 176);
        this.showScan = ShapeGuiTools.createScanButton((Gui)this, toplevel, 57, 176);
        this.scanButton = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setName("scan")).setText("Scan")).setLayoutHint(5, 156, 40, 16);
        toplevel.addChild((Widget)this.scanButton);
        toplevel.addChild(((Button)new Button(this.field_146297_k, (Gui)this).setText("W")).addButtonEvent(parent -> this.move(-16, 0, 0)).setLayoutHint(4, 30, 16, 15));
        toplevel.addChild(((Button)new Button(this.field_146297_k, (Gui)this).setText("w")).addButtonEvent(parent -> this.move(-1, 0, 0)).setLayoutHint(20, 30, 16, 15));
        toplevel.addChild(((Button)new Button(this.field_146297_k, (Gui)this).setText("e")).addButtonEvent(parent -> this.move(1, 0, 0)).setLayoutHint(45, 30, 16, 15));
        toplevel.addChild(((Button)new Button(this.field_146297_k, (Gui)this).setText("E")).addButtonEvent(parent -> this.move(16, 0, 0)).setLayoutHint(61, 30, 16, 15));
        toplevel.addChild(((Button)new Button(this.field_146297_k, (Gui)this).setText("S")).addButtonEvent(parent -> this.move(0, 0, -16)).setLayoutHint(4, 50, 16, 15));
        toplevel.addChild(((Button)new Button(this.field_146297_k, (Gui)this).setText("s")).addButtonEvent(parent -> this.move(0, 0, -1)).setLayoutHint(20, 50, 16, 15));
        toplevel.addChild(((Button)new Button(this.field_146297_k, (Gui)this).setText("n")).addButtonEvent(parent -> this.move(0, 0, 1)).setLayoutHint(45, 50, 16, 15));
        toplevel.addChild(((Button)new Button(this.field_146297_k, (Gui)this).setText("N")).addButtonEvent(parent -> this.move(0, 0, 16)).setLayoutHint(61, 50, 16, 15));
        toplevel.addChild(((Button)new Button(this.field_146297_k, (Gui)this).setText("D")).addButtonEvent(parent -> this.move(0, -16, 0)).setLayoutHint(4, 70, 16, 15));
        toplevel.addChild(((Button)new Button(this.field_146297_k, (Gui)this).setText("d")).addButtonEvent(parent -> this.move(0, -1, 0)).setLayoutHint(20, 70, 16, 15));
        toplevel.addChild(((Button)new Button(this.field_146297_k, (Gui)this).setText("u")).addButtonEvent(parent -> this.move(0, 1, 0)).setLayoutHint(45, 70, 16, 15));
        toplevel.addChild(((Button)new Button(this.field_146297_k, (Gui)this).setText("U")).addButtonEvent(parent -> this.move(0, 16, 0)).setLayoutHint(61, 70, 16, 15));
        this.offsetLabel = (Label)((Label)new Label(this.field_146297_k, (Gui)this).setText("Off: " + BlockPosTools.toString((BlockPos)((ScannerTileEntity)this.tileEntity).getDataOffset()))).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.offsetLabel.setLayoutHint(4, 90, 80, 14);
        toplevel.addChild((Widget)this.offsetLabel);
        this.dimensionLabel = (Label)((Label)new Label(this.field_146297_k, (Gui)this).setText("Dim: " + BlockPosTools.toString((BlockPos)((ScannerTileEntity)this.tileEntity).getDataDim()))).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.dimensionLabel.setLayoutHint(4, 105, 80, 14);
        toplevel.addChild((Widget)this.dimensionLabel);
        this.progressLabel = (Label)new Label(this.field_146297_k, (Gui)this).setText("");
        this.progressLabel.setLayoutHint(4, 135, 80, 14);
        toplevel.addChild((Widget)this.progressLabel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.move(0, 0, 0);
        this.filterCnt = this.countFilters();
        ((ScannerTileEntity)this.tileEntity).requestRfFromServer("rftools");
        this.window.action(RFToolsMessages.INSTANCE, "scan", (GenericTileEntity)((ScannerTileEntity)this.tileEntity), "scan");
        this.window.bind(RFToolsMessages.INSTANCE, "redstone", (GenericTileEntity)((ScannerTileEntity)this.tileEntity), GenericTileEntity.VALUE_RSMODE.getName());
        this.window.bind(RFToolsMessages.INSTANCE, "offset", (GenericTileEntity)((ScannerTileEntity)this.tileEntity), ScannerTileEntity.VALUE_OFFSET.getName());
    }

    private ImageChoiceLabel initRedstoneMode() {
        ImageChoiceLabel redstoneMode = ((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setName("redstone")).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        redstoneMode.setLayoutHint(50, 156, 16, 16);
        return redstoneMode;
    }

    private int countFilters() {
        int cnt = 0;
        if (this.field_147002_h.func_75139_a(0).func_75216_d()) {
            ++cnt;
        }
        if (this.field_147002_h.func_75139_a(2).func_75216_d()) {
            ++cnt;
        }
        if (this.field_147002_h.func_75139_a(3).func_75216_d()) {
            ++cnt;
        }
        return cnt;
    }

    private void move(int x, int y, int z) {
        BlockPos offset = ((ScannerTileEntity)this.tileEntity).getDataOffset();
        int offsetX = offset.func_177958_n() + x;
        int offsetY = offset.func_177956_o() + y;
        int offsetZ = offset.func_177952_p() + z;
        ((ScannerTileEntity)this.tileEntity).valueToServer(this.network, ScannerTileEntity.VALUE_OFFSET, new BlockPos(offsetX, offsetY, offsetZ));
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.getShapeRenderer().handleShapeDragging(x -= this.field_147003_i, y -= this.field_147009_r);
    }

    @Override
    public int getPreviewLeft() {
        return this.getGuiLeft();
    }

    @Override
    public int getPreviewTop() {
        return this.getGuiTop();
    }

    protected void func_146976_a(float v, int x, int y) {
        this.getShapeRenderer().handleMouseWheel();
        this.offsetLabel.setText("Off: " + BlockPosTools.toString((BlockPos)((ScannerTileEntity)this.tileEntity).getDataOffset()));
        this.dimensionLabel.setText("Dim: " + BlockPosTools.toString((BlockPos)((ScannerTileEntity)this.tileEntity).getDataDim()));
        this.drawWindow();
        long currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((ScannerTileEntity)this.tileEntity).requestRfFromServer("rftools");
        boolean instack = this.field_147002_h.func_75139_a(0).func_75216_d();
        if (currentRF < (long)ScannerConfiguration.SCANNER_PERTICK.get()) {
            instack = false;
        }
        if (((ScannerTileEntity)this.tileEntity).getScanProgress() >= 0) {
            instack = false;
            this.progressLabel.setText(((ScannerTileEntity)this.tileEntity).getScanProgress() + "%");
        } else {
            this.progressLabel.setText("");
        }
        this.scanButton.setEnabled(instack);
        ItemStack stack = ((ScannerTileEntity)this.tileEntity).getRenderStack();
        if (!stack.func_190926_b()) {
            int cnt = this.countFilters();
            if (cnt != this.filterCnt) {
                this.filterCnt = cnt;
                this.move(0, 0, 0);
            }
            this.getShapeRenderer().setShapeID(this.getShapeID());
            this.getShapeRenderer().renderShape(this, stack, this.field_147003_i, this.field_147009_r, this.showAxis.isPressed(), this.showOuter.isPressed(), this.showScan.isPressed(), false);
        }
    }
}

