/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storagemonitor.PacketReturnInventoryInfo;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetInventoryInfo
implements IMessage {
    private int id;
    private BlockPos pos;
    private boolean doscan;

    public void fromBytes(ByteBuf byteBuf) {
        this.pos = NetworkTools.readPos((ByteBuf)byteBuf);
        this.id = byteBuf.readInt();
        this.doscan = byteBuf.readBoolean();
    }

    public void toBytes(ByteBuf byteBuf) {
        NetworkTools.writePos((ByteBuf)byteBuf, (BlockPos)this.pos);
        byteBuf.writeInt(this.id);
        byteBuf.writeBoolean(this.doscan);
    }

    public PacketGetInventoryInfo() {
    }

    public PacketGetInventoryInfo(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetInventoryInfo(int worldId, BlockPos pos, boolean doscan) {
        this.id = worldId;
        this.pos = pos;
        this.doscan = doscan;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> this.onMessageServer(ctx.getSender()).ifPresent(p -> this.sendReplyToClient((List<PacketReturnInventoryInfo.InventoryInfo>)p, ctx.getSender())));
        ctx.setPacketHandled(true);
    }

    private void sendReplyToClient(List<PacketReturnInventoryInfo.InventoryInfo> reply, EntityPlayerMP player) {
        PacketReturnInventoryInfo msg = new PacketReturnInventoryInfo(reply);
        RFToolsMessages.INSTANCE.sendTo((IMessage)msg, player);
    }

    private Optional<List<PacketReturnInventoryInfo.InventoryInfo>> onMessageServer(EntityPlayerMP entityPlayerMP) {
        WorldServer world = DimensionManager.getWorld((int)this.id);
        if (world == null) {
            return Optional.empty();
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)this.pos)) {
            return Optional.empty();
        }
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof StorageScannerTileEntity) {
            StorageScannerTileEntity scannerTileEntity = (StorageScannerTileEntity)te;
            Stream<BlockPos> inventories = this.doscan ? scannerTileEntity.findInventories() : scannerTileEntity.getAllInventories();
            List invs = inventories.map(arg_0 -> PacketGetInventoryInfo.lambda$onMessageServer$2((World)world, scannerTileEntity, arg_0)).collect(Collectors.toList());
            return Optional.of(invs);
        }
        return Optional.empty();
    }

    private static PacketReturnInventoryInfo.InventoryInfo toInventoryInfo(World world, BlockPos pos, StorageScannerTileEntity te) {
        String displayName;
        ItemStack stack = ItemStack.field_190927_a;
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)pos)) {
            displayName = "[UNLOADED]";
        } else if (world.func_175623_d(pos)) {
            displayName = "[REMOVED]";
        } else {
            ModularStorageTileEntity storageTileEntity;
            ItemStack storageModule;
            IBlockState state = world.func_180495_p(pos);
            stack = state.func_177230_c().func_185473_a(world, pos, state);
            displayName = stack.func_82833_r();
            TileEntity storageTe = world.func_175625_s(pos);
            if (storageTe instanceof ModularStorageTileEntity && !(storageModule = (storageTileEntity = (ModularStorageTileEntity)storageTe).func_70301_a(0)).func_190926_b() && storageModule.func_77978_p().func_74764_b("display")) {
                displayName = storageModule.func_82833_r();
            }
        }
        return new PacketReturnInventoryInfo.InventoryInfo(pos, displayName, te.isRoutable(pos), stack);
    }

    private static /* synthetic */ PacketReturnInventoryInfo.InventoryInfo lambda$onMessageServer$2(World world, StorageScannerTileEntity scannerTileEntity, BlockPos pos) {
        return PacketGetInventoryInfo.toInventoryInfo(world, pos, scannerTileEntity);
    }
}

