/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.blockprotector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftools.blocks.blockprotector.BlockProtectorTileEntity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockProtectors
extends AbstractWorldData<BlockProtectors> {
    public static final String PROTECTORS_NAME = "RFToolsBlockProtectors";
    private final Map<Integer, GlobalCoordinate> protectorById = new HashMap<Integer, GlobalCoordinate>();
    private final Map<GlobalCoordinate, Integer> protectorIdByCoordinate = new HashMap<GlobalCoordinate, Integer>();
    private int lastId = 0;

    public BlockProtectors(String name) {
        super(name);
    }

    public void clear() {
        this.protectorById.clear();
        this.protectorIdByCoordinate.clear();
        this.lastId = 0;
    }

    public static Collection<GlobalCoordinate> getProtectors(World world, int x, int y, int z) {
        if (world.isRemote) {
            return Collections.emptyList();
        }
        BlockProtectors blockProtectors = BlockProtectors.getProtectors(world);
        return blockProtectors.findProtectors(x, y, z, world.provider.getDimension(), 2);
    }

    public static boolean checkHarvestProtection(int x, int y, int z, IBlockAccess world, Collection<GlobalCoordinate> protectors) {
        for (GlobalCoordinate protector : protectors) {
            BlockPos relative;
            BlockProtectorTileEntity blockProtectorTileEntity;
            boolean b;
            TileEntity te = world.getTileEntity(protector.getCoordinate());
            if (!(te instanceof BlockProtectorTileEntity) || !(b = (blockProtectorTileEntity = (BlockProtectorTileEntity)te).isProtected(relative = blockProtectorTileEntity.absoluteToRelative(x, y, z)))) continue;
            if (blockProtectorTileEntity.attemptHarvestProtection()) {
                return true;
            }
            blockProtectorTileEntity.removeProtection(relative);
        }
        return false;
    }

    public static BlockProtectors getProtectors(World world) {
        return (BlockProtectors)AbstractWorldData.getData((World)world, BlockProtectors.class, (String)PROTECTORS_NAME);
    }

    public void assignId(GlobalCoordinate key, int id) {
        this.protectorById.put(id, key);
        this.protectorIdByCoordinate.put(key, id);
    }

    public int getNewId(GlobalCoordinate key) {
        if (this.protectorIdByCoordinate.containsKey(key)) {
            return this.protectorIdByCoordinate.get(key);
        }
        ++this.lastId;
        this.protectorById.put(this.lastId, key);
        this.protectorIdByCoordinate.put(key, this.lastId);
        return this.lastId;
    }

    public Integer getIdForCoordinate(GlobalCoordinate key) {
        return this.protectorIdByCoordinate.get(key);
    }

    public GlobalCoordinate getCoordinateForId(int id) {
        return this.protectorById.get(id);
    }

    public void removeDestination(BlockPos coordinate, int dimension) {
        GlobalCoordinate key = new GlobalCoordinate(coordinate, dimension);
        Integer id = this.protectorIdByCoordinate.get(key);
        if (id != null) {
            this.protectorById.remove(id);
            this.protectorIdByCoordinate.remove(key);
        }
    }

    public Collection<GlobalCoordinate> findProtectors(int x, int y, int z, int dimension, int radius) {
        ArrayList<GlobalCoordinate> protectors = new ArrayList<GlobalCoordinate>();
        for (GlobalCoordinate coordinate : this.protectorIdByCoordinate.keySet()) {
            BlockPos c;
            if (coordinate.getDimension() != dimension || Math.abs(x - (c = coordinate.getCoordinate()).getX()) > 16 + radius + 1 || Math.abs(y - c.getY()) > 16 + radius + 1 || Math.abs(z - c.getZ()) > 16 + radius + 1) continue;
            protectors.add(coordinate);
        }
        return protectors;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.protectorById.clear();
        this.protectorIdByCoordinate.clear();
        this.lastId = tagCompound.getInteger("lastId");
        this.readDestinationsFromNBT(tagCompound);
    }

    private void readDestinationsFromNBT(NBTTagCompound tagCompound) {
        NBTTagList lst = tagCompound.getTagList("blocks", 10);
        for (int i = 0; i < lst.tagCount(); ++i) {
            NBTTagCompound tc = lst.getCompoundTagAt(i);
            BlockPos c = new BlockPos(tc.getInteger("x"), tc.getInteger("y"), tc.getInteger("z"));
            int dim = tc.getInteger("dim");
            GlobalCoordinate gc = new GlobalCoordinate(c, dim);
            int id = tc.getInteger("id");
            this.protectorById.put(id, gc);
            this.protectorIdByCoordinate.put(gc, id);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (GlobalCoordinate destination : this.protectorIdByCoordinate.keySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            BlockPos c = destination.getCoordinate();
            tc.setInteger("x", c.getX());
            tc.setInteger("y", c.getY());
            tc.setInteger("z", c.getZ());
            tc.setInteger("dim", destination.getDimension());
            Integer id = this.protectorIdByCoordinate.get(new GlobalCoordinate(c, destination.getDimension()));
            tc.setInteger("id", id.intValue());
            lst.appendTag((NBTBase)tc);
        }
        tagCompound.setTag("blocks", (NBTBase)lst);
        tagCompound.setInteger("lastId", this.lastId);
        return tagCompound;
    }
}

