/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IAction;
import mcjty.lib.bindings.IValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Broadcaster;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleSupport;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.ClientCommandHandler;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.BuilderTileEntityMode;
import mcjty.rftools.blocks.builder.SpaceChamberRepository;
import mcjty.rftools.blocks.builder.SupportBlock;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.hud.IHudSupport;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.items.builder.ShapeCardType;
import mcjty.rftools.items.storage.StorageFilterCache;
import mcjty.rftools.items.storage.StorageFilterItem;
import mcjty.rftools.network.PacketGetHudLog;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.ModSetup;
import mcjty.rftools.shapes.Shape;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public class BuilderTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable,
IHudSupport {
    public static final String CMD_SETMODE = "builder.setMode";
    public static final String CMD_SETROTATE = "builder.setRotate";
    public static final String CMD_SETANCHOR = "builder.setAnchor";
    public static final Key<Integer> PARAM_ANCHOR_INDEX = new Key("anchorIndex", Type.INTEGER);
    public static final String CMD_GETLEVEL = "getLevel";
    public static final Key<Integer> PARAM_LEVEL = new Key("level", Type.INTEGER);
    public static final int SLOT_TAB = 0;
    public static final int SLOT_FILTER = 1;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(new ResourceLocation("rftools", "gui/builder.gui"));
    public static final ModuleSupport MODULE_SUPPORT = new ModuleSupport(0){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.getItem() == BuilderSetup.shapeCardItem || itemStack.getItem() == BuilderSetup.spaceChamberCardItem;
        }
    };
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 2);
    public static final int MODE_COPY = 0;
    public static final int MODE_MOVE = 1;
    public static final int MODE_SWAP = 2;
    public static final int MODE_BACK = 3;
    public static final int MODE_COLLECT = 4;
    public static final String[] MODES = new String[]{"Copy", "Move", "Swap", "Back", "Collect"};
    public static final String ROTATE_0 = "0";
    public static final String ROTATE_90 = "90";
    public static final String ROTATE_180 = "180";
    public static final String ROTATE_270 = "270";
    public static final int ANCHOR_SW = 0;
    public static final int ANCHOR_SE = 1;
    public static final int ANCHOR_NW = 2;
    public static final int ANCHOR_NE = 3;
    private String lastError = null;
    private int mode = 0;
    private int rotate = 0;
    private int anchor = 0;
    private boolean silent = false;
    private boolean supportMode = false;
    private boolean entityMode = false;
    private boolean loopMode = false;
    private boolean waitMode = true;
    private boolean hilightMode = false;
    private static int currentLevel = 0;
    private int scanLocCnt = 0;
    private static Map<BlockPos, Pair<Long, BlockPos>> scanLocClient = new HashMap<BlockPos, Pair<Long, BlockPos>>();
    private int collectCounter = BuilderConfiguration.collectTimer.get();
    private int collectXP = 0;
    private boolean boxValid = false;
    private BlockPos minBox = null;
    private BlockPos maxBox = null;
    private BlockPos scan = null;
    private int projDx;
    private int projDy;
    private int projDz;
    private long lastHudTime = 0L;
    private List<String> clientHudLog = new ArrayList<String>();
    private ShapeCardType cardType = ShapeCardType.CARD_UNKNOWN;
    private StorageFilterCache filterCache = null;
    private ForgeChunkManager.Ticket ticket = null;
    private ChunkPos forcedChunk = null;
    private Map<BlockPos, IBlockState> cachedBlocks = null;
    private ChunkPos cachedChunk = null;
    private Set<Block> cachedVoidableBlocks = null;
    private List<ItemStack> overflowItems = null;
    private FakePlayer harvester = null;
    public static final Key<Boolean> VALUE_WAIT = new Key("wait", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_LOOP = new Key("loop", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_HILIGHT = new Key("hilight", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_SUPPORT = new Key("support", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_SILENT = new Key("silent", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_ENTITIES = new Key("entities", Type.BOOLEAN);
    private static Random random = new Random();
    private static long lastTime = 0L;

    public BuilderTileEntity() {
        super((long)BuilderConfiguration.BUILDER_MAXENERGY.get(), (long)BuilderConfiguration.BUILDER_RECEIVEPERTICK.get());
        this.setRSMode(RedstoneMode.REDSTONE_ONREQUIRED);
    }

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_RSMODE, () -> ((BuilderTileEntity)this).getRSModeInt(), arg_0 -> ((BuilderTileEntity)this).setRSModeInt(arg_0)), new DefaultValue(VALUE_WAIT, this::isWaitMode, this::setWaitMode), new DefaultValue(VALUE_LOOP, this::hasLoopMode, this::setLoopMode), new DefaultValue(VALUE_HILIGHT, this::isHilightMode, this::setHilightMode), new DefaultValue(VALUE_SUPPORT, this::hasSupportMode, this::setSupportMode), new DefaultValue(VALUE_SILENT, this::isSilent, this::setSilent), new DefaultValue(VALUE_ENTITIES, this::hasEntityMode, this::setEntityMode)};
    }

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction("restart", this::restartScan)};
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    private FakePlayer getHarvester() {
        if (this.harvester == null) {
            this.harvester = FakePlayerFactory.get((WorldServer)((WorldServer)this.world), (GameProfile)new GameProfile(UUID.nameUUIDFromBytes("rftools_builder".getBytes()), "rftools_builder"));
        }
        this.harvester.setWorld(this.world);
        this.harvester.setPosition((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ());
        return this.harvester;
    }

    @Override
    public EnumFacing getBlockOrientation() {
        IBlockState state = this.world.getBlockState(this.pos);
        if (state.getBlock() == BuilderSetup.builderBlock) {
            return OrientationTools.getOrientationHoriz((IBlockState)state);
        }
        return null;
    }

    @Override
    public boolean isBlockAboveAir() {
        return this.getWorld().isAirBlock(this.pos.up());
    }

    @Override
    public List<String> getClientLog() {
        return this.clientHudLog;
    }

    public List<String> getHudLog() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TextFormatting.BLUE + "Mode:");
        if (this.isShapeCard()) {
            this.getCardType().addHudLog(list, this.inventoryHelper);
        } else {
            list.add("    Space card: " + (new String[]{"copy", "move", "swap", "back", "collect"})[this.mode]);
        }
        if (this.scan != null) {
            list.add(TextFormatting.BLUE + "Progress:");
            list.add("    Y level: " + this.scan.getY());
            int minChunkX = this.minBox.getX() >> 4;
            int minChunkZ = this.minBox.getZ() >> 4;
            int maxChunkX = this.maxBox.getX() >> 4;
            int maxChunkZ = this.maxBox.getZ() >> 4;
            int curX = this.scan.getX() >> 4;
            int curZ = this.scan.getZ() >> 4;
            int totChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
            int curChunk = (curZ - minChunkZ) * (maxChunkX - minChunkX) + curX - minChunkX;
            list.add("    Chunk:  " + curChunk + " of " + totChunks);
        }
        if (this.lastError != null && !this.lastError.isEmpty()) {
            String[] errors;
            for (String error : errors = StringUtils.split((String)this.lastError, (String)"\n")) {
                list.add(TextFormatting.RED + error);
            }
        }
        return list;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.getPos();
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastHudTime;
    }

    @Override
    public void setLastUpdateTime(long t) {
        this.lastHudTime = t;
    }

    private boolean isShapeCard() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack.isEmpty()) {
            return false;
        }
        return itemStack.getItem() == BuilderSetup.shapeCardItem;
    }

    private NBTTagCompound hasCard() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack.isEmpty()) {
            return null;
        }
        return itemStack.getTagCompound();
    }

    private void makeSupportBlocksShaped() {
        ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, BuilderConfiguration.maxBuilderDimension.get());
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, BuilderConfiguration.maxBuilderOffset.get());
        Shape shape = ShapeCardItem.getShape(shapeCard);
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        ShapeCardItem.composeFormula(shapeCard, shape.getFormulaFactory().get(), this.world, this.getPos(), dimension, offset, blocks, BuilderConfiguration.maxBuilderDimension.get() * 256 * BuilderConfiguration.maxBuilderDimension.get(), false, false, null);
        IBlockState state = BuilderSetup.supportBlock.getDefaultState().withProperty((IProperty)SupportBlock.STATUS, (Comparable)Integer.valueOf(0));
        for (Map.Entry entry : blocks.entrySet()) {
            BlockPos p = (BlockPos)entry.getKey();
            if (!this.world.isAirBlock(p)) continue;
            this.world.setBlockState(p, state, 2);
        }
    }

    private void makeSupportBlocks() {
        if (this.isShapeCard()) {
            this.makeSupportBlocksShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel != null) {
            int dimension = chamberChannel.getDimension();
            WorldServer world = DimensionManager.getWorld((int)dimension);
            if (world == null) {
                return;
            }
            BlockPos.MutableBlockPos src = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos dest = new BlockPos.MutableBlockPos();
            for (int x = this.minBox.getX(); x <= this.maxBox.getX(); ++x) {
                for (int y = this.minBox.getY(); y <= this.maxBox.getY(); ++y) {
                    for (int z = this.minBox.getZ(); z <= this.maxBox.getZ(); ++z) {
                        src.setPos(x, y, z);
                        this.sourceToDest((BlockPos)src, dest);
                        IBlockState srcState = world.getBlockState((BlockPos)src);
                        Block srcBlock = srcState.getBlock();
                        IBlockState dstState = world.getBlockState((BlockPos)dest);
                        Block dstBlock = dstState.getBlock();
                        int error = 0;
                        if (this.mode != 0) {
                            TileEntity srcTileEntity = world.getTileEntity((BlockPos)src);
                            TileEntity dstTileEntity = this.getWorld().getTileEntity((BlockPos)dest);
                            int error1 = this.isMovable((World)world, (BlockPos)src, srcBlock, srcTileEntity);
                            int error2 = this.isMovable(this.getWorld(), (BlockPos)dest, dstBlock, dstTileEntity);
                            error = Math.max(error1, error2);
                        }
                        if (BuilderTileEntity.isEmpty(srcState, srcBlock) && !BuilderTileEntity.isEmpty(dstState, dstBlock)) {
                            this.getWorld().setBlockState((BlockPos)src, BuilderSetup.supportBlock.getDefaultState().withProperty((IProperty)SupportBlock.STATUS, (Comparable)Integer.valueOf(error)), 3);
                        }
                        if (!BuilderTileEntity.isEmpty(dstState, dstBlock) || BuilderTileEntity.isEmpty(srcState, srcBlock)) continue;
                        this.getWorld().setBlockState((BlockPos)dest, BuilderSetup.supportBlock.getDefaultState().withProperty((IProperty)SupportBlock.STATUS, (Comparable)Integer.valueOf(error)), 3);
                    }
                }
            }
        }
    }

    private void clearSupportBlocksShaped() {
        ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, BuilderConfiguration.maxBuilderDimension.get());
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, BuilderConfiguration.maxBuilderOffset.get());
        Shape shape = ShapeCardItem.getShape(shapeCard);
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        ShapeCardItem.composeFormula(shapeCard, shape.getFormulaFactory().get(), this.world, this.getPos(), dimension, offset, blocks, BuilderConfiguration.maxSpaceChamberDimension.get() * BuilderConfiguration.maxSpaceChamberDimension.get() * BuilderConfiguration.maxSpaceChamberDimension.get(), false, false, null);
        for (Map.Entry entry : blocks.entrySet()) {
            BlockPos p = (BlockPos)entry.getKey();
            if (this.world.getBlockState(p).getBlock() != BuilderSetup.supportBlock) continue;
            this.world.setBlockToAir(p);
        }
    }

    public void clearSupportBlocks() {
        if (this.getWorld().isRemote) {
            return;
        }
        if (this.isShapeCard()) {
            this.clearSupportBlocksShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel != null) {
            int dimension = chamberChannel.getDimension();
            WorldServer world = DimensionManager.getWorld((int)dimension);
            BlockPos.MutableBlockPos src = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos dest = new BlockPos.MutableBlockPos();
            for (int x = this.minBox.getX(); x <= this.maxBox.getX(); ++x) {
                for (int y = this.minBox.getY(); y <= this.maxBox.getY(); ++y) {
                    for (int z = this.minBox.getZ(); z <= this.maxBox.getZ(); ++z) {
                        Block srcBlock;
                        src.setPos(x, y, z);
                        if (world != null && (srcBlock = world.getBlockState((BlockPos)src).getBlock()) == BuilderSetup.supportBlock) {
                            world.setBlockToAir((BlockPos)src);
                        }
                        this.sourceToDest((BlockPos)src, dest);
                        Block dstBlock = this.getWorld().getBlockState((BlockPos)dest).getBlock();
                        if (dstBlock != BuilderSetup.supportBlock) continue;
                        this.getWorld().setBlockToAir((BlockPos)dest);
                    }
                }
            }
        }
    }

    public boolean isHilightMode() {
        return this.hilightMode;
    }

    public void setHilightMode(boolean hilightMode) {
        this.hilightMode = hilightMode;
    }

    public boolean isWaitMode() {
        return this.waitMode;
    }

    public void setWaitMode(boolean waitMode) {
        this.waitMode = waitMode;
        this.markDirtyClient();
    }

    private boolean waitOrSkip(String error) {
        if (this.waitMode) {
            this.lastError = error;
        }
        return this.waitMode;
    }

    private boolean skip() {
        this.lastError = null;
        return false;
    }

    public boolean suspend(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        this.lastError = null;
        return true;
    }

    private boolean suspend(String error) {
        this.lastError = error;
        return true;
    }

    public boolean hasLoopMode() {
        return this.loopMode;
    }

    public void setLoopMode(boolean loopMode) {
        this.loopMode = loopMode;
        this.markDirtyClient();
    }

    public boolean hasEntityMode() {
        return this.entityMode;
    }

    public void setEntityMode(boolean entityMode) {
        this.entityMode = entityMode;
        this.markDirtyClient();
    }

    public boolean hasSupportMode() {
        return this.supportMode;
    }

    public void setSupportMode(boolean supportMode) {
        this.supportMode = supportMode;
        if (supportMode) {
            this.makeSupportBlocks();
        } else {
            this.clearSupportBlocks();
        }
        this.markDirtyClient();
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
        this.markDirtyClient();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode != this.mode) {
            this.mode = mode;
            this.restartScan();
            this.markDirtyClient();
        }
    }

    public void resetBox() {
        this.boxValid = false;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int anchor) {
        if (this.supportMode) {
            this.clearSupportBlocks();
        }
        this.boxValid = false;
        this.anchor = anchor;
        if (this.isShapeCard()) {
            ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
            BlockPos dimension = ShapeCardItem.getDimension(shapeCard);
            BlockPos minBox = this.positionBox(dimension);
            int dx = dimension.getX();
            int dy = dimension.getY();
            int dz = dimension.getZ();
            BlockPos offset = new BlockPos(minBox.getX() + (int)Math.ceil(dx / 2), minBox.getY() + (int)Math.ceil(dy / 2), minBox.getZ() + (int)Math.ceil(dz / 2));
            ShapeCardItem.setOffset(shapeCard, offset.getX(), offset.getY(), offset.getZ());
        }
        if (this.supportMode) {
            this.makeSupportBlocks();
        }
        this.markDirtyClient();
    }

    private BlockPos positionBox(BlockPos dimension) {
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        EnumFacing direction = (EnumFacing)state.getValue((IProperty)BaseBlock.FACING_HORIZ);
        int spanX = dimension.getX();
        int spanY = dimension.getY();
        int spanZ = dimension.getZ();
        int x = 0;
        int z = 0;
        int y = -(this.anchor == 3 || this.anchor == 2 ? spanY - 1 : 0);
        switch (direction) {
            case SOUTH: {
                x = -(this.anchor == 3 || this.anchor == 1 ? spanX - 1 : 0);
                z = -spanZ;
                break;
            }
            case NORTH: {
                x = 1 - spanX + (this.anchor == 3 || this.anchor == 1 ? spanX - 1 : 0);
                z = 1;
                break;
            }
            case WEST: {
                x = 1;
                z = -(this.anchor == 3 || this.anchor == 1 ? spanZ - 1 : 0);
                break;
            }
            case EAST: {
                x = -spanX;
                z = -(this.anchor == 3 || this.anchor == 1 ? 0 : spanZ - 1);
                break;
            }
        }
        return new BlockPos(x, y, z);
    }

    public int getRotate() {
        return this.rotate;
    }

    public void setRotate(int rotate) {
        if (this.supportMode) {
            this.clearSupportBlocks();
        }
        this.boxValid = false;
        this.rotate = rotate;
        if (this.supportMode) {
            this.makeSupportBlocks();
        }
        this.markDirtyClient();
    }

    public void setPowerInput(int powered) {
        boolean o = this.isMachineEnabled();
        super.setPowerInput(powered);
        boolean n = this.isMachineEnabled();
        if (o != n && (this.loopMode || n && this.scan == null)) {
            this.restartScan();
        }
    }

    private void createProjection(SpaceChamberRepository.SpaceChamberChannel chamberChannel) {
        BlockPos minC = this.rotate(chamberChannel.getMinCorner());
        BlockPos maxC = this.rotate(chamberChannel.getMaxCorner());
        BlockPos minCorner = new BlockPos(Math.min(minC.getX(), maxC.getX()), Math.min(minC.getY(), maxC.getY()), Math.min(minC.getZ(), maxC.getZ()));
        BlockPos maxCorner = new BlockPos(Math.max(minC.getX(), maxC.getX()), Math.max(minC.getY(), maxC.getY()), Math.max(minC.getZ(), maxC.getZ()));
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        EnumFacing direction = (EnumFacing)state.getValue((IProperty)BaseBlock.FACING_HORIZ);
        int xCoord = this.getPos().getX();
        int yCoord = this.getPos().getY();
        int zCoord = this.getPos().getZ();
        int spanX = maxCorner.getX() - minCorner.getX();
        int spanY = maxCorner.getY() - minCorner.getY();
        int spanZ = maxCorner.getZ() - minCorner.getZ();
        switch (direction) {
            case SOUTH: {
                this.projDx = xCoord + EnumFacing.NORTH.getDirectionVec().getX() - minCorner.getX() - (this.anchor == 3 || this.anchor == 1 ? spanX : 0);
                this.projDz = zCoord + EnumFacing.NORTH.getDirectionVec().getZ() - minCorner.getZ() - spanZ;
                break;
            }
            case NORTH: {
                this.projDx = xCoord + EnumFacing.SOUTH.getDirectionVec().getX() - minCorner.getX() - spanX + (this.anchor == 3 || this.anchor == 1 ? spanX : 0);
                this.projDz = zCoord + EnumFacing.SOUTH.getDirectionVec().getZ() - minCorner.getZ();
                break;
            }
            case WEST: {
                this.projDx = xCoord + EnumFacing.EAST.getDirectionVec().getX() - minCorner.getX();
                this.projDz = zCoord + EnumFacing.EAST.getDirectionVec().getZ() - minCorner.getZ() - (this.anchor == 3 || this.anchor == 1 ? spanZ : 0);
                break;
            }
            case EAST: {
                this.projDx = xCoord + EnumFacing.WEST.getDirectionVec().getX() - minCorner.getX() - spanX;
                this.projDz = zCoord + EnumFacing.WEST.getDirectionVec().getZ() - minCorner.getZ() - spanZ + (this.anchor == 3 || this.anchor == 1 ? spanZ : 0);
                break;
            }
        }
        this.projDy = yCoord - minCorner.getY() - (this.anchor == 3 || this.anchor == 2 ? spanY : 0);
    }

    private void calculateBox(NBTTagCompound cardCompound) {
        int channel = cardCompound.getInteger("channel");
        SpaceChamberRepository repository = SpaceChamberRepository.getChannels(this.getWorld());
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        BlockPos minCorner = chamberChannel.getMinCorner();
        BlockPos maxCorner = chamberChannel.getMaxCorner();
        if (minCorner == null || maxCorner == null) {
            return;
        }
        if (this.boxValid && minCorner.equals((Object)this.minBox) && maxCorner.equals((Object)this.maxBox)) {
            return;
        }
        this.boxValid = true;
        this.cardType = ShapeCardType.CARD_SPACE;
        this.createProjection(chamberChannel);
        this.minBox = minCorner;
        this.maxBox = maxCorner;
        this.restartScan();
    }

    private void checkStateServerShaped() {
        float factor = this.getInfusedFactor();
        int i = 0;
        while ((float)i < (float)BuilderConfiguration.quarryBaseSpeed.get() + factor * (float)BuilderConfiguration.quarryInfusionSpeedFactor.get()) {
            if (this.scan != null) {
                this.handleBlockShaped();
            }
            ++i;
        }
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.overflowItems != null && this.insertItems(this.overflowItems)) {
            this.overflowItems = null;
        }
        if (!this.isMachineEnabled() && this.loopMode) {
            return;
        }
        if (this.scan == null) {
            return;
        }
        if (this.isHilightMode()) {
            this.updateHilight();
        }
        if (this.isShapeCard()) {
            if (!this.isMachineEnabled()) {
                this.chunkUnload();
                return;
            }
            this.checkStateServerShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel == null) {
            this.scan = null;
            this.markDirty();
            return;
        }
        int dimension = chamberChannel.getDimension();
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            return;
        }
        if (this.mode == 4) {
            this.collectItems((World)world);
        } else {
            float factor = this.getInfusedFactor();
            int i = 0;
            while ((float)i < 2.0f + factor * 40.0f) {
                if (this.scan != null) {
                    this.handleBlock((World)world);
                }
                ++i;
            }
        }
    }

    public List<ItemStack> getOverflowItems() {
        return this.overflowItems;
    }

    private void updateHilight() {
        --this.scanLocCnt;
        if (this.scanLocCnt <= 0) {
            this.scanLocCnt = 5;
            int x = this.scan.getX();
            int y = this.scan.getY();
            int z = this.scan.getZ();
            double sqradius = 900.0;
            for (EntityPlayerMP player : this.getWorld().getMinecraftServer().getPlayerList().getPlayers()) {
                double d2;
                double d1;
                double d0;
                if (player.dimension != this.getWorld().provider.getDimension() || !((d0 = (double)x - player.posX) * d0 + (d1 = (double)y - player.posY) * d1 + (d2 = (double)z - player.posZ) * d2 < sqradius)) continue;
                RFToolsMessages.sendToClient((EntityPlayer)player, "positionToClient", TypedMap.builder().put(ClientCommandHandler.PARAM_POS, (Object)this.getPos()).put(ClientCommandHandler.PARAM_SCAN, (Object)this.scan));
            }
        }
    }

    private void collectItems(World world) {
        --this.collectCounter;
        if (this.collectCounter > 0) {
            return;
        }
        this.collectCounter = BuilderConfiguration.collectTimer.get();
        if (!this.loopMode) {
            this.scan = null;
        }
        long rf = this.getStoredPower();
        float area = (this.maxBox.getX() - this.minBox.getX() + 1) * (this.maxBox.getY() - this.minBox.getY() + 1) * (this.maxBox.getZ() - this.minBox.getZ() + 1);
        float infusedFactor = (4.0f - this.getInfusedFactor()) / 4.0f;
        int rfNeeded = (int)(BuilderConfiguration.collectRFPerTickPerArea.get() * (double)area * (double)infusedFactor) * BuilderConfiguration.collectTimer.get();
        if ((long)rfNeeded > rf) {
            return;
        }
        this.consumeEnergy(rfNeeded);
        AxisAlignedBB bb = new AxisAlignedBB((double)this.minBox.getX() - 0.8, (double)this.minBox.getY() - 0.8, (double)this.minBox.getZ() - 0.8, (double)this.maxBox.getX() + 0.8, (double)this.maxBox.getY() + 0.8, (double)this.maxBox.getZ() + 0.8);
        List items = world.getEntitiesWithinAABB(Entity.class, bb);
        for (Entity entity : items) {
            if (!(entity instanceof EntityItem ? this.collectItem(world, infusedFactor, (EntityItem)entity) : entity instanceof EntityXPOrb && this.collectXP(world, infusedFactor, (EntityXPOrb)entity))) continue;
            return;
        }
    }

    private boolean collectXP(World world, float infusedFactor, EntityXPOrb orb) {
        int xp = orb.getXpValue();
        long rf = this.getStoredPower();
        int rfNeeded = (int)(BuilderConfiguration.collectRFPerXP.get() * (double)infusedFactor * (double)xp);
        if ((long)rfNeeded > rf) {
            return true;
        }
        this.collectXP += xp;
        int bottles = this.collectXP / 7;
        if (bottles > 0) {
            if (this.insertItem(new ItemStack(Items.EXPERIENCE_BOTTLE, bottles)).isEmpty()) {
                this.collectXP %= 7;
                world.removeEntity((Entity)orb);
                this.consumeEnergy(rfNeeded);
            } else {
                this.collectXP = 0;
            }
        }
        return false;
    }

    private boolean collectItem(World world, float infusedFactor, EntityItem item) {
        ItemStack stack = item.getItem();
        long rf = this.getStoredPower();
        int rfNeeded = (int)((float)BuilderConfiguration.collectRFPerItem.get() * infusedFactor) * stack.getCount();
        if ((long)rfNeeded > rf) {
            return true;
        }
        this.consumeEnergy(rfNeeded);
        world.removeEntity((Entity)item);
        stack = this.insertItem(stack);
        if (!stack.isEmpty()) {
            BlockPos position = item.getPosition();
            EntityItem entityItem = new EntityItem(this.getWorld(), (double)position.getX(), (double)position.getY(), (double)position.getZ(), stack);
            this.getWorld().spawnEntity((Entity)entityItem);
        }
        return false;
    }

    private void calculateBoxShaped() {
        ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
        if (shapeCard.isEmpty()) {
            return;
        }
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, BuilderConfiguration.maxBuilderDimension.get());
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, BuilderConfiguration.maxBuilderOffset.get());
        BlockPos minCorner = ShapeCardItem.getMinCorner(this.getPos(), dimension, offset);
        BlockPos maxCorner = ShapeCardItem.getMaxCorner(this.getPos(), dimension, offset);
        if (minCorner.getY() < 0) {
            minCorner = new BlockPos(minCorner.getX(), 0, minCorner.getZ());
        } else if (minCorner.getY() > 255) {
            minCorner = new BlockPos(minCorner.getX(), 255, minCorner.getZ());
        }
        if (maxCorner.getY() < 0) {
            maxCorner = new BlockPos(maxCorner.getX(), 0, maxCorner.getZ());
        } else if (maxCorner.getY() > 255) {
            maxCorner = new BlockPos(maxCorner.getX(), 255, maxCorner.getZ());
        }
        if (this.boxValid && minCorner.equals((Object)this.minBox) && maxCorner.equals((Object)this.maxBox)) {
            return;
        }
        this.boxValid = true;
        this.cardType = ShapeCardType.fromDamage(shapeCard.getItemDamage());
        this.cachedBlocks = null;
        this.cachedChunk = null;
        this.cachedVoidableBlocks = null;
        this.minBox = minCorner;
        this.maxBox = maxCorner;
        this.restartScan();
    }

    private SpaceChamberRepository.SpaceChamberChannel calculateBox() {
        NBTTagCompound tc = this.hasCard();
        if (tc == null) {
            return null;
        }
        int channel = tc.getInteger("channel");
        if (channel == -1) {
            return null;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.getChannels(this.getWorld());
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        if (chamberChannel == null) {
            return null;
        }
        this.calculateBox(tc);
        if (!this.boxValid) {
            return null;
        }
        return chamberChannel;
    }

    private Map<BlockPos, IBlockState> getCachedBlocks(ChunkPos chunk) {
        if (chunk != null && !chunk.equals((Object)this.cachedChunk) || chunk == null && this.cachedChunk != null) {
            this.cachedBlocks = null;
        }
        if (this.cachedBlocks == null) {
            this.cachedBlocks = new HashMap<BlockPos, IBlockState>();
            ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
            Shape shape = ShapeCardItem.getShape(shapeCard);
            boolean solid = ShapeCardItem.isSolid(shapeCard);
            BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, BuilderConfiguration.maxBuilderDimension.get());
            BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, BuilderConfiguration.maxBuilderOffset.get());
            boolean forquarry = !ShapeCardItem.isNormalShapeCard(shapeCard);
            ShapeCardItem.composeFormula(shapeCard, shape.getFormulaFactory().get(), this.getWorld(), this.getPos(), dimension, offset, this.cachedBlocks, BuilderConfiguration.maxSpaceChamberDimension.get() * BuilderConfiguration.maxSpaceChamberDimension.get() * BuilderConfiguration.maxSpaceChamberDimension.get(), solid, forquarry, chunk);
            this.cachedChunk = chunk;
        }
        return this.cachedBlocks;
    }

    private void handleBlockShaped() {
        for (int i = 0; i < 100; ++i) {
            if (this.scan == null) {
                return;
            }
            Map<BlockPos, IBlockState> blocks = this.getCachedBlocks(new ChunkPos(this.scan.getX() >> 4, this.scan.getZ() >> 4));
            if (blocks.containsKey(this.scan)) {
                IBlockState state = blocks.get(this.scan);
                if (!this.handleSingleBlock(state)) {
                    this.nextLocation();
                }
                return;
            }
            this.nextLocation();
        }
    }

    private ShapeCardType getCardType() {
        ItemStack card;
        if (this.cardType == ShapeCardType.CARD_UNKNOWN && !(card = this.inventoryHelper.getStackInSlot(0)).isEmpty()) {
            this.cardType = ShapeCardType.fromDamage(card.getItemDamage());
        }
        return this.cardType;
    }

    private boolean handleSingleBlock(IBlockState pickState) {
        Block block;
        BlockPos srcPos = this.scan;
        int sx = this.scan.getX();
        int sy = this.scan.getY();
        int sz = this.scan.getZ();
        if (!this.chunkLoad(sx, sz)) {
            return this.suspend("Chunk not available!");
        }
        int rfNeeded = this.getCardType().getRfNeeded();
        IBlockState state = null;
        if (this.getCardType() != ShapeCardType.CARD_SHAPE && this.getCardType() != ShapeCardType.CARD_PUMP_LIQUID && !BuilderTileEntity.isEmpty(state = this.getWorld().getBlockState(srcPos), block = state.getBlock())) {
            float hardness;
            if (BuilderTileEntity.isFluidBlock(block)) {
                hardness = 1.0f;
            } else {
                if (this.getCachedVoidableBlocks().contains(block)) {
                    rfNeeded = (int)((double)BuilderConfiguration.builderRfPerQuarry.get() * BuilderConfiguration.voidShapeCardFactor.get());
                }
                hardness = block.getBlockHardness(state, this.getWorld(), srcPos);
            }
            rfNeeded *= (int)((hardness + 1.0f) * 2.0f);
        }
        if ((long)(rfNeeded = (int)((float)rfNeeded * (3.0f - this.getInfusedFactor()) / 3.0f)) > this.getStoredPower()) {
            return this.suspend("Not enough power!");
        }
        return this.getCardType().handleSingleBlock(this, rfNeeded, srcPos, state, pickState);
    }

    public boolean buildBlock(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        if (BuilderTileEntity.isEmptyOrReplacable(this.getWorld(), srcPos)) {
            TakeableItem item = this.createTakeableItem(this.getWorld(), srcPos, pickState);
            ItemStack stack = item.peek();
            if (stack.isEmpty()) {
                return this.waitOrSkip("Cannot find block!\nor missing inventory\non top or below");
            }
            FakePlayer fakePlayer = this.getHarvester();
            IBlockState newState = BlockTools.placeStackAt((EntityPlayer)fakePlayer, (ItemStack)stack, (World)this.getWorld(), (BlockPos)srcPos, (IBlockState)pickState);
            if (!ItemStack.areItemStacksEqual((ItemStack)stack, (ItemStack)item.peek())) {
                if (!stack.isEmpty()) {
                    if (!(stack = item.takeAndReplace(stack)).isEmpty() && !(stack = this.insertItem(stack)).isEmpty()) {
                        this.getWorld().spawnEntity((Entity)new EntityItem(this.getWorld(), (double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), stack));
                    }
                } else {
                    item.take();
                }
            }
            if (!this.silent) {
                SoundTools.playSound((World)this.getWorld(), (SoundEvent)newState.getBlock().getSoundType(newState, this.getWorld(), srcPos, (Entity)fakePlayer).getPlaceSound(), (double)srcPos.getX(), (double)srcPos.getY(), (double)srcPos.getZ(), (double)1.0, (double)1.0);
            }
            this.consumeEnergy(rfNeeded);
        }
        return this.skip();
    }

    private Set<Block> getCachedVoidableBlocks() {
        if (this.cachedVoidableBlocks == null) {
            ItemStack card = this.inventoryHelper.getStackInSlot(0);
            this.cachedVoidableBlocks = !card.isEmpty() && card.getItem() == BuilderSetup.shapeCardItem ? ShapeCardItem.getVoidedBlocks(card) : Collections.emptySet();
        }
        return this.cachedVoidableBlocks;
    }

    private void clearOrDirtBlock(int rfNeeded, BlockPos spos, IBlockState srcState, boolean clear) {
        TileEntity te;
        if (srcState.getBlock() instanceof BlockShulkerBox && (te = this.world.getTileEntity(spos)) instanceof TileEntityShulkerBox) {
            ((TileEntityShulkerBox)te).clear();
        }
        if (clear) {
            this.getWorld().setBlockToAir(spos);
        } else {
            this.getWorld().setBlockState(spos, this.getReplacementBlock(), 2);
        }
        this.consumeEnergy(rfNeeded);
        if (!this.silent) {
            SoundTools.playSound((World)this.getWorld(), (SoundEvent)srcState.getBlock().getSoundType(srcState, this.getWorld(), spos, null).getBreakSound(), (double)spos.getX(), (double)spos.getY(), (double)spos.getZ(), (double)1.0, (double)1.0);
        }
    }

    private IBlockState getReplacementBlock() {
        return BuilderConfiguration.getQuarryReplace();
    }

    public boolean silkQuarryBlock(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        return this.commonQuarryBlock(true, rfNeeded, srcPos, srcState);
    }

    private void getFilterCache() {
        if (this.filterCache == null) {
            this.filterCache = StorageFilterItem.getCache(this.inventoryHelper.getStackInSlot(1));
        }
    }

    public static boolean allowedToBreak(IBlockState state, World world, BlockPos pos, EntityPlayer entityPlayer) {
        if (!state.getBlock().canEntityDestroy(state, (IBlockAccess)world, pos, (Entity)entityPlayer)) {
            return false;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, entityPlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public boolean quarryBlock(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        return this.commonQuarryBlock(false, rfNeeded, srcPos, srcState);
    }

    private boolean commonQuarryBlock(boolean silk, int rfNeeded, BlockPos srcPos, IBlockState srcState) {
        Block block = srcState.getBlock();
        int xCoord = this.getPos().getX();
        int yCoord = this.getPos().getY();
        int zCoord = this.getPos().getZ();
        int sx = srcPos.getX();
        int sy = srcPos.getY();
        int sz = srcPos.getZ();
        if (sx >= xCoord - 1 && sx <= xCoord + 1 && sy >= yCoord - 1 && sy <= yCoord + 1 && sz >= zCoord - 1 && sz <= zCoord + 1) {
            return this.skip();
        }
        if (BuilderTileEntity.isEmpty(srcState, block)) {
            return this.skip();
        }
        if (block.getBlockHardness(srcState, this.getWorld(), srcPos) >= 0.0f) {
            boolean clear = this.getCardType().isClearing();
            if (!clear && srcState == this.getReplacementBlock()) {
                return this.skip();
            }
            if (!BuilderConfiguration.quarryTileEntities.get() && this.getWorld().getTileEntity(srcPos) != null) {
                return this.skip();
            }
            FakePlayer fakePlayer = this.getHarvester();
            if (BuilderTileEntity.allowedToBreak(srcState, this.getWorld(), srcPos, (EntityPlayer)fakePlayer)) {
                ItemStack filter = this.getStackInSlot(1);
                if (!filter.isEmpty()) {
                    boolean match;
                    this.getFilterCache();
                    if (this.filterCache != null && !(match = this.filterCache.match(block.getItem(this.getWorld(), srcPos, srcState)))) {
                        this.consumeEnergy(Math.min(rfNeeded, BuilderConfiguration.builderRfPerSkipped.get()));
                        return this.skip();
                    }
                }
                if (!this.getCachedVoidableBlocks().contains(block)) {
                    List<ItemStack> drops;
                    if (this.overflowItems != null) {
                        return this.waitOrSkip("Not enough room!\nor no usable storage\non top or below!");
                    }
                    if (silk && block.canSilkHarvest(this.getWorld(), srcPos, srcState, (EntityPlayer)fakePlayer)) {
                        ItemStack drop;
                        try {
                            drop = (ItemStack)ModSetup.Block_getSilkTouch.invoke((Object)block, srcState);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                        drops = new ArrayList();
                        if (!drop.isEmpty()) {
                            drops.add(drop);
                        }
                        ForgeEventFactory.fireBlockHarvesting(drops, (World)this.getWorld(), (BlockPos)srcPos, (IBlockState)srcState, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
                    } else {
                        int fortune;
                        int n = fortune = this.getCardType().isFortune() ? 3 : 0;
                        if (block instanceof BlockShulkerBox) {
                            drops = new ArrayList();
                            TileEntity te = this.getWorld().getTileEntity(srcPos);
                            if (te instanceof TileEntityShulkerBox) {
                                TileEntityShulkerBox teShulkerBox = (TileEntityShulkerBox)te;
                                ItemStack stack = new ItemStack(Item.getItemFromBlock((Block)block));
                                teShulkerBox.saveToNbt(stack.getOrCreateSubCompound("BlockEntityTag"));
                                if (teShulkerBox.hasCustomName()) {
                                    stack.setStackDisplayName(teShulkerBox.getName());
                                }
                                drops.add(stack);
                            }
                        } else {
                            drops = block.getDrops((IBlockAccess)this.getWorld(), srcPos, srcState, fortune);
                        }
                        ForgeEventFactory.fireBlockHarvesting(drops, (World)this.getWorld(), (BlockPos)srcPos, (IBlockState)srcState, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
                    }
                    if (this.checkValidItems(block, drops) && !this.insertItems(drops)) {
                        this.overflowItems = drops;
                        this.clearOrDirtBlock(rfNeeded, srcPos, srcState, clear);
                        return this.waitOrSkip("Not enough room!\nor no usable storage\non top or below!");
                    }
                }
                this.clearOrDirtBlock(rfNeeded, srcPos, srcState, clear);
            }
        }
        return silk ? this.skip() : false;
    }

    private static boolean isFluidBlock(Block block) {
        return block instanceof BlockLiquid || block instanceof BlockFluidBase;
    }

    private static int getFluidLevel(IBlockState srcState) {
        if (srcState.getBlock() instanceof BlockLiquid) {
            return (Integer)srcState.getValue((IProperty)BlockLiquid.LEVEL);
        }
        if (srcState.getBlock() instanceof BlockFluidBase) {
            return (Integer)srcState.getValue((IProperty)BlockFluidBase.LEVEL);
        }
        return -1;
    }

    public boolean placeLiquidBlock(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        if (BuilderTileEntity.isEmptyOrReplacable(this.getWorld(), srcPos)) {
            FluidStack stack = this.consumeLiquid(this.getWorld(), srcPos);
            if (stack == null) {
                return this.waitOrSkip("Cannot find liquid!\nor no usable tank\nabove or below");
            }
            Fluid fluid = stack.getFluid();
            if (fluid.doesVaporize(stack) && this.getWorld().provider.doesWaterVaporize()) {
                fluid.vaporize(null, this.getWorld(), srcPos, stack);
            } else {
                Block block = fluid.getBlock();
                FakePlayer fakePlayer = this.getHarvester();
                this.getWorld().setBlockState(srcPos, block.getDefaultState(), 11);
                if (!this.silent) {
                    SoundTools.playSound((World)this.getWorld(), (SoundEvent)block.getSoundType(block.getDefaultState(), this.getWorld(), srcPos, (Entity)fakePlayer).getPlaceSound(), (double)srcPos.getX(), (double)srcPos.getY(), (double)srcPos.getZ(), (double)1.0, (double)1.0);
                }
            }
            this.consumeEnergy(rfNeeded);
        }
        return this.skip();
    }

    public boolean pumpBlock(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        Block block = srcState.getBlock();
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid == null) {
            return this.skip();
        }
        if (!BuilderTileEntity.isFluidBlock(block)) {
            return this.skip();
        }
        if (BuilderTileEntity.getFluidLevel(srcState) != 0) {
            return this.skip();
        }
        if (block.getBlockHardness(srcState, this.getWorld(), srcPos) >= 0.0f) {
            FakePlayer fakePlayer = this.getHarvester();
            if (BuilderTileEntity.allowedToBreak(srcState, this.getWorld(), srcPos, (EntityPlayer)fakePlayer)) {
                if (this.checkAndInsertFluids(fluid)) {
                    this.consumeEnergy(rfNeeded);
                    boolean clear = this.getCardType().isClearing();
                    if (clear) {
                        this.getWorld().setBlockToAir(srcPos);
                    } else {
                        this.getWorld().setBlockState(srcPos, this.getReplacementBlock(), 2);
                    }
                    if (!this.silent) {
                        SoundTools.playSound((World)this.getWorld(), (SoundEvent)block.getSoundType(srcState, this.getWorld(), srcPos, (Entity)fakePlayer).getBreakSound(), (double)srcPos.getX(), (double)srcPos.getY(), (double)srcPos.getZ(), (double)1.0, (double)1.0);
                    }
                    return this.skip();
                }
                return this.waitOrSkip("No room for liquid\nor no usable tank\nabove or below!");
            }
        }
        return this.skip();
    }

    public boolean voidBlock(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        Block block = srcState.getBlock();
        int xCoord = this.getPos().getX();
        int yCoord = this.getPos().getY();
        int zCoord = this.getPos().getZ();
        int sx = srcPos.getX();
        int sy = srcPos.getY();
        int sz = srcPos.getZ();
        if (sx >= xCoord - 1 && sx <= xCoord + 1 && sy >= yCoord - 1 && sy <= yCoord + 1 && sz >= zCoord - 1 && sz <= zCoord + 1) {
            return this.skip();
        }
        FakePlayer fakePlayer = this.getHarvester();
        if (BuilderTileEntity.allowedToBreak(srcState, this.getWorld(), srcPos, (EntityPlayer)fakePlayer) && block.getBlockHardness(srcState, this.getWorld(), srcPos) >= 0.0f) {
            ItemStack filter = this.getStackInSlot(1);
            if (!filter.isEmpty()) {
                boolean match;
                this.getFilterCache();
                if (this.filterCache != null && !(match = this.filterCache.match(block.getItem(this.getWorld(), srcPos, srcState)))) {
                    this.consumeEnergy(Math.min(rfNeeded, BuilderConfiguration.builderRfPerSkipped.get()));
                    return this.skip();
                }
            }
            if (!this.silent) {
                SoundTools.playSound((World)this.getWorld(), (SoundEvent)block.getSoundType(srcState, this.getWorld(), srcPos, (Entity)fakePlayer).getBreakSound(), (double)sx, (double)sy, (double)sz, (double)1.0, (double)1.0);
            }
            this.getWorld().setBlockToAir(srcPos);
            this.consumeEnergy(rfNeeded);
        }
        return this.skip();
    }

    private void handleBlock(World world) {
        BlockPos srcPos = this.scan;
        BlockPos destPos = this.sourceToDest(this.scan);
        int x = this.scan.getX();
        int y = this.scan.getY();
        int z = this.scan.getZ();
        int destX = destPos.getX();
        int destY = destPos.getY();
        int destZ = destPos.getZ();
        switch (this.mode) {
            case 0: {
                this.copyBlock(world, srcPos, this.getWorld(), destPos);
                break;
            }
            case 1: {
                if (this.entityMode) {
                    this.moveEntities(world, x, y, z, this.getWorld(), destX, destY, destZ);
                }
                this.moveBlock(world, srcPos, this.getWorld(), destPos, this.rotate);
                break;
            }
            case 3: {
                if (this.entityMode) {
                    this.moveEntities(this.getWorld(), destX, destY, destZ, world, x, y, z);
                }
                this.moveBlock(this.getWorld(), destPos, world, srcPos, this.oppositeRotate());
                break;
            }
            case 2: {
                if (this.entityMode) {
                    this.swapEntities(world, x, y, z, this.getWorld(), destX, destY, destZ);
                }
                this.swapBlock(world, srcPos, this.getWorld(), destPos);
            }
        }
        this.nextLocation();
    }

    private TakeableItem findBlockTakeableItem(IItemHandler inventory, World srcWorld, BlockPos srcPos, IBlockState state) {
        if (state == null) {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (!this.isPlacable(inventory.getStackInSlot(i))) continue;
                slots.add(i);
            }
            if (!slots.isEmpty()) {
                return new TakeableItem(inventory, (int)((Integer)slots.get(random.nextInt(slots.size()))));
            }
        } else {
            Block block = state.getBlock();
            ItemStack srcItem = block.getItem(srcWorld, srcPos, state);
            if (this.isPlacable(srcItem)) {
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack stack = inventory.getStackInSlot(i);
                    if (stack.isEmpty() || !stack.isItemEqual(srcItem)) continue;
                    return new TakeableItem(inventory, i);
                }
            }
        }
        return TakeableItem.EMPTY;
    }

    private boolean isPlacable(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return item instanceof ItemBlock || item instanceof ItemSkull || item instanceof ItemBlockSpecial || item instanceof IPlantable || item instanceof ItemRedstone;
    }

    private TakeableItem findBlockTakeableItem(IInventory inventory, World srcWorld, BlockPos srcPos, IBlockState state) {
        if (state == null) {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < inventory.getSizeInventory(); ++i) {
                if (!this.isPlacable(inventory.getStackInSlot(i))) continue;
                slots.add(i);
            }
            if (!slots.isEmpty()) {
                return new TakeableItem(inventory, (int)((Integer)slots.get(random.nextInt(slots.size()))));
            }
        } else {
            Block block = state.getBlock();
            ItemStack srcItem = block.getItem(srcWorld, srcPos, state);
            if (this.isPlacable(srcItem)) {
                for (int i = 0; i < inventory.getSizeInventory(); ++i) {
                    ItemStack stack = inventory.getStackInSlot(i);
                    if (stack.isEmpty() || !stack.isItemEqual(srcItem)) continue;
                    return new TakeableItem(inventory, i);
                }
            }
        }
        return TakeableItem.EMPTY;
    }

    private boolean checkValidItems(Block block, List<ItemStack> items) {
        for (ItemStack stack : items) {
            if (stack.isEmpty() || stack.getItem() != null) continue;
            Logging.logError((String)("Builder tried to quarry " + block.getRegistryName().toString() + " and it returned null item!"));
            Broadcaster.broadcast((World)this.getWorld(), (int)this.pos.getX(), (int)this.pos.getY(), (int)this.pos.getZ(), (String)("Builder tried to quarry " + block.getRegistryName().toString() + " and it returned null item!\nPlease report to mod author!"), (float)10.0f);
            return false;
        }
        return true;
    }

    private boolean checkAndInsertFluids(Fluid fluid) {
        if (this.checkFluidTank(fluid, this.getPos().up(), EnumFacing.DOWN)) {
            return true;
        }
        return this.checkFluidTank(fluid, this.getPos().down(), EnumFacing.UP);
    }

    private boolean checkFluidTank(Fluid fluid, BlockPos up, EnumFacing side) {
        FluidStack fluidStack;
        IFluidHandler handler;
        int amount;
        TileEntity te = this.getWorld().getTileEntity(up);
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) && (amount = (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)).fill(fluidStack = new FluidStack(fluid, 1000), false)) == 1000) {
            handler.fill(fluidStack, true);
            return true;
        }
        return false;
    }

    private boolean insertItems(List<ItemStack> items) {
        TileEntity te = this.getWorld().getTileEntity(this.getPos().up());
        boolean ok = InventoryHelper.insertItemsAtomic(items, (TileEntity)te, (EnumFacing)EnumFacing.DOWN);
        if (!ok) {
            te = this.getWorld().getTileEntity(this.getPos().down());
            ok = InventoryHelper.insertItemsAtomic(items, (TileEntity)te, (EnumFacing)EnumFacing.UP);
        }
        return ok;
    }

    private ItemStack insertItem(ItemStack s) {
        s = InventoryHelper.insertItem((World)this.getWorld(), (BlockPos)this.getPos(), (EnumFacing)EnumFacing.UP, (ItemStack)s);
        if (!s.isEmpty()) {
            s = InventoryHelper.insertItem((World)this.getWorld(), (BlockPos)this.getPos(), (EnumFacing)EnumFacing.DOWN, (ItemStack)s);
        }
        return s;
    }

    private TakeableItem createTakeableItem(EnumFacing direction, World srcWorld, BlockPos srcPos, IBlockState state) {
        TileEntity te = this.getWorld().getTileEntity(this.getPos().offset(direction));
        if (te != null) {
            if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.getOpposite())) {
                IItemHandler capability = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.getOpposite());
                return this.findBlockTakeableItem(capability, srcWorld, srcPos, state);
            }
            if (te instanceof IInventory) {
                return this.findBlockTakeableItem((IInventory)te, srcWorld, srcPos, state);
            }
        }
        return TakeableItem.EMPTY;
    }

    private FluidStack consumeLiquid(World srcWorld, BlockPos srcPos) {
        FluidStack b = this.consumeLiquid(EnumFacing.UP, srcWorld, srcPos);
        if (b == null) {
            b = this.consumeLiquid(EnumFacing.DOWN, srcWorld, srcPos);
        }
        return b;
    }

    private FluidStack consumeLiquid(EnumFacing direction, World srcWorld, BlockPos srcPos) {
        TileEntity te = this.getWorld().getTileEntity(this.getPos().offset(direction));
        if (te != null) {
            if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.getOpposite())) {
                IFluidHandler capability = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.getOpposite());
                return this.findAndConsumeLiquid(capability, srcWorld, srcPos);
            }
            if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                IFluidHandler capability = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                return this.findAndConsumeLiquid(capability, srcWorld, srcPos);
            }
        }
        return null;
    }

    private FluidStack findAndConsumeLiquid(IFluidHandler tank, World srcWorld, BlockPos srcPos) {
        for (IFluidTankProperties properties : tank.getTankProperties()) {
            FluidStack contents = properties.getContents();
            if (contents == null || contents.getFluid() == null || contents.amount < 1000) continue;
            FluidStack drained = tank.drain(new FluidStack(contents.getFluid(), 1000, contents.tag), true);
            return drained;
        }
        return null;
    }

    private TakeableItem createTakeableItem(World srcWorld, BlockPos srcPos, IBlockState state) {
        TakeableItem b = this.createTakeableItem(EnumFacing.UP, srcWorld, srcPos, state);
        if (b.peek().isEmpty()) {
            b = this.createTakeableItem(EnumFacing.DOWN, srcWorld, srcPos, state);
        }
        return b;
    }

    public static BuilderSetup.BlockInformation getBlockInformation(EntityPlayer fakePlayer, World world, BlockPos pos, Block block, TileEntity tileEntity) {
        IBlockState state = world.getBlockState(pos);
        if (BuilderTileEntity.isEmpty(state, block)) {
            return BuilderSetup.BlockInformation.FREE;
        }
        if (!BuilderTileEntity.allowedToBreak(state, world, pos, fakePlayer)) {
            return BuilderSetup.BlockInformation.INVALID;
        }
        BuilderSetup.BlockInformation blockInformation = BuilderSetup.getBlockInformation(block);
        if (tileEntity != null) {
            switch ((BuilderTileEntityMode)((Object)BuilderConfiguration.teMode.get())) {
                case MOVE_FORBIDDEN: {
                    return BuilderSetup.BlockInformation.INVALID;
                }
                case MOVE_WHITELIST: {
                    if (blockInformation != null && blockInformation.getBlockLevel() != 2) break;
                    return BuilderSetup.BlockInformation.INVALID;
                }
                case MOVE_BLACKLIST: {
                    if (blockInformation == null || blockInformation.getBlockLevel() != 2) break;
                    return BuilderSetup.BlockInformation.INVALID;
                }
            }
        }
        if (blockInformation != null) {
            return blockInformation;
        }
        return BuilderSetup.BlockInformation.OK;
    }

    private int isMovable(World world, BlockPos pos, Block block, TileEntity tileEntity) {
        return BuilderTileEntity.getBlockInformation((EntityPlayer)this.getHarvester(), world, pos, block, tileEntity).getBlockLevel();
    }

    public static boolean isEmptyOrReplacable(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block.isReplaceable((IBlockAccess)world, pos)) {
            return true;
        }
        return BuilderTileEntity.isEmpty(state, block);
    }

    public static boolean isEmpty(IBlockState state, Block block) {
        if (block == null) {
            return true;
        }
        if (block.getMaterial(state) == Material.AIR) {
            return true;
        }
        return block == BuilderSetup.supportBlock;
    }

    private void clearBlock(World world, BlockPos pos) {
        if (this.supportMode) {
            world.setBlockState(pos, BuilderSetup.supportBlock.getDefaultState(), 3);
        } else {
            world.setBlockToAir(pos);
        }
    }

    private int oppositeRotate() {
        switch (this.rotate) {
            case 1: {
                return 3;
            }
            case 3: {
                return 1;
            }
        }
        return this.rotate;
    }

    private void copyBlock(World srcWorld, BlockPos srcPos, World destWorld, BlockPos destPos) {
        long rf = this.getStoredPower();
        int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerOperation.get() * this.getDimensionCostFactor(srcWorld, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        if ((long)rfNeeded > rf) {
            return;
        }
        if (BuilderTileEntity.isEmptyOrReplacable(destWorld, destPos)) {
            if (srcWorld.isAirBlock(srcPos)) {
                return;
            }
            IBlockState srcState = srcWorld.getBlockState(srcPos);
            TakeableItem takeableItem = this.createTakeableItem(srcWorld, srcPos, srcState);
            ItemStack consumedStack = takeableItem.peek();
            if (consumedStack.isEmpty()) {
                return;
            }
            FakePlayer fakePlayer = this.getHarvester();
            IBlockState newState = BlockTools.placeStackAt((EntityPlayer)fakePlayer, (ItemStack)consumedStack, (World)destWorld, (BlockPos)destPos, (IBlockState)srcState);
            destWorld.setBlockState(destPos, newState, 3);
            if (!ItemStack.areItemStacksEqual((ItemStack)consumedStack, (ItemStack)takeableItem.peek())) {
                if (!consumedStack.isEmpty()) {
                    if (!(consumedStack = takeableItem.takeAndReplace(consumedStack)).isEmpty() && !(consumedStack = this.insertItem(consumedStack)).isEmpty()) {
                        this.getWorld().spawnEntity((Entity)new EntityItem(this.getWorld(), (double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), consumedStack));
                    }
                } else {
                    takeableItem.take();
                }
            }
            if (!this.silent) {
                SoundTools.playSound((World)destWorld, (SoundEvent)newState.getBlock().getSoundType(newState, destWorld, destPos, (Entity)fakePlayer).getPlaceSound(), (double)destPos.getX(), (double)destPos.getY(), (double)destPos.getZ(), (double)1.0, (double)1.0);
            }
            this.consumeEnergy(rfNeeded);
        }
    }

    private double getDimensionCostFactor(World world, World destWorld) {
        return destWorld.provider.getDimension() == world.provider.getDimension() ? 1.0 : BuilderConfiguration.dimensionCostFactor.get();
    }

    private boolean consumeEntityEnergy(int rfNeeded, int rfNeededPlayer, Entity entity) {
        long rf;
        int rfn = entity instanceof EntityPlayer ? rfNeededPlayer : rfNeeded;
        if ((long)rfn > (rf = this.getStoredPower())) {
            return true;
        }
        this.consumeEnergy(rfn);
        return false;
    }

    private void moveEntities(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ) {
        int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerEntity.get() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        int rfNeededPlayer = (int)((double)BuilderConfiguration.builderRfPerPlayer.get() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        List entities = world.getEntitiesWithinAABBExcludingEntity(null, new AxisAlignedBB((double)x - 0.1, (double)y - 0.1, (double)z - 0.1, (double)x + 1.1, (double)y + 1.1, (double)z + 1.1));
        for (Entity entity : entities) {
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            double newX = (double)destX + (entity.posX - (double)x);
            double newY = (double)destY + (entity.posY - (double)y);
            double newZ = (double)destZ + (entity.posZ - (double)z);
            this.teleportEntity(world, destWorld, entity, newX, newY, newZ);
        }
    }

    private void swapEntities(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ) {
        double newZ;
        double newY;
        double newX;
        int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerEntity.get() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        int rfNeededPlayer = (int)((double)BuilderConfiguration.builderRfPerPlayer.get() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        List entitiesSrc = world.getEntitiesWithinAABBExcludingEntity(null, new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        List entitiesDst = destWorld.getEntitiesWithinAABBExcludingEntity(null, new AxisAlignedBB((double)destX, (double)destY, (double)destZ, (double)(destX + 1), (double)(destY + 1), (double)(destZ + 1)));
        for (Entity entity : entitiesSrc) {
            if (!this.isEntityInBlock(x, y, z, entity)) continue;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            newX = (double)destX + (entity.posX - (double)x);
            newY = (double)destY + (entity.posY - (double)y);
            newZ = (double)destZ + (entity.posZ - (double)z);
            this.teleportEntity(world, destWorld, entity, newX, newY, newZ);
        }
        for (Entity entity : entitiesDst) {
            if (!this.isEntityInBlock(destX, destY, destZ, entity)) continue;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            newX = (double)x + (entity.posX - (double)destX);
            newY = (double)y + (entity.posY - (double)destY);
            newZ = (double)z + (entity.posZ - (double)destZ);
            this.teleportEntity(destWorld, world, entity, newX, newY, newZ);
        }
    }

    private void teleportEntity(World world, World destWorld, Entity entity, double newX, double newY, double newZ) {
        if (!TeleportationTools.allowTeleport(entity, world.provider.getDimension(), entity.getPosition(), destWorld.provider.getDimension(), new BlockPos(newX, newY, newZ))) {
            return;
        }
        mcjty.lib.varia.TeleportationTools.teleportEntity((Entity)entity, (World)destWorld, (double)newX, (double)newY, (double)newZ, null);
    }

    private boolean isEntityInBlock(int x, int y, int z, Entity entity) {
        return entity.posX >= (double)x && entity.posX < (double)(x + 1) && entity.posY >= (double)y && entity.posY < (double)(y + 1) && entity.posZ >= (double)z && entity.posZ < (double)(z + 1);
    }

    private void moveBlock(World srcWorld, BlockPos srcPos, World destWorld, BlockPos destPos, int rotMode) {
        Block oldDestBlock;
        IBlockState oldDestState = destWorld.getBlockState(destPos);
        if (BuilderTileEntity.isEmpty(oldDestState, oldDestBlock = oldDestState.getBlock())) {
            Block srcBlock;
            IBlockState srcState = srcWorld.getBlockState(srcPos);
            if (BuilderTileEntity.isEmpty(srcState, srcBlock = srcState.getBlock())) {
                return;
            }
            TileEntity srcTileEntity = srcWorld.getTileEntity(srcPos);
            BuilderSetup.BlockInformation srcInformation = BuilderTileEntity.getBlockInformation((EntityPlayer)this.getHarvester(), srcWorld, srcPos, srcBlock, srcTileEntity);
            if (srcInformation.getBlockLevel() == 2) {
                return;
            }
            long rf = this.getStoredPower();
            int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerOperation.get() * this.getDimensionCostFactor(srcWorld, destWorld) * srcInformation.getCostFactor() * (double)(4.0f - this.getInfusedFactor()) / 4.0);
            if ((long)rfNeeded > rf) {
                return;
            }
            this.consumeEnergy(rfNeeded);
            NBTTagCompound tc = null;
            if (srcTileEntity != null) {
                tc = new NBTTagCompound();
                srcTileEntity.writeToNBT(tc);
                srcWorld.removeTileEntity(srcPos);
            }
            this.clearBlock(srcWorld, srcPos);
            destWorld.setBlockState(destPos, srcState, 3);
            if (srcTileEntity != null && tc != null) {
                this.setTileEntityNBT(destWorld, tc, destPos, srcState);
            }
            if (!this.silent) {
                SoundTools.playSound((World)srcWorld, (SoundEvent)srcBlock.getSoundType(srcState, srcWorld, srcPos, null).getBreakSound(), (double)srcPos.getX(), (double)srcPos.getY(), (double)srcPos.getZ(), (double)1.0, (double)1.0);
                SoundTools.playSound((World)destWorld, (SoundEvent)srcBlock.getSoundType(srcState, destWorld, destPos, null).getPlaceSound(), (double)destPos.getX(), (double)destPos.getY(), (double)destPos.getZ(), (double)1.0, (double)1.0);
            }
        }
    }

    private void setTileEntityNBT(World destWorld, NBTTagCompound tc, BlockPos destpos, IBlockState newDestState) {
        tc.setInteger("x", destpos.getX());
        tc.setInteger("y", destpos.getY());
        tc.setInteger("z", destpos.getZ());
        TileEntity tileEntity = TileEntity.create((World)destWorld, (NBTTagCompound)tc);
        if (tileEntity != null) {
            destWorld.getChunk(destpos).addTileEntity(tileEntity);
            tileEntity.markDirty();
            destWorld.notifyBlockUpdate(destpos, newDestState, newDestState, 3);
        }
    }

    private void swapBlock(World srcWorld, BlockPos srcPos, World destWorld, BlockPos dstPos) {
        IBlockState oldSrcState = srcWorld.getBlockState(srcPos);
        Block srcBlock = oldSrcState.getBlock();
        TileEntity srcTileEntity = srcWorld.getTileEntity(srcPos);
        IBlockState oldDstState = destWorld.getBlockState(dstPos);
        Block dstBlock = oldDstState.getBlock();
        TileEntity dstTileEntity = destWorld.getTileEntity(dstPos);
        if (BuilderTileEntity.isEmpty(oldSrcState, srcBlock) && BuilderTileEntity.isEmpty(oldDstState, dstBlock)) {
            return;
        }
        BuilderSetup.BlockInformation srcInformation = BuilderTileEntity.getBlockInformation((EntityPlayer)this.getHarvester(), srcWorld, srcPos, srcBlock, srcTileEntity);
        if (srcInformation.getBlockLevel() == 2) {
            return;
        }
        BuilderSetup.BlockInformation dstInformation = BuilderTileEntity.getBlockInformation((EntityPlayer)this.getHarvester(), destWorld, dstPos, dstBlock, dstTileEntity);
        if (dstInformation.getBlockLevel() == 2) {
            return;
        }
        long rf = this.getStoredPower();
        int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerOperation.get() * this.getDimensionCostFactor(srcWorld, destWorld) * srcInformation.getCostFactor() * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        if ((long)(rfNeeded += (int)((double)BuilderConfiguration.builderRfPerOperation.get() * this.getDimensionCostFactor(srcWorld, destWorld) * dstInformation.getCostFactor() * (double)(4.0f - this.getInfusedFactor()) / 4.0)) > rf) {
            return;
        }
        this.consumeEnergy(rfNeeded);
        srcWorld.removeTileEntity(srcPos);
        srcWorld.setBlockToAir(srcPos);
        destWorld.removeTileEntity(dstPos);
        destWorld.setBlockToAir(dstPos);
        IBlockState newDstState = oldSrcState;
        destWorld.setBlockState(dstPos, newDstState, 3);
        if (srcTileEntity != null) {
            srcTileEntity.validate();
            destWorld.setTileEntity(dstPos, srcTileEntity);
            srcTileEntity.markDirty();
            destWorld.notifyBlockUpdate(dstPos, newDstState, newDstState, 3);
        }
        IBlockState newSrcState = oldDstState;
        srcWorld.setBlockState(srcPos, newSrcState, 3);
        if (dstTileEntity != null) {
            dstTileEntity.validate();
            srcWorld.setTileEntity(srcPos, dstTileEntity);
            dstTileEntity.markDirty();
            srcWorld.notifyBlockUpdate(srcPos, newSrcState, newSrcState, 3);
        }
        if (!this.silent) {
            if (!BuilderTileEntity.isEmpty(oldSrcState, srcBlock)) {
                SoundTools.playSound((World)srcWorld, (SoundEvent)srcBlock.getSoundType(oldSrcState, srcWorld, srcPos, null).getBreakSound(), (double)srcPos.getX(), (double)srcPos.getY(), (double)srcPos.getZ(), (double)1.0, (double)1.0);
                SoundTools.playSound((World)destWorld, (SoundEvent)srcBlock.getSoundType(oldSrcState, destWorld, dstPos, null).getPlaceSound(), (double)dstPos.getX(), (double)dstPos.getY(), (double)dstPos.getZ(), (double)1.0, (double)1.0);
            }
            if (!BuilderTileEntity.isEmpty(oldDstState, dstBlock)) {
                SoundTools.playSound((World)destWorld, (SoundEvent)dstBlock.getSoundType(oldDstState, destWorld, dstPos, null).getBreakSound(), (double)dstPos.getX(), (double)dstPos.getY(), (double)dstPos.getZ(), (double)1.0, (double)1.0);
                SoundTools.playSound((World)srcWorld, (SoundEvent)dstBlock.getSoundType(oldDstState, srcWorld, srcPos, null).getPlaceSound(), (double)srcPos.getX(), (double)srcPos.getY(), (double)srcPos.getZ(), (double)1.0, (double)1.0);
            }
        }
    }

    private BlockPos sourceToDest(BlockPos source) {
        return this.rotate(source).add(this.projDx, this.projDy, this.projDz);
    }

    private BlockPos rotate(BlockPos c) {
        switch (this.rotate) {
            case 0: {
                return c;
            }
            case 1: {
                return new BlockPos(-c.getZ(), c.getY(), c.getX());
            }
            case 2: {
                return new BlockPos(-c.getX(), c.getY(), -c.getZ());
            }
            case 3: {
                return new BlockPos(c.getZ(), c.getY(), -c.getX());
            }
        }
        return c;
    }

    private void sourceToDest(BlockPos source, BlockPos.MutableBlockPos dest) {
        this.rotate(source, dest);
        dest.setPos(dest.getX() + this.projDx, dest.getY() + this.projDy, dest.getZ() + this.projDz);
    }

    private void rotate(BlockPos c, BlockPos.MutableBlockPos dest) {
        switch (this.rotate) {
            case 0: {
                dest.setPos((Vec3i)c);
                break;
            }
            case 1: {
                dest.setPos(-c.getZ(), c.getY(), c.getX());
                break;
            }
            case 2: {
                dest.setPos(-c.getX(), c.getY(), -c.getZ());
                break;
            }
            case 3: {
                dest.setPos(c.getZ(), c.getY(), -c.getX());
            }
        }
    }

    private void restartScan() {
        this.lastError = null;
        this.chunkUnload();
        if (this.loopMode || this.isMachineEnabled() && this.scan == null) {
            if (this.getCardType() == ShapeCardType.CARD_SPACE) {
                this.calculateBox();
                this.scan = this.minBox;
            } else if (this.getCardType() != ShapeCardType.CARD_UNKNOWN) {
                this.calculateBoxShaped();
                this.scan = new BlockPos(this.minBox.getX(), this.maxBox.getY(), this.minBox.getZ());
            }
            this.cachedBlocks = null;
            this.cachedChunk = null;
            this.cachedVoidableBlocks = null;
        } else {
            this.scan = null;
        }
    }

    public void invalidate() {
        super.invalidate();
        this.chunkUnload();
    }

    private void chunkUnload() {
        if (this.forcedChunk != null && this.ticket != null) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)this.forcedChunk);
            this.forcedChunk = null;
        }
    }

    private boolean chunkLoad(int x, int z) {
        int cx = x >> 4;
        int cz = z >> 4;
        if (WorldTools.chunkLoaded((World)this.getWorld(), (BlockPos)new BlockPos(x, 0, z))) {
            return true;
        }
        if (BuilderConfiguration.quarryChunkloads.get()) {
            ChunkPos pair;
            if (this.ticket == null) {
                this.ticket = ForgeChunkManager.requestTicket((Object)RFTools.instance, (World)this.getWorld(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                if (this.ticket == null) {
                    return false;
                }
            }
            if ((pair = new ChunkPos(cx, cz)).equals((Object)this.forcedChunk)) {
                return true;
            }
            if (this.forcedChunk != null) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)this.forcedChunk);
            }
            this.forcedChunk = pair;
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)this.forcedChunk);
            return true;
        }
        return false;
    }

    public static void setScanLocationClient(BlockPos tePos, BlockPos scanPos) {
        scanLocClient.put(tePos, (Pair<Long, BlockPos>)Pair.of((Object)System.currentTimeMillis(), (Object)scanPos));
    }

    public static Map<BlockPos, Pair<Long, BlockPos>> getScanLocClient() {
        if (scanLocClient.isEmpty()) {
            return scanLocClient;
        }
        HashMap<BlockPos, Pair<Long, BlockPos>> scans = new HashMap<BlockPos, Pair<Long, BlockPos>>();
        long time = System.currentTimeMillis();
        for (Map.Entry<BlockPos, Pair<Long, BlockPos>> entry : scanLocClient.entrySet()) {
            if ((Long)entry.getValue().getKey() + 10000L <= time) continue;
            scans.put(entry.getKey(), entry.getValue());
        }
        scanLocClient = scans;
        return scanLocClient;
    }

    private void nextLocation() {
        if (this.scan != null) {
            int x = this.scan.getX();
            int y = this.scan.getY();
            int z = this.scan.getZ();
            if (this.getCardType() == ShapeCardType.CARD_SPACE) {
                this.nextLocationNormal(x, y, z);
            } else {
                this.nextLocationQuarry(x, y, z);
            }
        }
    }

    private void nextLocationQuarry(int x, int y, int z) {
        if (x >= this.maxBox.getX() || (x + 1) % 16 == 0) {
            if (z >= this.maxBox.getZ() || (z + 1) % 16 == 0) {
                if (y <= this.minBox.getY()) {
                    if (x < this.maxBox.getX()) {
                        z = z >> 4 << 4;
                        y = this.maxBox.getY();
                        this.scan = new BlockPos(++x, y, z);
                    } else if (z < this.maxBox.getZ()) {
                        x = this.minBox.getX();
                        y = this.maxBox.getY();
                        this.scan = new BlockPos(x, y, ++z);
                    } else {
                        this.restartScan();
                    }
                } else {
                    this.scan = new BlockPos(x >> 4 << 4, y - 1, z >> 4 << 4);
                }
            } else {
                this.scan = new BlockPos(x >> 4 << 4, y, z + 1);
            }
        } else {
            this.scan = new BlockPos(x + 1, y, z);
        }
    }

    private void nextLocationNormal(int x, int y, int z) {
        if (x >= this.maxBox.getX()) {
            if (z >= this.maxBox.getZ()) {
                if (y >= this.maxBox.getY()) {
                    if (this.mode != 2 || this.isShapeCard()) {
                        this.restartScan();
                    } else {
                        this.scan = null;
                    }
                } else {
                    this.scan = new BlockPos(this.minBox.getX(), y + 1, this.minBox.getZ());
                }
            } else {
                this.scan = new BlockPos(this.minBox.getX(), y, z + 1);
            }
        } else {
            this.scan = new BlockPos(x + 1, y, z);
        }
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return CONTAINER_FACTORY.getAccessibleSlots();
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return CONTAINER_FACTORY.isInputSlot(index);
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return CONTAINER_FACTORY.isOutputSlot(index);
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (index == 0 && !this.inventoryHelper.getStackInSlot(index).isEmpty() && amount > 0) {
            this.refreshSettings();
        }
        if (index == 1) {
            this.filterCache = null;
        }
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        if (index == 0 && (stack.isEmpty() && !this.inventoryHelper.getStackInSlot(index).isEmpty() || !stack.isEmpty() && this.inventoryHelper.getStackInSlot(index).isEmpty())) {
            this.refreshSettings();
        }
        if (index == 1) {
            this.filterCache = null;
        }
        this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), index, stack);
    }

    private void refreshSettings() {
        this.clearSupportBlocks();
        this.cachedBlocks = null;
        this.cachedChunk = null;
        this.cachedVoidableBlocks = null;
        this.boxValid = false;
        this.scan = null;
        this.cardType = ShapeCardType.CARD_UNKNOWN;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return stack.getItem() == BuilderSetup.spaceChamberCardItem || stack.getItem() == BuilderSetup.shapeCardItem;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        if (tagCompound.hasKey("overflowItems")) {
            NBTTagList overflowItemsNbt = tagCompound.getTagList("overflowItems", 10);
            this.overflowItems = new ArrayList<ItemStack>(overflowItemsNbt.tagCount());
            for (NBTBase overflowNbt : overflowItemsNbt) {
                this.overflowItems.add(new ItemStack((NBTTagCompound)overflowNbt));
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        if (this.overflowItems != null) {
            NBTTagList overflowItemsNbt = new NBTTagList();
            for (ItemStack overflow : this.overflowItems) {
                overflowItemsNbt.appendTag((NBTBase)overflow.writeToNBT(new NBTTagCompound()));
            }
            tagCompound.setTag("overflowItems", (NBTBase)overflowItemsNbt);
        }
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        if (!tagCompound.hasKey("rsMode")) {
            this.rsMode = RedstoneMode.REDSTONE_ONREQUIRED;
        }
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.lastError = tagCompound.hasKey("lastError") ? tagCompound.getString("lastError") : null;
        this.mode = tagCompound.getInteger("mode");
        this.anchor = tagCompound.getInteger("anchor");
        this.rotate = tagCompound.getInteger("rotate");
        this.silent = tagCompound.getBoolean("silent");
        this.supportMode = tagCompound.getBoolean("support");
        this.entityMode = tagCompound.getBoolean("entityMode");
        this.loopMode = tagCompound.getBoolean("loopMode");
        this.waitMode = tagCompound.hasKey("waitMode") ? tagCompound.getBoolean("waitMode") : true;
        this.hilightMode = tagCompound.getBoolean("hilightMode");
        this.scan = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"scan");
        this.minBox = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"minBox");
        this.maxBox = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"maxBox");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        if (this.lastError != null) {
            tagCompound.setString("lastError", this.lastError);
        }
        tagCompound.setInteger("mode", this.mode);
        tagCompound.setInteger("anchor", this.anchor);
        tagCompound.setInteger("rotate", this.rotate);
        tagCompound.setBoolean("silent", this.silent);
        tagCompound.setBoolean("support", this.supportMode);
        tagCompound.setBoolean("entityMode", this.entityMode);
        tagCompound.setBoolean("loopMode", this.loopMode);
        tagCompound.setBoolean("waitMode", this.waitMode);
        tagCompound.setBoolean("hilightMode", this.hilightMode);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"scan", (BlockPos)this.scan);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"minBox", (BlockPos)this.minBox);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"maxBox", (BlockPos)this.maxBox);
    }

    public void requestCurrentLevel() {
        this.requestDataFromServer("rftools", CMD_GETLEVEL, TypedMap.EMPTY);
    }

    public static int getCurrentLevelClientSide() {
        return currentLevel;
    }

    public int getCurrentLevel() {
        return this.scan == null ? -1 : this.scan.getY();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETROTATE.equals(command)) {
            this.setRotate(Integer.parseInt((String)params.get(ChoiceLabel.PARAM_CHOICE)) / 90);
            return true;
        }
        if (CMD_SETANCHOR.equals(command)) {
            this.setAnchor((Integer)params.get(PARAM_ANCHOR_INDEX));
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            this.setMode((Integer)params.get(ChoiceLabel.PARAM_CHOICE_IDX));
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if (PacketGetHudLog.CMD_GETHUDLOG.equals(command)) {
            return type.convert(this.getHudLog());
        }
        return rc;
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if (PacketGetHudLog.CLIENTCMD_GETHUDLOG.equals(command)) {
            this.clientHudLog = Type.STRING.convert(list);
            return true;
        }
        return false;
    }

    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GETLEVEL.equals(command)) {
            return TypedMap.builder().put(PARAM_LEVEL, (Object)(this.scan == null ? -1 : this.scan.getY())).build();
        }
        return null;
    }

    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        boolean rc = super.receiveDataFromServer(command, result);
        if (rc) {
            return true;
        }
        if (CMD_GETLEVEL.equals(command)) {
            currentLevel = (Integer)result.get(PARAM_LEVEL);
            return true;
        }
        return false;
    }

    public void onBlockBreak(World world, BlockPos pos, IBlockState state) {
        if (this.hasSupportMode()) {
            this.clearSupportBlocks();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.pos, this.pos.add(1, 2, 1));
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        int scan = this.getCurrentLevel();
        probeInfo.text(TextFormatting.GREEN + "Current level: " + (scan == -1 ? "not scanning" : Integer.valueOf(scan)));
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            this.requestCurrentLevel();
        }
        int scan = BuilderTileEntity.getCurrentLevelClientSide();
        currenttip.add(TextFormatting.GREEN + "Current level: " + (scan == -1 ? "not scanning" : Integer.valueOf(scan)));
    }

    public void rotateBlock(EnumFacing axis) {
        super.rotateBlock(axis);
        if (!this.world.isRemote && this.hasSupportMode()) {
            this.clearSupportBlocks();
            this.resetBox();
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState metadata, int fortune) {
        super.getDrops(drops, world, pos, metadata, fortune);
        List<ItemStack> overflowItems = this.getOverflowItems();
        if (overflowItems != null) {
            drops.addAll(overflowItems);
        }
    }

    private static class TakeableItem {
        private final IItemHandler itemHandler;
        private final IInventory inventory;
        private final int slot;
        private final ItemStack peekStack;
        public static final TakeableItem EMPTY = new TakeableItem();

        private TakeableItem() {
            this.itemHandler = null;
            this.inventory = null;
            this.slot = -1;
            this.peekStack = ItemStack.EMPTY;
        }

        public TakeableItem(IItemHandler itemHandler, int slot) {
            Validate.inclusiveBetween((long)0L, (long)(itemHandler.getSlots() - 1), (long)slot);
            this.itemHandler = itemHandler;
            this.inventory = null;
            this.slot = slot;
            this.peekStack = itemHandler.extractItem(slot, 1, true);
        }

        public TakeableItem(IInventory inventory, int slot) {
            Validate.inclusiveBetween((long)0L, (long)(inventory.getSizeInventory() - 1), (long)slot);
            this.itemHandler = null;
            this.inventory = inventory;
            this.slot = slot;
            this.peekStack = inventory.getStackInSlot(slot).copy();
            this.peekStack.setCount(1);
        }

        public ItemStack peek() {
            return this.peekStack.copy();
        }

        public void take() {
            if (this.itemHandler != null) {
                this.itemHandler.extractItem(this.slot, 1, false);
            } else if (this.slot != -1) {
                this.inventory.decrStackSize(this.slot, 1);
            }
        }

        public ItemStack takeAndReplace(ItemStack replacement) {
            if (this.itemHandler != null) {
                this.itemHandler.extractItem(this.slot, 1, false);
                return this.itemHandler.insertItem(this.slot, replacement, false);
            }
            if (this.slot != -1) {
                this.inventory.decrStackSize(this.slot, 1);
                if (this.inventory.isItemValidForSlot(this.slot, replacement) && this.inventory.getStackInSlot(this.slot).isEmpty()) {
                    this.inventory.setInventorySlotContents(this.slot, replacement);
                    return ItemStack.EMPTY;
                }
            }
            return replacement;
        }
    }
}

