/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.Counter;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.blocks.builder.PacketChamberInfoReady;
import mcjty.rftools.blocks.builder.SpaceChamberRepository;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BuilderTools {
    public static void returnChamberInfo(EntityPlayer player) {
        ItemStack cardItem = player.getHeldItem(EnumHand.MAIN_HAND);
        if (cardItem.isEmpty() || cardItem.getTagCompound() == null) {
            return;
        }
        int channel = cardItem.getTagCompound().getInteger("channel");
        if (channel == -1) {
            return;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.getChannels(player.getEntityWorld());
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        if (chamberChannel == null) {
            return;
        }
        int dimension = chamberChannel.getDimension();
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            return;
        }
        Counter blocks = new Counter();
        Counter costs = new Counter();
        HashMap<IBlockState, ItemStack> stacks = new HashMap<IBlockState, ItemStack>();
        BlockPos minCorner = chamberChannel.getMinCorner();
        BlockPos maxCorner = chamberChannel.getMaxCorner();
        BuilderTools.findBlocks(player, (World)world, (Counter<IBlockState>)blocks, (Counter<IBlockState>)costs, stacks, minCorner, maxCorner);
        Counter entitiesWithCount = new Counter();
        Counter entitiesWithCost = new Counter();
        HashMap<String, Entity> firstEntity = new HashMap<String, Entity>();
        BuilderTools.findEntities((World)world, minCorner, maxCorner, (Counter<String>)entitiesWithCount, (Counter<String>)entitiesWithCost, firstEntity);
        RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketChamberInfoReady((Map<IBlockState, Integer>)blocks, (Map<IBlockState, Integer>)costs, stacks, (Map<String, Integer>)entitiesWithCount, (Map<String, Integer>)entitiesWithCost, firstEntity), (EntityPlayerMP)player);
    }

    private static void findEntities(World world, BlockPos minCorner, BlockPos maxCorner, Counter<String> entitiesWithCount, Counter<String> entitiesWithCost, Map<String, Entity> firstEntity) {
        List entities = world.getEntitiesWithinAABBExcludingEntity(null, new AxisAlignedBB((double)minCorner.getX(), (double)minCorner.getY(), (double)minCorner.getZ(), (double)(maxCorner.getX() + 1), (double)(maxCorner.getY() + 1), (double)(maxCorner.getZ() + 1)));
        for (Entity entity : entities) {
            EntityItem entityItem;
            String canonicalName = entity.getClass().getCanonicalName();
            if (entity instanceof EntityItem && !(entityItem = (EntityItem)entity).getItem().isEmpty()) {
                String displayName = entityItem.getItem().getDisplayName();
                canonicalName = canonicalName + " (" + displayName + ")";
            }
            entitiesWithCount.increment((Object)canonicalName);
            if (!firstEntity.containsKey(canonicalName)) {
                firstEntity.put(canonicalName, entity);
            }
            if (entity instanceof EntityPlayer) {
                entitiesWithCost.increment((Object)canonicalName, BuilderConfiguration.builderRfPerPlayer.get());
                continue;
            }
            entitiesWithCost.increment((Object)canonicalName, BuilderConfiguration.builderRfPerEntity.get());
        }
    }

    private static void findBlocks(EntityPlayer harvester, World world, Counter<IBlockState> blocks, Counter<IBlockState> costs, Map<IBlockState, ItemStack> stacks, BlockPos minCorner, BlockPos maxCorner) {
        for (int x = minCorner.getX(); x <= maxCorner.getX(); ++x) {
            for (int y = minCorner.getY(); y <= maxCorner.getY(); ++y) {
                for (int z = minCorner.getZ(); z <= maxCorner.getZ(); ++z) {
                    TileEntity te;
                    BuilderSetup.BlockInformation info;
                    ItemStack item;
                    Block block;
                    BlockPos p = new BlockPos(x, y, z);
                    IBlockState state = world.getBlockState(p);
                    if (BuilderTileEntity.isEmpty(state, block = state.getBlock())) continue;
                    blocks.increment((Object)state);
                    if (!stacks.containsKey(state) && !(item = block.getItem(world, p, state)).isEmpty()) {
                        stacks.put(state, item);
                    }
                    if ((info = BuilderTileEntity.getBlockInformation(harvester, world, p, block, te = world.getTileEntity(p))).getBlockLevel() == 2) {
                        costs.put((Object)state, (Object)-1);
                        continue;
                    }
                    costs.increment((Object)state, (int)((double)BuilderConfiguration.builderRfPerOperation.get() * info.getCostFactor()));
                }
            }
        }
    }
}

