/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.elevator;

import mcjty.rftools.blocks.elevator.ElevatorTileEntity;
import mcjty.rftools.blocks.elevator.FakeElevatorWorld;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ElevatorTESR
extends TileEntitySpecialRenderer<ElevatorTileEntity> {
    private static final BlockRenderLayer[] LAYERS = BlockRenderLayer.values();
    private final FakeElevatorWorld fakeWorld = new FakeElevatorWorld();

    public void render(ElevatorTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.isMoving()) {
            AxisAlignedBB aabb = te.getAABBAboveElevator(0.0);
            boolean on = Minecraft.getMinecraft().player.getEntityBoundingBox().intersects(aabb);
            double diff = on ? (double)te.getPos().getY() - (y + te.getMovingY()) - 1.0 : 0.0;
            GlStateManager.pushMatrix();
            RenderHelper.disableStandardItemLighting();
            this.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
            if (Minecraft.isAmbientOcclusionEnabled()) {
                GlStateManager.shadeModel((int)7425);
            } else {
                GlStateManager.shadeModel((int)7424);
            }
            IBlockState movingState = te.getMovingState();
            GlStateManager.translate((double)0.0, (double)(te.getMovingY() - (double)te.getPos().getY() + diff), (double)0.0);
            Tessellator tessellator = Tessellator.getInstance();
            BlockRendererDispatcher dispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
            BlockRenderLayer origLayer = MinecraftForgeClient.getRenderLayer();
            this.fakeWorld.setWorldAndState(te);
            for (BlockRenderLayer layer : LAYERS) {
                if (!movingState.getBlock().canRenderInLayer(movingState, layer)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                if (layer == BlockRenderLayer.TRANSLUCENT) {
                    GlStateManager.enableBlend();
                }
                for (BlockPos pos : te.getPositions()) {
                    tessellator.getBuffer().begin(7, DefaultVertexFormats.BLOCK);
                    int dx = te.getPos().getX() - pos.getX();
                    int dy = te.getPos().getY() - pos.getY();
                    int dz = te.getPos().getZ() - pos.getZ();
                    tessellator.getBuffer().setTranslation(x - (double)pos.getX() - (double)dx, y - (double)pos.getY() - (double)dy, z - (double)pos.getZ() - (double)dz);
                    ElevatorTESR.renderBlock(dispatcher, movingState, pos, this.fakeWorld, tessellator.getBuffer());
                    tessellator.draw();
                }
                if (layer != BlockRenderLayer.TRANSLUCENT) continue;
                GlStateManager.disableBlend();
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)origLayer);
            tessellator.getBuffer().setTranslation(0.0, 0.0, 0.0);
            RenderHelper.enableStandardItemLighting();
            GlStateManager.popMatrix();
        }
    }

    public boolean isGlobalRenderer(ElevatorTileEntity te) {
        return te.isMoving();
    }

    private static boolean renderBlock(BlockRendererDispatcher dispatcher, IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder worldRendererIn) {
        try {
            EnumBlockRenderType enumblockrendertype = state.getRenderType();
            if (enumblockrendertype == EnumBlockRenderType.INVISIBLE) {
                return false;
            }
            if (blockAccess.getWorldType() != WorldType.DEBUG_ALL_BLOCK_STATES) {
                try {
                    state = state.getActualState(blockAccess, pos);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            switch (enumblockrendertype) {
                case MODEL: {
                    IBakedModel model = dispatcher.getModelForState(state);
                    state = state.getBlock().getExtendedState(state, blockAccess, pos);
                    return dispatcher.getBlockModelRenderer().renderModel(blockAccess, model, state, pos, worldRendererIn, false);
                }
                case ENTITYBLOCK_ANIMATED: {
                    return false;
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Block being tesselated");
            CrashReportCategory.addBlockInfo((CrashReportCategory)crashreportcategory, (BlockPos)pos, (Block)state.getBlock(), (int)state.getBlock().getMetaFromState(state));
            throw new ReportedException(crashreport);
        }
    }

    public static void register() {
        ClientRegistry.bindTileEntitySpecialRenderer(ElevatorTileEntity.class, (TileEntitySpecialRenderer)new ElevatorTESR());
    }
}

