/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.threelogic;

import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.threelogic.ThreeLogicTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiThreeLogic
extends GenericGuiContainer<ThreeLogicTileEntity> {
    public GuiThreeLogic(ThreeLogicTileEntity threeLogicTileEntity, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)threeLogicTileEntity, (Container)container, GuiProxy.GUI_MANUAL_MAIN, "threelogic");
    }

    public void initGui() {
        this.window = new Window((GuiScreen)this, this.tileEntity, RFToolsMessages.INSTANCE, new ResourceLocation("rftools", "gui/threelogic.gui"));
        super.initGui();
        this.initializeFields();
        this.setupEvents();
    }

    private void setupEvents() {
        this.window.event("choice", (source, params) -> {
            String name = source.getName();
            int i = Integer.parseInt(name.substring(name.length() - 1));
            String current = (String)params.get(ChoiceLabel.PARAM_CHOICE);
            int st = "On".equals(current) ? 1 : ("Off".equals(current) ? 0 : -1);
            this.sendServerCommand(RFToolsMessages.INSTANCE, "logic.setState", TypedMap.builder().put(ThreeLogicTileEntity.PARAM_INDEX, (Object)i).put(ThreeLogicTileEntity.PARAM_STATE, (Object)st).build());
        });
    }

    private void initializeFields() {
        block4: for (int i = 0; i < 8; ++i) {
            ChoiceLabel tl = (ChoiceLabel)this.window.findChild("choice" + i);
            int state = ((ThreeLogicTileEntity)this.tileEntity).getState(i);
            switch (state) {
                case 0: {
                    tl.setChoice("Off");
                    continue block4;
                }
                case 1: {
                    tl.setChoice("On");
                    continue block4;
                }
                default: {
                    tl.setChoice("Keep");
                }
            }
        }
    }
}

